/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ITemplateProjectData;
import org.springsource.ide.eclipse.commons.content.core.util.ContentUtil;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TemplateProjectData
implements ITemplateProjectData {
    private final File path;
    private final String id;
    private Descriptor descriptor;
    private File zippedProject;
    private File jsonDescriptor;

    public TemplateProjectData(File path) {
        this.path = path;
        this.id = path.getName();
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private File getFile() {
        return new File(this.path, "template.xml");
    }

    private File getFileFromPath(Node node) throws SAXException {
        String filePath = ContentUtil.getAttributeValue((Node)node, (String)"path");
        if (filePath == null) {
            throw new SAXException("The project record is invalid");
        }
        return new File(String.valueOf(this.path.getAbsolutePath()) + File.separator + filePath);
    }

    public File getJsonDescriptor() {
        return this.jsonDescriptor;
    }

    public File getTemplateDirectory() {
        return this.path;
    }

    public File getZippedProject() {
        return this.zippedProject;
    }

    public void read() throws CoreException {
        File file = this.getFile();
        DocumentBuilder documentBuilder = ContentUtil.createDocumentBuilder();
        Document document = null;
        try {
            document = documentBuilder.parse(file);
            Element rootNode = document.getDocumentElement();
            if (rootNode == null) {
                throw new SAXException("No root node");
            }
            if (!"template".equals(rootNode.getNodeName())) {
                throw new SAXException("Not a valid template");
            }
            NodeList children = rootNode.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() == 1) {
                    if ("descriptor".equals(childNode.getNodeName())) {
                        this.descriptor = Descriptor.read((Node)childNode);
                    } else if ("project".equals(childNode.getNodeName())) {
                        this.zippedProject = this.getFileFromPath(childNode);
                    } else if ("json".equals(childNode.getNodeName())) {
                        this.jsonDescriptor = this.getFileFromPath(childNode);
                    }
                }
                ++i;
            }
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Could not read initialization data for template \"" + this.id + "\"", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Could not read initialization data for template \"" + this.id + "\"", (Throwable)e));
        }
    }
}

