/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.github.auth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.auth.Credentials;
import org.springframework.web.client.RestTemplate;

public class BasicAuthCredentials
extends Credentials {
    private final Pattern host;
    private final String username;
    private final String passwd;

    public BasicAuthCredentials(Pattern host, String username, String passwd) {
        this.host = host;
        this.username = username;
        this.passwd = passwd;
    }

    public String toString() {
        return "BasicAuthCredentials(" + this.username + ")";
    }

    private String computeAuthString() throws UnsupportedEncodingException {
        String authorisation = String.valueOf(this.username) + ":" + this.passwd;
        byte[] encodedAuthorisation = Base64.encodeBase64((byte[])authorisation.getBytes("utf8"));
        String authString = "Basic " + new String(encodedAuthorisation);
        return authString;
    }

    public RestTemplate apply(RestTemplate rest) {
        List interceptors = rest.getInterceptors();
        interceptors.add(new ClientHttpRequestInterceptor(){

            public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
                HttpHeaders headers;
                if (BasicAuthCredentials.this.matchHost(request.getURI().getHost()) && !(headers = request.getHeaders()).containsKey((Object)"Authorization")) {
                    String authString = BasicAuthCredentials.this.computeAuthString();
                    headers.add("Authorization", authString);
                }
                return execution.execute(request, body);
            }
        });
        return rest;
    }

    public void apply(URLConnection conn) {
        try {
            if (this.matchHost(conn.getURL().getHost())) {
                conn.setRequestProperty("Authorization", this.computeAuthString());
            }
        }
        catch (UnsupportedEncodingException e) {
            WizardPlugin.log(e);
        }
    }

    private boolean matchHost(String host) {
        if (this.host != null) {
            return this.host.matcher(host).matches();
        }
        return true;
    }
}

