/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.mylyn.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.resources.ui.ResourceStructureBridge;
import org.eclipse.swt.widgets.Display;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IClassMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataNode;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.ILazyInitializedModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansContextStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "spring/beans";

    public boolean acceptsObject(Object object) {
        return object instanceof IModelElement || object instanceof BeanMetadataNode || object instanceof BeanMetadataReference || object instanceof IBeanMetadata || object instanceof IFile && BeansContextStructureBridge.isBeansConfig((IFile)object);
    }

    public boolean canBeLandmark(String handle) {
        return true;
    }

    public boolean canFilter(Object obj) {
        AbstractContextStructureBridge parentBridge;
        IInteractionElement node;
        if (obj instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)obj;
            if (modelElement instanceof ISpringProject) {
                IBeansProject beansProject = BeansModelUtils.getProject((IModelElement)modelElement);
                return this.canFilter(beansProject);
            }
            if (obj instanceof IBeansConfig) {
                return true;
            }
            IInteractionElement node2 = ContextCore.getContextManager().getElement(this.getHandleIdentifier(obj));
            if (node2 != null && node2.getInterest().isInteresting()) {
                return false;
            }
        } else if (obj instanceof IFile && BeansContextStructureBridge.isBeansConfig((IFile)obj)) {
            node = ContextCore.getContextManager().getElement(this.getHandleIdentifier(obj));
            if (node != null && node.getInterest().isInteresting()) {
                return false;
            }
        } else if (obj instanceof BeanMetadataReference) {
            Object[] objectArray = ((BeanMetadataReference)obj).getChildren();
            int n = objectArray.length;
            int node2 = 0;
            while (node2 < n) {
                Object child = objectArray[node2];
                if (!this.canFilter(child)) {
                    return false;
                }
                ++node2;
            }
        } else if (obj instanceof BeanMetadataNode) {
            node = ContextCore.getContextManager().getElement(((BeanMetadataNode)obj).getHandleIdentifier());
            if (node != null && node.getInterest().isInteresting()) {
                return false;
            }
            Object[] objectArray = ((BeanMetadataNode)obj).getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (!this.canFilter(child)) {
                    return false;
                }
                ++n2;
            }
        } else if (obj instanceof IClassMetadata) {
            node = ContextCore.getContextManager().getElement(((IBeanMetadata)obj).getHandleIdentifier());
            if (node != null && node.getInterest().isInteresting()) {
                return false;
            }
            for (Object child : ((IClassMetadata)obj).getMethodMetaData()) {
                if (this.canFilter(child)) continue;
                return false;
            }
        } else if (obj instanceof IBeanMetadata && (node = ContextCore.getContextManager().getElement(((IBeanMetadata)obj).getHandleIdentifier())) != null && node.getInterest().isInteresting()) {
            return false;
        }
        return (parentBridge = ContextCore.getStructureBridge((String)this.parentContentType)) == null || parentBridge.canFilter(obj);
    }

    public List<String> getChildHandles(String handle) {
        Object obj = this.getObjectForHandle(handle);
        if (obj != null && obj instanceof IModelElement) {
            IModelElement[] children;
            ArrayList<String> childHandles = new ArrayList<String>();
            IModelElement[] iModelElementArray = children = ((IModelElement)obj).getElementChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                childHandles.add(child.getElementID());
                ++n2;
            }
            return childHandles;
        }
        return Collections.emptyList();
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String handle) {
        Object obj = this.getObjectForHandle(handle);
        if (obj instanceof IModelElement) {
            return CONTENT_TYPE;
        }
        return "resource";
    }

    public String getHandleForOffsetInObject(Object arg0, int arg1) {
        return null;
    }

    public String getHandleIdentifier(Object obj) {
        if (obj instanceof IModelElement) {
            return ((IModelElement)obj).getElementID();
        }
        if (obj instanceof IBeanMetadata) {
            return ((IBeanMetadata)obj).getHandleIdentifier();
        }
        if (obj instanceof IFile && BeansContextStructureBridge.isBeansConfig((IFile)obj)) {
            return BeansModelUtils.getResourceModelElement((Object)obj).getElementID();
        }
        return null;
    }

    public String getLabel(Object obj) {
        if (obj instanceof IModelElement) {
            return ((IModelElement)obj).getElementName();
        }
        if (obj instanceof IFile && BeansContextStructureBridge.isBeansConfig((IFile)obj)) {
            return BeansModelUtils.getResourceModelElement((Object)obj).getElementName();
        }
        return null;
    }

    public Object getObjectForHandle(String handle) {
        AbstractContextStructureBridge parentBridge;
        Object obj = null;
        if (handle != null) {
            obj = BeansCorePlugin.getModel().getElement(handle);
            if (obj != null) {
                return obj;
            }
            obj = SpringCore.getModel().getElement(handle);
            if (obj != null) {
                return obj;
            }
        }
        if ((parentBridge = ContextCore.getStructureBridge((String)this.parentContentType)) != null) {
            obj = parentBridge.getObjectForHandle(handle);
        }
        return obj;
    }

    public String getParentHandle(String handle) {
        Object obj = this.getObjectForHandle(handle);
        if (obj instanceof IBeansProject) {
            return SpringCore.getModel().getProject(((IBeansProject)obj).getProject()).getElementID();
        }
        if (obj instanceof ISpringProject) {
            AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
            if (parentBridge != null && parentBridge instanceof ResourceStructureBridge) {
                return parentBridge.getHandleIdentifier((Object)((ISpringProject)obj).getProject());
            }
        } else if (obj != null && obj instanceof IModelElement) {
            IModelElement parent = ((IModelElement)obj).getElementParent();
            if (parent != null) {
                return parent.getElementID();
            }
        } else {
            AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
            if (parentBridge != null && parentBridge instanceof ResourceStructureBridge) {
                return parentBridge.getParentHandle(handle);
            }
        }
        return null;
    }

    public boolean isDocument(String handle) {
        Object obj = this.getObjectForHandle(handle);
        return obj != null && obj instanceof IBeansConfig;
    }

    public static boolean isBeansConfig(IFile configFile) {
        return BeansContextStructureBridge.isBeansConfig(configFile, true);
    }

    private static IBeansConfig getBeansConfig(IFile configFile, IBeansProject project, boolean includeImports) {
        for (String suffix : project.getConfigSuffixes()) {
            IBeansConfig bc;
            if (!configFile.getName().endsWith(suffix)) continue;
            if (includeImports && Display.getCurrent() != null && project instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)project).isInitialized()) {
                includeImports = false;
            }
            if ((bc = project.getConfig(configFile, includeImports)) == null) continue;
            return bc;
        }
        return null;
    }

    private static boolean isBeansConfig(IFile configFile, boolean includeImports) {
        IBeansConfig bc;
        IBeansProject project = BeansCorePlugin.getModel().getProject(configFile.getProject());
        if (project != null && (bc = BeansContextStructureBridge.getBeansConfig(configFile, project, includeImports)) != null) {
            return true;
        }
        for (IBeansProject p : BeansCorePlugin.getModel().getProjects()) {
            IBeansConfig bc2 = BeansContextStructureBridge.getBeansConfig(configFile, p, includeImports);
            if (bc2 == null) continue;
            return true;
        }
        return false;
    }
}

