/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private XMLUtil() {
    }

    public static byte[] toByteArray(Document document) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(512);
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((OutputStream)byteOut, format);
        writer.write(document);
        return byteOut.toByteArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InternalDtdEntityResolver
    implements EntityResolver {
        private final Map<String, String> mPublic2InternalDtdMap;

        public InternalDtdEntityResolver(Map<String, String> public2InternalDtdMap) {
            this.mPublic2InternalDtdMap = public2InternalDtdMap;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (this.mPublic2InternalDtdMap.containsKey(publicId)) {
                String dtdResourceName = this.mPublic2InternalDtdMap.get(publicId);
                InputStream dtdIS = this.getClass().getClassLoader().getResourceAsStream(dtdResourceName);
                if (dtdIS == null) {
                    throw new SAXException("Unable to load internal dtd " + dtdResourceName);
                }
                return new InputSource(dtdIS);
            }
            return null;
        }
    }
}

