/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionClassLoader
extends ClassLoader {
    private List<Bundle> mBundles = new ArrayList<Bundle>();

    public ExtensionClassLoader(Bundle sourceBundle, String extensionPointId) {
        IExtension[] extensions;
        this.mBundles.add(sourceBundle);
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extPt = pluginRegistry.getExtensionPoint(extensionPointId);
        IExtension[] iExtensionArray = extensions = extPt.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            String contributorId = ext.getContributor().getName();
            Bundle extensionBundle = Platform.getBundle((String)contributorId);
            if (extensionBundle != null) {
                this.mBundles.add(extensionBundle);
            }
            ++n2;
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class cl = null;
        for (Bundle bundle : this.mBundles) {
            try {
                cl = bundle.loadClass(name);
                if (cl == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (cl == null) {
            throw new ClassNotFoundException(name);
        }
        return cl;
    }

    @Override
    public URL getResource(String name) {
        URL resource = null;
        for (Bundle bundle : this.mBundles) {
            resource = bundle.getResource(name);
            if (resource != null) break;
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList resources = new ArrayList();
        for (Bundle bundle : this.mBundles) {
            Enumeration bundleResources = bundle.getResources(name);
            if (bundleResources == null) continue;
            resources.addAll(Collections.list(bundleResources));
        }
        return Collections.enumeration(resources);
    }
}

