/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig;

import java.util.ArrayList;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class PluginFilters {
    private static final String FILTER_EXTENSION_POINT = "net.sf.eclipsecs.core.filters";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_INTERNAL_NAME = "internal-name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_READONLY = "readonly";
    private static final String ATTR_SELECTED = "selected";
    private static final String ATTR_VALUE = "value";
    private static final String TAG_DATA = "data";
    private static final IFilter[] FILTER_PROTOTYPES;

    static {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = pluginRegistry.getConfigurationElementsFor(FILTER_EXTENSION_POINT);
        ArrayList<IFilter> filters = new ArrayList<IFilter>();
        int i = 0;
        while (i < elements.length) {
            try {
                String name = elements[i].getAttribute(ATTR_NAME);
                String internalName = elements[i].getAttribute(ATTR_INTERNAL_NAME);
                String desc = elements[i].getAttribute(ATTR_DESCRIPTION);
                boolean readOnly = Boolean.valueOf(elements[i].getAttribute(ATTR_READONLY));
                IFilter filter = (IFilter)elements[i].createExecutableExtension(ATTR_CLASS);
                filter.initialize(name, internalName, desc, readOnly);
                boolean defaultState = Boolean.valueOf(elements[i].getAttribute(ATTR_SELECTED));
                filter.setEnabled(defaultState);
                ArrayList<String> data = new ArrayList<String>();
                IConfigurationElement[] dataTags = elements[i].getChildren(TAG_DATA);
                int size = dataTags != null ? dataTags.length : 0;
                int j = 0;
                while (j < size) {
                    data.add(dataTags[j].getAttribute(ATTR_VALUE));
                    ++j;
                }
                filter.setFilterData(data);
                filters.add(filter);
            }
            catch (Exception e) {
                CheckstyleLog.log(e);
            }
            ++i;
        }
        FILTER_PROTOTYPES = filters.toArray(new IFilter[filters.size()]);
    }

    private PluginFilters() {
    }

    public static IFilter[] getConfiguredFilters() {
        IFilter[] mFilter = new IFilter[FILTER_PROTOTYPES.length];
        int i = 0;
        while (i < mFilter.length) {
            mFilter[i] = FILTER_PROTOTYPES[i].clone();
            ++i;
        }
        return mFilter;
    }

    public static IFilter getByInternalName(String internalName) {
        IFilter filter = null;
        int i = 0;
        while (i < FILTER_PROTOTYPES.length) {
            if (FILTER_PROTOTYPES[i].getInternalName().equals(internalName)) {
                filter = FILTER_PROTOTYPES[i].clone();
                break;
            }
            ++i;
        }
        return filter;
    }
}

