/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;

public class InternalConfigurationType
extends ConfigurationType {
    public static String resolveLocationInWorkspace(String location) {
        IPath configPath = CheckstylePlugin.getDefault().getStateLocation();
        configPath = configPath.append(location);
        return configPath.toString();
    }

    protected URL resolveLocation(ICheckConfiguration checkConfiguration) throws IOException {
        String location = checkConfiguration.getLocation();
        location = InternalConfigurationType.resolveLocationInWorkspace(location);
        return new File(location).toURI().toURL();
    }

    public void notifyCheckConfigRemoved(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
        super.notifyCheckConfigRemoved(checkConfiguration);
        URL configFileURL = checkConfiguration.getResolvedConfigurationFileURL();
        if (configFileURL != null) {
            File configFile = FileUtils.toFile((URL)configFileURL);
            configFile.delete();
        }
    }
}

