/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.eclipsecs.core.config.ConfigProperty;
import net.sf.eclipsecs.core.config.Module;
import net.sf.eclipsecs.core.config.Severity;
import net.sf.eclipsecs.core.config.meta.MetadataFactory;
import net.sf.eclipsecs.core.config.meta.RuleMetadata;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.core.util.XMLUtil;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationReader {
    private static final Pattern PROPERTY_REF_PATTERN = Pattern.compile("^.*\\$\\{.*\\}.*$");
    private static final Map<String, String> PUBLIC2INTERNAL_DTD_MAP = new HashMap<String, String>();

    static {
        PUBLIC2INTERNAL_DTD_MAP.put("-//Puppy Crawl//DTD Check Configuration 1.0//EN", "com/puppycrawl/tools/checkstyle/configuration_1_0.dtd");
        PUBLIC2INTERNAL_DTD_MAP.put("-//Puppy Crawl//DTD Check Configuration 1.1//EN", "com/puppycrawl/tools/checkstyle/configuration_1_1.dtd");
        PUBLIC2INTERNAL_DTD_MAP.put("-//Puppy Crawl//DTD Check Configuration 1.2//EN", "com/puppycrawl/tools/checkstyle/configuration_1_2.dtd");
        PUBLIC2INTERNAL_DTD_MAP.put("-//Puppy Crawl//DTD Check Configuration 1.3//EN", "com/puppycrawl/tools/checkstyle/configuration_1_3.dtd");
    }

    private ConfigurationReader() {
    }

    public static List<Module> read(InputSource in) throws CheckstylePluginException {
        List<Object> rules = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)new XMLUtil.InternalDtdEntityResolver(PUBLIC2INTERNAL_DTD_MAP));
            Document document = reader.read(in);
            rules = ConfigurationReader.getModules(document);
        }
        catch (DocumentException ex) {
            CheckstylePluginException.rethrow(ex);
        }
        return rules != null ? rules : new ArrayList();
    }

    public static AdditionalConfigData getAdditionalConfigData(InputSource in) throws CheckstylePluginException {
        List<Module> modules = ConfigurationReader.read(in);
        int tabWidth = 8;
        for (Module module : modules) {
            if (module.getMetaData() == null || !module.getMetaData().getInternalName().equals("TreeWalker")) continue;
            ConfigProperty prop = module.getProperty("tabWidth");
            String tabWidthProp = null;
            if (prop != null) {
                tabWidthProp = prop.getValue();
            }
            if (tabWidthProp == null && prop != null && prop.getMetaData() != null) {
                tabWidthProp = prop.getMetaData().getDefaultValue();
            }
            try {
                tabWidth = Integer.parseInt(tabWidthProp);
            }
            catch (Exception exception) {}
            break;
        }
        return new AdditionalConfigData(tabWidth);
    }

    private static List<Module> getModules(Document document) {
        final ArrayList<Module> modules = new ArrayList<Module>();
        document.accept((Visitor)new VisitorSupport(){

            public void visit(Element node) {
                if ("module".equals(node.getName())) {
                    String name = node.attributeValue("name");
                    RuleMetadata metadata = MetadataFactory.getRuleMetadata(name);
                    Module module = null;
                    module = metadata != null ? new Module(metadata, true) : new Module(name);
                    ConfigurationReader.addProperties(node, module);
                    ConfigurationReader.addMessages(node, module);
                    ConfigurationReader.addMetadata(node, module);
                    if (module.getMetaData() == null) {
                        MetadataFactory.createGenericMetadata(module);
                    }
                    modules.add(module);
                }
            }
        });
        return modules;
    }

    private static void addProperties(Element moduleEl, Module module) {
        List propertyEls = moduleEl.elements("property");
        for (Element propertyEl : propertyEls) {
            ConfigProperty property;
            boolean isPropertyRef;
            String name = propertyEl.attributeValue("name");
            String value = propertyEl.attributeValue("value");
            boolean bl = isPropertyRef = value != null && PROPERTY_REF_PATTERN.matcher(value).matches();
            if (name.equals("severity") && module.getMetaData() != null && module.getMetaData().hasSeverity()) {
                try {
                    module.setSeverity(Severity.valueOf(value));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    module.setSeverity(Severity.inherit);
                }
                continue;
            }
            if (name.equals("id")) {
                module.setId(StringUtils.trimToNull((String)value));
                continue;
            }
            if (module.getMetaData() != null) {
                property = module.getProperty(name);
                if (property == null) continue;
                property.setValue(value);
                property.setPropertyReference(isPropertyRef);
                continue;
            }
            property = new ConfigProperty(name, value);
            property.setPropertyReference(isPropertyRef);
            module.getProperties().add(property);
        }
    }

    private static void addMessages(Element moduleEl, Module module) {
        List messageEls = moduleEl.elements("message");
        for (Element messageEl : messageEls) {
            String key = messageEl.attributeValue("key");
            String value = messageEl.attributeValue("value");
            module.getCustomMessages().put(key, value);
        }
    }

    private static void addMetadata(Element moduleEl, Module module) {
        List metaEls = moduleEl.elements("metadata");
        for (Element metaEl : metaEls) {
            String name = metaEl.attributeValue("name");
            String value = metaEl.attributeValue("value");
            if ("net.sf.eclipsecs.core.comment".equals(name)) {
                module.setComment(value);
                continue;
            }
            if ("net.sf.eclipsecs.core.lastEnabledSeverity".equals(name)) {
                module.setLastEnabledSeverity(Severity.valueOf(value));
                continue;
            }
            module.getCustomMetaData().put(name, value);
        }
    }

    public static class AdditionalConfigData {
        private final int mTabWidth;

        public AdditionalConfigData(int tabWidth) {
            this.mTabWidth = tabWidth;
        }

        public int getTabWidth() {
            return this.mTabWidth;
        }
    }
}

