/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.wizards;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.wizards.BeansWizardsMessages;
import org.springframework.ide.eclipse.core.model.IModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkToBeansConfigSetWizardPage
extends WizardPage {
    private static final int BEANS_CONFIG_LIST_VIEWER_HEIGHT = 150;
    private static final int LIST_VIEWER_WIDTH = 340;
    private CheckboxTableViewer beansConfigSetViewer;

    protected LinkToBeansConfigSetWizardPage(String pageName) {
        super(pageName);
        this.setTitle(BeansWizardsMessages.NewConfig_title);
        this.setDescription(BeansWizardsMessages.NewConfig_configSetDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.setControl((Control)composite);
        Label beansLabel = new Label(composite, 0);
        beansLabel.setText("Select Beans Config Sets to add the new Spring Bean definition to:");
        this.beansConfigSetViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 340;
        gd.heightHint = 150;
        this.beansConfigSetViewer.getTable().setLayoutData((Object)gd);
        this.beansConfigSetViewer.setContentProvider((IContentProvider)new BeansConfigContentProvider(this.createBeansConfigList()));
        this.beansConfigSetViewer.setLabelProvider((IBaseLabelProvider)new BeansConfigSetLabelProvider());
        this.beansConfigSetViewer.setInput((Object)this);
    }

    private Set<IModelElement> createBeansConfigList() {
        HashSet<IModelElement> configs = new HashSet<IModelElement>();
        Set beansProjects = BeansCorePlugin.getModel().getProjects();
        for (IBeansProject project : beansProjects) {
            configs.addAll(project.getConfigSets());
        }
        return configs;
    }

    public Set<IBeansConfigSet> getBeansConfigSets() {
        HashSet<IBeansConfigSet> configs = new HashSet<IBeansConfigSet>();
        Object[] checkedElements = this.beansConfigSetViewer.getCheckedElements();
        if (checkedElements != null) {
            int i = 0;
            while (i < checkedElements.length) {
                configs.add((IBeansConfigSet)checkedElements[i]);
                ++i;
            }
        }
        return configs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeansConfigContentProvider
    implements IStructuredContentProvider {
        private Set<IModelElement> configs;

        public BeansConfigContentProvider(Set<IModelElement> configs) {
            this.configs = configs;
        }

        public Object[] getElements(Object obj) {
            return this.configs.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class BeansConfigSetLabelProvider
    implements ILabelProvider {
        private BeansModelLabelProvider labelProvider = new BeansModelLabelProvider();

        private BeansConfigSetLabelProvider() {
        }

        public String getText(Object element) {
            String str = this.labelProvider.getText(element);
            if (element instanceof IBeansModelElement) {
                str = String.valueOf(str) + " - " + ((IBeansModelElement)element).getElementParent().getElementName();
            }
            return str;
        }

        public Image getImage(Object element) {
            return this.labelProvider.getImage(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.labelProvider.addListener(listener);
        }

        public void dispose() {
            this.labelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.labelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.labelProvider.removeListener(listener);
        }
    }
}

