/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties.model;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansJavaConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelProvider;

public class PropertiesModelLabelProvider
extends BeansModelLabelProvider
implements IColorProvider {
    private Color grayColor = new Color((Device)Display.getDefault(), 150, 150, 150);

    protected String getText(Object element, Object parentElement) {
        if (element instanceof IBeansConfig) {
            String text = ((IBeansConfig)element).getElementName();
            if (text.startsWith("external:/")) {
                text = text.substring("external:/".length());
            }
            if (element instanceof BeansJavaConfig) {
                IType configClass = ((BeansJavaConfig)element).getConfigClass();
                text = configClass != null ? ((BeansJavaConfig)element).getConfigClass().getElementName() : ((BeansJavaConfig)element).getConfigClassName();
            }
            return text;
        }
        return super.getText(element, parentElement);
    }

    protected Image getImage(Object element, Object parentElement) {
        if (element instanceof BeansJavaConfig) {
            return super.getImage((Object)((BeansJavaConfig)element).getConfigClass());
        }
        return super.getImage(element, parentElement);
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IBeansConfig && ((IBeansConfig)element).getType() == IBeansConfig.Type.AUTO_DETECTED) {
            return this.grayColor;
        }
        if (element instanceof IBeansConfigSet && ((IBeansConfigSet)element).getType() == IBeansConfigSet.Type.AUTO_DETECTED) {
            return this.grayColor;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.grayColor.dispose();
    }
}

