/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.namespaces;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.namespaces.IImageAccessor;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamespaceDefinition
implements INamespaceDefinition {
    public static final Pattern VERSION_PATTERN = Pattern.compile(".*-([0-9,.]*)\\.xsd");
    private final String defaultLocation;
    private final IImageAccessor imageAccessor;
    private Set<String> locations = new HashSet<String>();
    private final String defaultPrefix;
    private final String uri;
    private Properties uriMapping = new Properties();

    public DefaultNamespaceDefinition(String prefix, String uri, String defaultLocation, IImageAccessor imageAccessor) {
        this(prefix, uri, defaultLocation, new Properties(), imageAccessor);
    }

    public DefaultNamespaceDefinition(String prefix, String uri, String defaultLocation, final Image image) {
        this(prefix, uri, defaultLocation, new IImageAccessor(){

            public Image getImage() {
                return image;
            }
        });
    }

    public DefaultNamespaceDefinition(String prefix, String uri, String defaultLocation, Properties namespaceDefinition, IImageAccessor imageAccessor) {
        if (prefix != null) {
            this.defaultPrefix = prefix;
        } else {
            int ix = uri.lastIndexOf(47);
            this.defaultPrefix = uri.substring(ix + 1);
        }
        this.uri = uri;
        this.defaultLocation = defaultLocation;
        this.uriMapping = namespaceDefinition;
        this.imageAccessor = imageAccessor;
    }

    public void addSchemaLocation(String location) {
        this.locations.add(location);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultNamespaceDefinition) {
            DefaultNamespaceDefinition o = (DefaultNamespaceDefinition)obj;
            return o.defaultPrefix.equals(this.defaultPrefix) && o.uri.equals(this.uri);
        }
        return false;
    }

    @Override
    public String getDefaultNamespacePrefix() {
        return this.defaultPrefix;
    }

    @Override
    public String getDefaultSchemaLocation() {
        return this.getDefaultSchemaLocation(null);
    }

    @Override
    public String getDefaultSchemaLocation(IResource resource) {
        String location = null;
        if (this.hasProjectSpecificOptions(resource)) {
            SpringCorePreferences prefs = SpringCorePreferences.getProjectPreferences((IProject)resource.getProject(), (String)"org.springframework.ide.eclipse.beans.core");
            if (prefs.getBoolean("default.version.check.classpath", true)) {
                location = this.getDefaultSchemaLocationFromClasspath(resource);
            }
            if ("".equals(location) || location == null) {
                location = prefs.getString("default.version." + this.getNamespaceURI(), "");
            }
        } else {
            Preferences prefs = BeansCorePlugin.getDefault().getPluginPreferences();
            if (prefs.getBoolean("default.version.check.classpath")) {
                location = this.getDefaultSchemaLocationFromClasspath(resource);
            }
            if ("".equals(location) || location == null) {
                location = prefs.getString("default.version." + this.getNamespaceURI());
            }
        }
        if ("".equals(location) || location == null) {
            return this.defaultLocation;
        }
        return location;
    }

    @Override
    public Image getNamespaceImage() {
        if (this.imageAccessor != null) {
            return this.imageAccessor.getImage();
        }
        return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
    }

    @Override
    public String getNamespacePrefix() {
        return this.defaultPrefix;
    }

    @Override
    public String getNamespacePrefix(IResource resource) {
        String prefix = null;
        if (this.hasProjectSpecificOptions(resource)) {
            SpringCorePreferences prefs = SpringCorePreferences.getProjectPreferences((IProject)resource.getProject(), (String)"org.springframework.ide.eclipse.beans.core");
            prefix = prefs.getString("prefix." + this.getNamespaceURI(), "");
        } else {
            Preferences prefs = BeansCorePlugin.getDefault().getPluginPreferences();
            prefix = prefs.getString("prefix." + this.getNamespaceURI());
        }
        if (StringUtils.hasLength((String)prefix)) {
            return prefix;
        }
        return this.defaultPrefix;
    }

    @Override
    public String getNamespaceURI() {
        return this.uri;
    }

    @Override
    public Set<String> getSchemaLocations() {
        return this.locations;
    }

    public int hashCode() {
        return this.defaultPrefix.hashCode() ^ this.uri.hashCode();
    }

    private String getDefaultSchemaLocationFromClasspath(IResource resource) {
        IJavaProject jp = JdtUtils.getJavaProject((IResource)resource);
        HashSet<String> existingLocations = new HashSet<String>();
        try {
            for (Map.Entry<Object, Object> entry : this.uriMapping.entrySet()) {
                if (!((String)entry.getKey()).startsWith(this.uri)) continue;
                String fileLocation = (String)entry.getValue();
                String packageName = "";
                int ix = fileLocation.lastIndexOf(47);
                if (ix > 0) {
                    packageName = fileLocation.substring(0, ix).replace('/', '.');
                }
                IPackageFragmentRoot[] iPackageFragmentRootArray = jp.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    IPackageFragment pf = root.getPackageFragment(packageName);
                    if (pf.exists()) {
                        Object[] objectArray = pf.getNonJavaResources();
                        int n3 = objectArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object obj = objectArray[n4];
                            if (obj instanceof JarEntryFile && ("/" + fileLocation).equals(((JarEntryFile)obj).getFullPath().toString()) && this.locations.contains(entry.getKey())) {
                                existingLocations.add((String)entry.getKey());
                            } else if (obj instanceof IFile && fileLocation.equals(String.valueOf(pf.getElementName().replace('.', '/')) + "/" + ((IFile)obj).getName()) && this.locations.contains(entry.getKey())) {
                                existingLocations.add((String)entry.getKey());
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        String highestLocation = null;
        Version version = Version.MINIMUM_VERSION;
        for (String location : existingLocations) {
            Version tempVersion = Version.MINIMUM_VERSION;
            Matcher matcher = VERSION_PATTERN.matcher(location);
            if (matcher.matches()) {
                tempVersion = new Version(matcher.group(1));
            }
            if (tempVersion.compareTo(version) < 0) continue;
            version = tempVersion;
            highestLocation = location;
        }
        return highestLocation;
    }

    private boolean hasProjectSpecificOptions(IResource resource) {
        if (resource == null) {
            return false;
        }
        return SpringCorePreferences.getProjectPreferences((IProject)resource.getProject(), (String)"org.springframework.ide.eclipse.beans.core").getBoolean("enable.project.preferences", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Version
    implements Comparable<Version> {
        private static final String MINIMUM_VERSION_STRING = "0";
        public static final Version MINIMUM_VERSION = new Version("0");
        private final org.osgi.framework.Version version;

        public Version(String v) {
            org.osgi.framework.Version tempVersion = null;
            try {
                tempVersion = org.osgi.framework.Version.parseVersion((String)v);
            }
            catch (Exception e) {
                BeansCorePlugin.log((String)"Cannot convert schema vesion", (Throwable)e);
                tempVersion = org.osgi.framework.Version.parseVersion((String)MINIMUM_VERSION_STRING);
            }
            this.version = tempVersion;
        }

        @Override
        public int compareTo(Version v2) {
            return this.version.compareTo(v2.version);
        }
    }
}

