/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.model.IModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansUIActivationHistory {
    private static List<String> HISTORY = new CopyOnWriteArrayList<String>();

    public static void clearHistory() {
        HISTORY = new CopyOnWriteArrayList<String>();
    }

    public static void addToHistory(IModelElement modelElement) {
        if (modelElement != null && modelElement.getElementID() != null) {
            HISTORY.add(modelElement.getElementID());
        }
    }

    public static Set<IModelElement> getActivationHistory() {
        LinkedHashSet<IModelElement> history = new LinkedHashSet<IModelElement>();
        for (String elementId : HISTORY) {
            IModelElement element = BeansCorePlugin.getModel().getElement(elementId);
            if (element == null) continue;
            history.add(element);
        }
        return history;
    }

    public static List<IBean> getBeanActivationHistory() {
        ArrayList<IBean> history = new ArrayList<IBean>();
        for (String elementId : HISTORY) {
            IModelElement element = BeansCorePlugin.getModel().getElement(elementId);
            if (!(element instanceof IBean)) continue;
            history.add((IBean)element);
        }
        return history;
    }
}

