/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.decorator;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.model.IAnnotationAopDefinition;
import org.springframework.ide.eclipse.aop.core.model.IAopModelChangedListener;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceAopTargetBeanNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceAopTargetMethodNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceDeclareParentAopSourceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceRootAopReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedAopSourceMethodNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedAopSourceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedDeclareParentAopSourceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.BeanMethodReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.BeanReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelImages;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class AopReferenceModelImageDecorator
extends BeansModelLabelDecorator
implements ILightweightLabelDecorator {
    public static final String DECORATOR_ID = "org.springframework.ide.eclipse.aop.ui.decorator.adviceimagedecorator";
    private IAopModelChangedListener listener = new IAopModelChangedListener(){

        public void changed() {
            AopReferenceModelImageDecorator.this.internalUpdate();
        }
    };

    private void internalUpdate() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IBaseLabelProvider provider = PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider("org.springframework.ide.eclipse.beans.ui.model.beansModelLabelDecorator");
                if (provider != null) {
                    AopReferenceModelImageDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent(provider));
                }
                AopReferenceModelImageDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)AopReferenceModelImageDecorator.this));
            }
        });
    }

    public AopReferenceModelImageDecorator() {
        Activator.getModel().registerAopModelChangedListener(this.listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IMethod || element instanceof SourceType) {
            IJavaElement je = (IJavaElement)element;
            IJavaProject jp = je.getJavaProject();
            if (jp != null && SpringCoreUtils.isSpringProject((IResource)jp.getProject()) && je instanceof IMethod && Activator.getModel().isAdvised(je)) {
                decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ADVICE, 0);
            }
        } else if (element instanceof BeanMethodReferenceNode && Activator.getModel().isAdvised(((BeanMethodReferenceNode)element).getJavaElement())) {
            decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ADVICE, 0);
        } else if (element instanceof AdviceAopTargetMethodNode) {
            decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ADVICE, 0);
        } else if (element instanceof AdviceAopTargetBeanNode) {
            decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ADVICE, 0);
        } else if (element instanceof BeanReferenceNode && Activator.getModel().isAdvised(((BeanReferenceNode)element).getBean())) {
            decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ADVICE, 0);
        } else if (element instanceof AdvisedAopSourceMethodNode) {
            if (Activator.getModel().isAdvised((IJavaElement)((AdvisedAopSourceMethodNode)element).getReference().getSource())) {
                decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ADVICE, 0);
            }
        } else if (element instanceof AdviceRootAopReferenceNode) {
            List<IAopReference> references = ((AdviceRootAopReferenceNode)element).getReference();
            for (IAopReference reference : references) {
                if (!(reference.getDefinition() instanceof IAnnotationAopDefinition)) continue;
                decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ANNOTATION, 2);
                break;
            }
        } else if (element instanceof AdvisedAopSourceNode) {
            IAopReference reference = ((AdvisedAopSourceNode)element).getReference();
            if (reference.getDefinition() instanceof IAnnotationAopDefinition) {
                decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ANNOTATION, 2);
            }
        } else if (element instanceof AdviceDeclareParentAopSourceNode) {
            IAopReference reference = ((AdviceDeclareParentAopSourceNode)element).getReference();
            if (reference.getDefinition() instanceof IAnnotationAopDefinition) {
                decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ANNOTATION, 2);
            }
        } else if (element instanceof AdvisedDeclareParentAopSourceNode) {
            IAopReference reference = ((AdvisedDeclareParentAopSourceNode)element).getReference();
            if (reference.getDefinition() instanceof IAnnotationAopDefinition) {
                decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ANNOTATION, 2);
            }
        } else if (element instanceof IBean) {
            IBean bean = (IBean)element;
            if (Activator.getModel().isAdvised(bean)) {
                decoration.addOverlay(AopReferenceModelImages.DESC_OVR_ADVICE, 0);
            }
        }
        if (element instanceof IReferenceNode && ((IReferenceNode)element).getReferenceParticipant() != null) {
            super.decorate(((IReferenceNode)element).getReferenceParticipant(), decoration);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            Activator.getModel().unregisterAopModelChangedListener(this.listener);
        }
    }
}

