/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.views;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.stats.Messages;
import net.sf.eclipsecs.ui.stats.data.MarkerStat;
import net.sf.eclipsecs.ui.stats.data.Stats;
import net.sf.eclipsecs.ui.stats.views.AbstractStatsView;
import net.sf.eclipsecs.ui.stats.views.GraphStatsView;
import net.sf.eclipsecs.ui.stats.views.internal.FiltersAction;
import net.sf.eclipsecs.ui.util.table.EnhancedTableViewer;
import net.sf.eclipsecs.ui.util.table.ITableComparableProvider;
import net.sf.eclipsecs.ui.util.table.ITableSettingsProvider;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class MarkerStatsView
extends AbstractStatsView {
    public static final String VIEW_ID = MarkerStatsView.class.getName();
    private static final String TAG_SECTION_MASTER = "masterView";
    private static final String TAG_SECTION_DETAIL = "detailView";
    private Label mDescLabel;
    private Composite mMainSection;
    private StackLayout mStackLayout;
    private EnhancedTableViewer mMasterViewer;
    private EnhancedTableViewer mDetailViewer;
    private Action mChartAction;
    private Action mDrillDownAction;
    private Action mDrillBackAction;
    private Action mShowErrorAction;
    private String mCurrentDetailCategory;
    private boolean mIsDrilledDown;
    private String mLastExportFolderName;
    private String mLastExportFileName = "CheckstyleStatsExport";

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.mDescLabel = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mDescLabel.setLayoutData((Object)gridData);
        this.mMainSection = new Composite(parent, 0);
        this.mStackLayout = new StackLayout();
        this.mStackLayout.marginHeight = 0;
        this.mStackLayout.marginWidth = 0;
        this.mMainSection.setLayout((Layout)this.mStackLayout);
        this.mMainSection.setLayoutData((Object)new GridData(1808));
        this.mMasterViewer = this.createMasterView(this.mMainSection);
        this.mDetailViewer = this.createDetailView(this.mMainSection);
        this.mStackLayout.topControl = this.mMasterViewer.getTable();
        this.updateActions();
        this.refresh();
    }

    public void setFocus() {
        super.setFocus();
        this.mStackLayout.topControl.setFocus();
    }

    private EnhancedTableViewer createMasterView(Composite parent) {
        EnhancedTableViewer masterViewer = new EnhancedTableViewer(parent, 66308);
        GridData gridData = new GridData(1808);
        masterViewer.getControl().setLayoutData((Object)gridData);
        Table table = masterViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn severityCol = new TableColumn(table, 0x1000000, 0);
        severityCol.setWidth(20);
        severityCol.setResizable(false);
        TableColumn idCol = new TableColumn(table, 16384, 1);
        idCol.setText(Messages.MarkerStatsView_kindOfErrorColumn);
        idCol.setWidth(400);
        TableColumn countCol = new TableColumn(table, 0x1000000, 2);
        countCol.setText(Messages.MarkerStatsView_numberOfErrorsColumn);
        countCol.pack();
        masterViewer.setContentProvider((IContentProvider)new MasterContentProvider());
        MasterViewMultiProvider multiProvider = new MasterViewMultiProvider();
        masterViewer.setLabelProvider((IBaseLabelProvider)multiProvider);
        masterViewer.setTableComparableProvider(multiProvider);
        masterViewer.setTableSettingsProvider(multiProvider);
        masterViewer.installEnhancements();
        masterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MarkerStatsView.this.updateActions();
            }
        });
        this.hookDoubleClickAction((IAction)this.mDrillDownAction, (StructuredViewer)masterViewer);
        ArrayList<Object> actionList = new ArrayList<Object>(1);
        actionList.add(this.mDrillDownAction);
        actionList.add(new Separator());
        actionList.add(this.mChartAction);
        this.hookContextMenu(actionList, (StructuredViewer)masterViewer);
        return masterViewer;
    }

    private EnhancedTableViewer createDetailView(Composite parent) {
        EnhancedTableViewer detailViewer = new EnhancedTableViewer(parent, 66308);
        GridData gridData = new GridData(1808);
        detailViewer.getControl().setLayoutData((Object)gridData);
        Table table = detailViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn severityCol = new TableColumn(table, 0x1000000, 0);
        severityCol.setWidth(20);
        severityCol.setResizable(false);
        TableColumn idCol = new TableColumn(table, 16384, 1);
        idCol.setText(Messages.MarkerStatsView_fileColumn);
        idCol.setWidth(150);
        TableColumn folderCol = new TableColumn(table, 16384, 2);
        folderCol.setText(Messages.MarkerStatsView_folderColumn);
        folderCol.setWidth(300);
        TableColumn countCol = new TableColumn(table, 0x1000000, 3);
        countCol.setText(Messages.MarkerStatsView_lineColumn);
        countCol.pack();
        TableColumn messageCol = new TableColumn(table, 16384, 4);
        messageCol.setText(Messages.MarkerStatsView_messageColumn);
        messageCol.setWidth(300);
        detailViewer.setContentProvider((IContentProvider)new DetailContentProvider());
        DetailViewMultiProvider multiProvider = new DetailViewMultiProvider();
        detailViewer.setLabelProvider((IBaseLabelProvider)multiProvider);
        detailViewer.setTableComparableProvider(multiProvider);
        detailViewer.setTableSettingsProvider(multiProvider);
        detailViewer.installEnhancements();
        detailViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MarkerStatsView.this.updateActions();
            }
        });
        this.hookDoubleClickAction((IAction)this.mShowErrorAction, (StructuredViewer)detailViewer);
        ArrayList<Object> actionList = new ArrayList<Object>(1);
        actionList.add(this.mDrillBackAction);
        actionList.add(this.mShowErrorAction);
        actionList.add(new Separator());
        actionList.add(this.mChartAction);
        this.hookContextMenu(actionList, (StructuredViewer)detailViewer);
        return detailViewer;
    }

    protected void initMenu(IMenuManager menu) {
        menu.add((IAction)new FiltersAction(this));
    }

    protected void initToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.mChartAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.mDrillBackAction);
        tbm.add((IAction)this.mDrillDownAction);
        tbm.add((IAction)new FiltersAction(this));
    }

    protected String getViewId() {
        return VIEW_ID;
    }

    protected void handleStatsRebuilt() {
        if (this.mMasterViewer != null && !this.mMasterViewer.getTable().isDisposed()) {
            this.mMasterViewer.setInput(this.getStats());
            this.mDetailViewer.setInput(this.getStats());
            this.updateActions();
            this.updateLabel();
        }
    }

    protected void makeActions() {
        this.mChartAction = new Action(){

            public void run() {
                try {
                    MarkerStatsView.this.getSite().getWorkbenchWindow().getActivePage().showView(GraphStatsView.VIEW_ID);
                }
                catch (PartInitException e) {
                    CheckstyleLog.log((Throwable)e, (String)NLS.bind((String)Messages.MarkerStatsView_unableToOpenGraph, (Object)GraphStatsView.VIEW_ID));
                }
            }
        };
        this.mChartAction.setText(Messages.MarkerStatsView_displayChart);
        this.mChartAction.setToolTipText(Messages.MarkerStatsView_displayChartTooltip);
        this.mChartAction.setImageDescriptor(CheckstyleUIPluginImages.GRAPH_VIEW_ICON);
        this.mDrillDownAction = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)MarkerStatsView.this.mMasterViewer.getSelection();
                if (selection.getFirstElement() instanceof MarkerStat) {
                    MarkerStat markerStat = (MarkerStat)selection.getFirstElement();
                    MarkerStatsView.this.mIsDrilledDown = true;
                    MarkerStatsView.this.mCurrentDetailCategory = markerStat.getIdentifiant();
                    ((MarkerStatsView)MarkerStatsView.this).mStackLayout.topControl = MarkerStatsView.this.mDetailViewer.getTable();
                    MarkerStatsView.this.mMainSection.layout();
                    MarkerStatsView.this.mDetailViewer.setInput(MarkerStatsView.this.mDetailViewer.getInput());
                    MarkerStatsView.this.updateActions();
                    MarkerStatsView.this.updateLabel();
                }
            }
        };
        this.mDrillDownAction.setText(Messages.MarkerStatsView_showDetails);
        this.mDrillDownAction.setToolTipText(Messages.MarkerStatsView_showDetailsTooltip);
        this.mDrillDownAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.mDrillDownAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        this.mDrillBackAction = new Action(){

            public void run() {
                MarkerStatsView.this.mIsDrilledDown = false;
                MarkerStatsView.this.mCurrentDetailCategory = null;
                ((MarkerStatsView)MarkerStatsView.this).mStackLayout.topControl = MarkerStatsView.this.mMasterViewer.getTable();
                MarkerStatsView.this.mMainSection.layout();
                MarkerStatsView.this.mMasterViewer.refresh();
                MarkerStatsView.this.updateActions();
                MarkerStatsView.this.updateLabel();
            }
        };
        this.mDrillBackAction.setText(Messages.MarkerStatsView_actionBack);
        this.mDrillBackAction.setToolTipText(Messages.MarkerStatsView_actionBackTooltip);
        this.mDrillBackAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        this.mDrillBackAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        this.mShowErrorAction = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)MarkerStatsView.this.mDetailViewer.getSelection();
                if (selection.getFirstElement() instanceof IMarker) {
                    IMarker marker = (IMarker)selection.getFirstElement();
                    try {
                        IDE.openEditor((IWorkbenchPage)MarkerStatsView.this.getSite().getPage(), (IMarker)marker);
                    }
                    catch (PartInitException e) {
                        CheckstyleLog.log((Throwable)e, (String)Messages.MarkerStatsView_unableToShowMarker);
                    }
                }
            }
        };
        this.mShowErrorAction.setText(Messages.MarkerStatsView_displayError);
        this.mShowErrorAction.setToolTipText(Messages.MarkerStatsView_displayErrorTooltip);
        this.mShowErrorAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OPEN_MARKER"));
    }

    private void updateActions() {
        this.mDrillBackAction.setEnabled(this.mIsDrilledDown);
        this.mDrillDownAction.setEnabled(!this.mIsDrilledDown && !this.mMasterViewer.getSelection().isEmpty());
        this.mShowErrorAction.setEnabled(this.mIsDrilledDown && !this.mDetailViewer.getSelection().isEmpty());
    }

    private void updateLabel() {
        if (!this.mIsDrilledDown) {
            Stats stats = this.getStats();
            if (stats != null) {
                String text = NLS.bind((String)Messages.MarkerStatsView_lblOverviewMessage, (Object[])new Object[]{new Integer(stats.getMarkerCount()), new Integer(stats.getMarkerStats().size()), new Integer(stats.getMarkerCountAll())});
                this.mDescLabel.setText(text);
            } else {
                this.mDescLabel.setText("");
            }
        } else {
            String text = NLS.bind((String)Messages.MarkerStatsView_lblDetailMessage, (Object[])new Object[]{this.mCurrentDetailCategory, new Integer(this.mDetailViewer.getTable().getItemCount())});
            this.mDescLabel.setText(text);
        }
    }

    private void hookContextMenu(final Collection actions, StructuredViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (Object item : actions) {
                    if (item instanceof IContributionItem) {
                        manager.add((IContributionItem)item);
                        continue;
                    }
                    if (!(item instanceof IAction)) continue;
                    manager.add((IAction)item);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void hookDoubleClickAction(final IAction action, StructuredViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                action.run();
            }
        });
    }

    private class DetailContentProvider
    implements IStructuredContentProvider {
        private Object[] mCurrentDetails;

        private DetailContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.mCurrentDetails == null) {
                Stats currentStats = (Stats)inputElement;
                Collection markerStats = currentStats.getMarkerStats();
                for (MarkerStat markerStat : markerStats) {
                    if (!markerStat.getIdentifiant().equals(MarkerStatsView.this.mCurrentDetailCategory)) continue;
                    this.mCurrentDetails = markerStat.getMarkers().toArray();
                    break;
                }
            }
            return this.mCurrentDetails != null ? this.mCurrentDetails : new Object[]{};
        }

        public void dispose() {
            this.mCurrentDetails = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.mCurrentDetails = null;
        }
    }

    private class DetailViewMultiProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableComparableProvider,
    ITableSettingsProvider {
        private DetailViewMultiProvider() {
        }

        public String getColumnText(Object obj, int index) {
            IMarker marker = (IMarker)obj;
            String text = null;
            try {
                switch (index) {
                    case 1: {
                        text = marker.getResource().getName();
                        break;
                    }
                    case 2: {
                        text = marker.getResource().getParent().getFullPath().toString();
                        break;
                    }
                    case 3: {
                        text = marker.getAttribute("lineNumber").toString();
                        break;
                    }
                    case 4: {
                        text = marker.getAttribute("message").toString();
                        break;
                    }
                    default: {
                        text = "";
                        break;
                    }
                }
            }
            catch (Exception e) {
                text = Messages.MarkerStatsView_unknownProblem;
                CheckstyleLog.log((Throwable)e);
            }
            return text;
        }

        public Image getColumnImage(Object obj, int index) {
            Image image = null;
            IMarker marker = (IMarker)obj;
            if (index == 0) {
                int severity = MarkerUtilities.getSeverity((IMarker)marker);
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                if (2 == severity) {
                    image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                } else if (1 == severity) {
                    image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
                } else if (severity == 0) {
                    image = sharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return image;
        }

        public Comparable getComparableValue(Object element, int colIndex) {
            IMarker marker = (IMarker)element;
            Object comparable = null;
            switch (colIndex) {
                case 0: {
                    comparable = new Integer(marker.getAttribute("severity", Integer.MAX_VALUE) * -1);
                    break;
                }
                case 1: {
                    comparable = marker.getResource().getName();
                    break;
                }
                case 2: {
                    comparable = marker.getResource().getParent().getFullPath().toString();
                    break;
                }
                case 3: {
                    comparable = new Integer(marker.getAttribute("lineNumber", Integer.MAX_VALUE));
                    break;
                }
                case 4: {
                    comparable = marker.getAttribute("message", "").toString();
                    break;
                }
                default: {
                    comparable = "";
                }
            }
            return comparable;
        }

        public IDialogSettings getTableSettings() {
            IDialogSettings mainSettings = MarkerStatsView.this.getDialogSettings();
            IDialogSettings settings = mainSettings.getSection(MarkerStatsView.TAG_SECTION_DETAIL);
            if (settings == null) {
                settings = mainSettings.addNewSection(MarkerStatsView.TAG_SECTION_DETAIL);
            }
            return settings;
        }
    }

    private class MasterContentProvider
    implements IStructuredContentProvider {
        private Object[] mCurrentMarkerStats;

        private MasterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.mCurrentMarkerStats == null) {
                Stats currentStats = (Stats)inputElement;
                this.mCurrentMarkerStats = currentStats.getMarkerStats().toArray();
            }
            return this.mCurrentMarkerStats;
        }

        public void dispose() {
            this.mCurrentMarkerStats = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.mCurrentMarkerStats = null;
        }
    }

    private class MasterViewMultiProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableComparableProvider,
    ITableSettingsProvider {
        private MasterViewMultiProvider() {
        }

        public String getColumnText(Object obj, int index) {
            MarkerStat stat = (MarkerStat)obj;
            String text = null;
            switch (index) {
                case 1: {
                    text = stat.getIdentifiant();
                    break;
                }
                case 2: {
                    text = String.valueOf(stat.getCount());
                    break;
                }
                default: {
                    text = "";
                }
            }
            return text;
        }

        public Image getColumnImage(Object obj, int index) {
            Image image = null;
            MarkerStat stat = (MarkerStat)obj;
            if (index == 0) {
                int severity = stat.getMaxSeverity();
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                if (2 == severity) {
                    image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                } else if (1 == severity) {
                    image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
                } else if (severity == 0) {
                    image = sharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return image;
        }

        public Comparable getComparableValue(Object element, int colIndex) {
            MarkerStat stat = (MarkerStat)element;
            Object comparable = null;
            switch (colIndex) {
                case 0: {
                    comparable = new Integer(stat.getMaxSeverity() * -1);
                    break;
                }
                case 1: {
                    comparable = stat.getIdentifiant();
                    break;
                }
                case 2: {
                    comparable = new Integer(stat.getCount());
                    break;
                }
                default: {
                    comparable = "";
                }
            }
            return comparable;
        }

        public IDialogSettings getTableSettings() {
            IDialogSettings mainSettings = MarkerStatsView.this.getDialogSettings();
            IDialogSettings settings = mainSettings.getSection(MarkerStatsView.TAG_SECTION_MASTER);
            if (settings == null) {
                settings = mainSettings.addNewSection(MarkerStatsView.TAG_SECTION_MASTER);
            }
            return settings;
        }
    }
}

