/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.stats.views;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.CheckstyleUIPluginPrefs;
import net.sf.eclipsecs.ui.stats.Messages;
import net.sf.eclipsecs.ui.stats.data.MarkerStat;
import net.sf.eclipsecs.ui.stats.data.Stats;
import net.sf.eclipsecs.ui.stats.views.AbstractStatsView;
import net.sf.eclipsecs.ui.stats.views.GraphPieDataset;
import net.sf.eclipsecs.ui.stats.views.MarkerStatsView;
import net.sf.eclipsecs.ui.stats.views.internal.FiltersAction;
import net.sf.eclipsecs.ui.util.table.EnhancedTableViewer;
import net.sf.eclipsecs.ui.util.table.ITableComparableProvider;
import net.sf.eclipsecs.ui.util.table.ITableSettingsProvider;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.PieDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.Rotation;
import org.osgi.service.prefs.BackingStoreException;

public class GraphStatsView
extends AbstractStatsView {
    public static final String VIEW_ID = GraphStatsView.class.getName();
    private static final String TAG_SECTION_DETAIL = "detailView";
    private Label mLabelDesc;
    private Composite mMainSection;
    private StackLayout mStackLayout;
    private EnhancedTableViewer mDetailViewer;
    private Composite mMasterComposite;
    private JFreeChart mGraph;
    private GraphPieDataset mPieDataset;
    private Action mDrillBackAction;
    private Action mShowErrorAction;
    private Action mListingAction;
    private Action mShowAllCategoriesAction;
    private String mCurrentDetailCategory;
    private boolean mIsDrilledDown;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.mLabelDesc = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mLabelDesc.setLayoutData((Object)gridData);
        this.mMainSection = new Composite(parent, 0);
        this.mStackLayout = new StackLayout();
        this.mStackLayout.marginHeight = 0;
        this.mStackLayout.marginWidth = 0;
        this.mMainSection.setLayout((Layout)this.mStackLayout);
        this.mMainSection.setLayoutData((Object)new GridData(1808));
        this.mMasterComposite = this.createMasterView(this.mMainSection);
        this.mDetailViewer = this.createDetailView(this.mMainSection);
        this.mStackLayout.topControl = this.mMasterComposite;
        this.updateActions();
        this.refresh();
    }

    public Composite createMasterView(Composite parent) {
        this.mPieDataset = new GraphPieDataset();
        this.mPieDataset.setShowAllCategories(this.mShowAllCategoriesAction.isChecked());
        this.mGraph = this.createChart(this.mPieDataset);
        ChartComposite embeddedComposite = new ChartComposite(parent, 0, this.mGraph, true);
        embeddedComposite.setLayoutData((Object)new GridData(1808));
        embeddedComposite.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(final ChartMouseEvent event) {
                MouseEvent trigger = event.getTrigger();
                if (trigger.getButton() == 1 && event.getEntity() instanceof PieSectionEntity) {
                    GraphStatsView.this.mMasterComposite.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            GraphStatsView.this.mIsDrilledDown = true;
                            GraphStatsView.this.mCurrentDetailCategory = (String)((Object)((PieSectionEntity)event.getEntity()).getSectionKey());
                            ((GraphStatsView)(this).GraphStatsView.this).mStackLayout.topControl = GraphStatsView.this.mDetailViewer.getTable();
                            GraphStatsView.this.mMainSection.layout();
                            GraphStatsView.this.mDetailViewer.setInput(GraphStatsView.this.mDetailViewer.getInput());
                            GraphStatsView.this.updateActions();
                            GraphStatsView.this.updateLabel();
                        }
                    });
                } else {
                    event.getTrigger().consume();
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        });
        return embeddedComposite;
    }

    private EnhancedTableViewer createDetailView(Composite parent) {
        EnhancedTableViewer detailViewer = new EnhancedTableViewer(parent, 66308);
        GridData gridData = new GridData(1808);
        detailViewer.getControl().setLayoutData((Object)gridData);
        Table table = detailViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn severityCol = new TableColumn(table, 0x1000000, 0);
        severityCol.setWidth(20);
        severityCol.setResizable(false);
        TableColumn idCol = new TableColumn(table, 16384, 1);
        idCol.setText(Messages.MarkerStatsView_fileColumn);
        idCol.setWidth(150);
        TableColumn folderCol = new TableColumn(table, 16384, 2);
        folderCol.setText(Messages.MarkerStatsView_folderColumn);
        folderCol.setWidth(300);
        TableColumn countCol = new TableColumn(table, 0x1000000, 3);
        countCol.setText(Messages.MarkerStatsView_lineColumn);
        countCol.pack();
        TableColumn messageCol = new TableColumn(table, 16384, 4);
        messageCol.setText(Messages.MarkerStatsView_messageColumn);
        messageCol.setWidth(300);
        detailViewer.setContentProvider((IContentProvider)new DetailContentProvider());
        DetailViewMultiProvider multiProvider = new DetailViewMultiProvider();
        detailViewer.setLabelProvider((IBaseLabelProvider)multiProvider);
        detailViewer.setTableComparableProvider(multiProvider);
        detailViewer.setTableSettingsProvider(multiProvider);
        detailViewer.installEnhancements();
        detailViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GraphStatsView.this.updateActions();
            }
        });
        this.hookDoubleClickAction((IAction)this.mShowErrorAction, (StructuredViewer)detailViewer);
        ArrayList<Object> actionList = new ArrayList<Object>(1);
        actionList.add(this.mDrillBackAction);
        actionList.add(this.mShowErrorAction);
        actionList.add(new Separator());
        this.hookContextMenu(actionList, (StructuredViewer)detailViewer);
        return detailViewer;
    }

    protected void makeActions() {
        this.mListingAction = new Action(){

            public void run() {
                try {
                    GraphStatsView.this.getSite().getWorkbenchWindow().getActivePage().showView(MarkerStatsView.VIEW_ID);
                }
                catch (PartInitException e) {
                    CheckstyleLog.log((Throwable)e, (String)NLS.bind((String)Messages.GraphStatsView_unableToOpenListingView, (Object)MarkerStatsView.VIEW_ID));
                }
            }
        };
        this.mListingAction.setText(Messages.GraphStatsView_displayListing);
        this.mListingAction.setToolTipText(Messages.GraphStatsView_displayListing);
        this.mListingAction.setImageDescriptor(CheckstyleUIPluginImages.LIST_VIEW_ICON);
        this.mShowAllCategoriesAction = new Action(Messages.GraphStatsView_displayAllCategories, 2){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!GraphStatsView.this.mMasterComposite.isDisposed() && GraphStatsView.this.mMasterComposite.isVisible()) {
                            GraphStatsView.this.mPieDataset.setShowAllCategories(GraphStatsView.this.mShowAllCategoriesAction.isChecked());
                            try {
                                CheckstyleUIPluginPrefs.setBoolean("show_all_categories", GraphStatsView.this.mShowAllCategoriesAction.isChecked());
                            }
                            catch (BackingStoreException e1) {
                                CheckstyleLog.log((Throwable)e1);
                            }
                            GraphStatsView.this.refresh();
                        }
                    }
                });
            }
        };
        this.mShowAllCategoriesAction.setToolTipText(Messages.GraphStatsView_displayAllCategories);
        this.mShowAllCategoriesAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ELEMENTS"));
        this.mShowAllCategoriesAction.setChecked(CheckstyleUIPluginPrefs.getBoolean("show_all_categories"));
        this.mDrillBackAction = new Action(){

            public void run() {
                GraphStatsView.this.mIsDrilledDown = false;
                GraphStatsView.this.mCurrentDetailCategory = null;
                ((GraphStatsView)GraphStatsView.this).mStackLayout.topControl = GraphStatsView.this.mMasterComposite;
                GraphStatsView.this.mMainSection.layout();
                GraphStatsView.this.updateActions();
                GraphStatsView.this.updateLabel();
            }
        };
        this.mDrillBackAction.setText(Messages.MarkerStatsView_actionBack);
        this.mDrillBackAction.setToolTipText(Messages.MarkerStatsView_actionBackTooltip);
        this.mDrillBackAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        this.mDrillBackAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        this.mShowErrorAction = new Action(){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)GraphStatsView.this.mDetailViewer.getSelection();
                if (selection.getFirstElement() instanceof IMarker) {
                    IMarker marker = (IMarker)selection.getFirstElement();
                    try {
                        IDE.openEditor((IWorkbenchPage)GraphStatsView.this.getSite().getPage(), (IMarker)marker);
                    }
                    catch (PartInitException e) {
                        CheckstyleLog.log((Throwable)e, (String)Messages.MarkerStatsView_unableToShowMarker);
                    }
                }
            }
        };
        this.mShowErrorAction.setText(Messages.MarkerStatsView_displayError);
        this.mShowErrorAction.setToolTipText(Messages.MarkerStatsView_displayErrorTooltip);
        this.mShowErrorAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OPEN_MARKER"));
    }

    protected void initMenu(IMenuManager menu) {
        menu.add((IAction)new FiltersAction(this));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.mShowAllCategoriesAction);
    }

    protected void initToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.mListingAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.mDrillBackAction);
        tbm.add((IAction)new FiltersAction(this));
    }

    private void updateActions() {
        this.mDrillBackAction.setEnabled(this.mIsDrilledDown);
        this.mShowErrorAction.setEnabled(this.mIsDrilledDown && !this.mDetailViewer.getSelection().isEmpty());
    }

    private void hookDoubleClickAction(final IAction action, StructuredViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                action.run();
            }
        });
    }

    private void hookContextMenu(final Collection actions, StructuredViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (Object item : actions) {
                    if (item instanceof IContributionItem) {
                        manager.add((IContributionItem)item);
                        continue;
                    }
                    if (!(item instanceof IAction)) continue;
                    manager.add((IAction)item);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    protected String getViewId() {
        return VIEW_ID;
    }

    protected void handleStatsRebuilt() {
        if (!this.mMasterComposite.isDisposed()) {
            this.mPieDataset.setStats(this.getStats());
            this.mDetailViewer.setInput(this.getStats());
            this.updateActions();
            this.updateLabel();
        }
    }

    private JFreeChart createChart(GraphPieDataset piedataset) {
        JFreeChart jfreechart = ChartFactory.createPieChart3D(null, (PieDataset)piedataset, (boolean)false, (boolean)true, (boolean)false);
        jfreechart.setAntiAlias(true);
        jfreechart.setTextAntiAlias(true);
        PiePlot pieplot3d = (PiePlot)jfreechart.getPlot();
        pieplot3d.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        pieplot3d.setStartAngle(290.0);
        pieplot3d.setDirection(Rotation.CLOCKWISE);
        pieplot3d.setForegroundAlpha(0.5f);
        pieplot3d.setNoDataMessage(Messages.GraphStatsView_noDataToDisplay);
        pieplot3d.setCircular(true);
        pieplot3d.setOutlinePaint(null);
        pieplot3d.setLabelFont(new Font("SansSerif", 0, 10));
        pieplot3d.setLabelGap(0.02);
        pieplot3d.setLabelOutlinePaint(null);
        pieplot3d.setLabelShadowPaint(null);
        pieplot3d.setLabelBackgroundPaint((Paint)Color.WHITE);
        pieplot3d.setBackgroundPaint((Paint)Color.WHITE);
        pieplot3d.setInteriorGap(0.02);
        pieplot3d.setMaximumLabelWidth(0.2);
        return jfreechart;
    }

    private void updateLabel() {
        if (!this.mIsDrilledDown) {
            Stats stats = this.getStats();
            if (stats != null) {
                String text = NLS.bind((String)Messages.GraphStatsView_lblViewMessage, (Object[])new Object[]{new Integer(stats.getMarkerCount()), new Integer(stats.getMarkerStats().size()), new Integer(stats.getMarkerCountAll())});
                this.mLabelDesc.setText(text);
            } else {
                this.mLabelDesc.setText("");
            }
        } else {
            String text = NLS.bind((String)Messages.MarkerStatsView_lblDetailMessage, (Object[])new Object[]{this.mCurrentDetailCategory, new Integer(this.mDetailViewer.getTable().getItemCount())});
            this.mLabelDesc.setText(text);
        }
    }

    private class DetailContentProvider
    implements IStructuredContentProvider {
        private Object[] mCurrentDetails;

        private DetailContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.mCurrentDetails == null) {
                Stats currentStats = (Stats)inputElement;
                Collection markerStats = currentStats.getMarkerStats();
                for (MarkerStat markerStat : markerStats) {
                    if (!markerStat.getIdentifiant().equals(GraphStatsView.this.mCurrentDetailCategory)) continue;
                    this.mCurrentDetails = markerStat.getMarkers().toArray();
                    break;
                }
            }
            return this.mCurrentDetails != null ? this.mCurrentDetails : new Object[]{};
        }

        public void dispose() {
            this.mCurrentDetails = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.mCurrentDetails = null;
        }
    }

    private class DetailViewMultiProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableComparableProvider,
    ITableSettingsProvider {
        private DetailViewMultiProvider() {
        }

        public String getColumnText(Object obj, int index) {
            IMarker marker = (IMarker)obj;
            String text = null;
            try {
                switch (index) {
                    case 1: {
                        text = marker.getResource().getName();
                        break;
                    }
                    case 2: {
                        text = marker.getResource().getParent().getFullPath().toString();
                        break;
                    }
                    case 3: {
                        text = marker.getAttribute("lineNumber").toString();
                        break;
                    }
                    case 4: {
                        text = marker.getAttribute("message").toString();
                        break;
                    }
                    default: {
                        text = "";
                        break;
                    }
                }
            }
            catch (Exception e) {
                text = Messages.MarkerStatsView_unknownProblem;
                CheckstyleLog.log((Throwable)e);
            }
            return text;
        }

        public Image getColumnImage(Object obj, int index) {
            Image image = null;
            IMarker marker = (IMarker)obj;
            if (index == 0) {
                int severity = MarkerUtilities.getSeverity((IMarker)marker);
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                if (2 == severity) {
                    image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                } else if (1 == severity) {
                    image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
                } else if (severity == 0) {
                    image = sharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return image;
        }

        public Comparable getComparableValue(Object element, int colIndex) {
            IMarker marker = (IMarker)element;
            Object comparable = null;
            switch (colIndex) {
                case 0: {
                    comparable = new Integer(marker.getAttribute("severity", Integer.MAX_VALUE) * -1);
                    break;
                }
                case 1: {
                    comparable = marker.getResource().getName();
                    break;
                }
                case 2: {
                    comparable = marker.getResource().getParent().getFullPath().toString();
                    break;
                }
                case 3: {
                    comparable = new Integer(marker.getAttribute("lineNumber", Integer.MAX_VALUE));
                    break;
                }
                case 4: {
                    comparable = marker.getAttribute("message", "").toString();
                    break;
                }
                default: {
                    comparable = "";
                }
            }
            return comparable;
        }

        public IDialogSettings getTableSettings() {
            IDialogSettings mainSettings = GraphStatsView.this.getDialogSettings();
            IDialogSettings settings = mainSettings.getSection(GraphStatsView.TAG_SECTION_DETAIL);
            if (settings == null) {
                settings = mainSettings.addNewSection(GraphStatsView.TAG_SECTION_DETAIL);
            }
            return settings;
        }
    }
}

