/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.wizards;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.ui.wizards.Messages;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Node;

public abstract class AbstractConfigWizard
extends Wizard {
    protected ShallowFormatProcessorXML formatter = new ShallowFormatProcessorXML();
    protected String namespaceUri;
    protected IFile file;
    protected IDOMDocument domDocument;
    protected IDOMElement newElement;
    protected IDOMElement input;
    private IDOMModel copiedModel;

    protected abstract void createInput(IDOMDocument var1);

    public void dispose() {
        if (this.copiedModel != null) {
            this.copiedModel.releaseFromEdit();
            this.copiedModel = null;
        }
        super.dispose();
    }

    protected IDOMDocument getDomDocument() {
        return this.domDocument;
    }

    protected IDOMElement getInput() {
        return this.input;
    }

    public IDOMElement getNewElement() {
        return this.newElement;
    }

    protected String getPrefixForNamespaceUri() {
        return ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)this.domDocument, (String)this.namespaceUri);
    }

    protected IFile getResourceFile() {
        return this.file;
    }

    protected Node getRootNode() {
        if (this.domDocument != null) {
            return this.domDocument.getDocumentElement();
        }
        return null;
    }

    public void initialize(IFile file, IDOMDocument domDocument, String namespaceUri) {
        this.file = file;
        this.domDocument = domDocument;
        this.namespaceUri = namespaceUri;
        try {
            IDOMModel model = domDocument.getModel();
            IModelManager modelManager = model.getModelManager();
            this.copiedModel = (IDOMModel)modelManager.createNewInstance((IStructuredModel)model);
            IDOMDocument copiedDocument = this.copiedModel.getDocument();
            this.createInput(copiedDocument);
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("AbstractConfigWizard.ERROR_INITIALIZING_WIZARD"), (Throwable)e));
        }
    }
}

