/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.sse.ui.views.properties.PropertySheetConfiguration;
import org.eclipse.wst.xml.ui.views.properties.XMLPropertySheetConfiguration;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;

public class SpringConfigPropertySheetPage
extends TabbedPropertySheetPage {
    private final AbstractConfigEditor editor;
    private final PropertySheetConfiguration config;

    public SpringConfigPropertySheetPage(AbstractConfigEditor editor) {
        super((ITabbedPropertySheetPageContributor)editor);
        this.editor = editor;
        this.config = new XMLPropertySheetConfiguration();
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    protected AbstractConfigEditor getConfigEditor() {
        return this.editor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != null && part instanceof PageBookView && ((PageBookView)part).getCurrentPage() == this) {
            return;
        }
        if (this.getControl() != null && this.getControl().isVisible()) {
            ISelection preferredSelection = this.config.getInputSelection(part, selection);
            if (preferredSelection instanceof IStructuredSelection && ((IStructuredSelection)preferredSelection).size() > 1) {
                preferredSelection = StructuredSelection.EMPTY;
            }
            super.selectionChanged(part, preferredSelection);
        }
    }
}

