/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.springiderules;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentBeanSpecifiesAbstractClassRule
implements IValidationRule<IBean, IBeansValidationContext> {
    public static final String INFO_MESSAGE = "Parent beans should not specify abstract classes because they cannot be instantiated by child beans that inherit from this configuration.";
    public static final String ERROR_ID = "parentBeanSpecifiesAbstractClass";

    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof IBean;
    }

    public void validate(IBean bean, IBeansValidationContext validationContext, IProgressMonitor progressMonitor) {
        IType implementationType;
        if (bean.isAbstract() && (implementationType = JdtUtils.getJavaType((IProject)validationContext.getRootElementProject(), (String)bean.getClassName())) != null) {
            int flags = 0;
            try {
                flags = implementationType.getFlags();
            }
            catch (JavaModelException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.bestpractices", "Could not read JDT model flags", (Throwable)e));
                return;
            }
            if (Flags.isAbstract((int)flags)) {
                validationContext.info((IResourceModelElement)bean, ERROR_ID, INFO_MESSAGE, new ValidationProblemAttribute[0]);
            }
        }
    }
}

