/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.quickfix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.AbstractCreateMethodMarkerResolution;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.XmlQuickFixUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateConstructorMarkerResolution
extends AbstractCreateMethodMarkerResolution {
    private String targetClass = this.extractQuotedString("class '", this.getMarkerMessage());
    private int numConstructorArgs = 0;

    public CreateConstructorMarkerResolution(IMarker marker) throws CoreException {
        super(marker);
        this.numConstructorArgs = this.getNumConstructorArgsForMarkedBean(marker);
    }

    @Override
    protected List<Expression> getArguments(Expression invocationExpression) {
        ClassInstanceCreation methodInvocation = (ClassInstanceCreation)invocationExpression;
        ArrayList<Expression> arguments = new ArrayList<Expression>();
        for (Expression argumentExpression : methodInvocation.arguments()) {
            arguments.add(argumentExpression);
        }
        return arguments;
    }

    @Override
    public String getDescription() {
        return "Create matching constructor in class '" + this.targetClass + "'";
    }

    @Override
    public String getLabel() {
        return "Create matching constructor in class '" + this.targetClass + "'";
    }

    @Override
    protected String getNewMethodName() {
        return "new " + this.targetClass;
    }

    @Override
    protected String getNewMethodParameters() {
        String params = "";
        String paramName = "object";
        int i = 0;
        while (i < this.numConstructorArgs) {
            params = i == 0 ? String.valueOf(params) + paramName : String.valueOf(params) + ", " + paramName;
            ++i;
        }
        return params;
    }

    private int getNumConstructorArgsForMarkedBean(IMarker marker) throws CoreException {
        IStructuredModel model = null;
        Element beanElement = null;
        try {
            model = XmlQuickFixUtil.getModel(marker);
            if (model == null) {
                return 0;
            }
            beanElement = XmlQuickFixUtil.getMarkerElement(model, marker);
            if (beanElement == null) {
                return 0;
            }
            IBeansModel beansModel = BeansCorePlugin.getModel();
            if (beansModel == null) {
                return 0;
            }
            IBeansConfig beansConfig = beansModel.getConfig((IFile)marker.getResource(), false);
            String beanName = beanElement.getAttribute("id");
            IBean bean = BeansModelUtils.getBean((String)beanName, (IModelElement)beansConfig);
            if (bean != null && bean.getConstructorArguments() != null) {
                int n = bean.getConstructorArguments().size();
                return n;
            }
            return 0;
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    @Override
    protected String getTargetClass() {
        return this.targetClass;
    }
}

