/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.internal.model;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.metadata.model.AbstractAnnotationReadingMetadataProvider;
import org.springframework.ide.eclipse.beans.core.metadata.model.IAnnotationBeanMetadataProvider;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingAnnotationReadingMetadataProvider
extends AbstractAnnotationReadingMetadataProvider {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ANNOTATION_METADATA_PROVIDER_ELEMENT = "annotationMetadataProvider";
    private IAnnotationBeanMetadataProvider[] metadataProviders;

    @Override
    protected void processFoundAnnotations(final IBean bean, final Set<IBeanMetadata> beanMetaDataSet, final IType type, final IAnnotationMetadata metadata, IProgressMonitor progressMonitor) {
        IAnnotationBeanMetadataProvider[] iAnnotationBeanMetadataProviderArray = this.getMetadataProviders();
        int n = iAnnotationBeanMetadataProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            final IAnnotationBeanMetadataProvider provider = iAnnotationBeanMetadataProviderArray[n2];
            if (progressMonitor.isCanceled()) {
                return;
            }
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    beanMetaDataSet.addAll(provider.provideBeanMetadata(bean, type, metadata));
                }
            });
            ++n2;
        }
    }

    protected IAnnotationBeanMetadataProvider[] getMetadataProviders() {
        if (this.metadataProviders != null) {
            return this.metadataProviders;
        }
        ArrayList<IAnnotationBeanMetadataProvider> providers = new ArrayList<IAnnotationBeanMetadataProvider>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.springframework.ide.eclipse.beans.core.metadata.metadataproviders");
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (ANNOTATION_METADATA_PROVIDER_ELEMENT.equals(config.getName()) && config.getAttribute(CLASS_ATTRIBUTE) != null) {
                        try {
                            Object handler = config.createExecutableExtension(CLASS_ATTRIBUTE);
                            if (handler instanceof IAnnotationBeanMetadataProvider) {
                                IAnnotationBeanMetadataProvider entityResolver = (IAnnotationBeanMetadataProvider)handler;
                                providers.add(entityResolver);
                            }
                        }
                        catch (CoreException e) {
                            BeansCorePlugin.log((Throwable)e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        this.metadataProviders = providers.toArray(new IAnnotationBeanMetadataProvider[providers.size()]);
        return this.metadataProviders;
    }
}

