/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.IProgressConstants;
import org.springframework.ide.eclipse.beans.core.BeansCoreImages;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModel;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.metadata.BeansMetadataPlugin;
import org.springframework.ide.eclipse.beans.core.metadata.internal.model.BeanMetadataModel;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadataProvider;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetadataBuilderJob
extends Job {
    private static final String METADATA_PROVIDER_ELEMENT = "metadataProvider";
    private static final String CLASS_ATTRIBUTE = "class";
    public static final String META_DATA_PROVIDERS_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.core.metadata.metadataproviders";
    private static final Object CONTENT_FAMILY = new Object();
    private Map<IBeansConfig, Set<IBean>> affectedBeans;

    public BeanMetadataBuilderJob(Map<IBeansConfig, Set<IBean>> affectedBeans) {
        super("Resolving Spring Meta Data");
        this.affectedBeans = affectedBeans;
        this.setPriority(40);
        this.setSystem(true);
        this.setProperty(IProgressConstants.ICON_PROPERTY, BeansCoreImages.DESC_OBJS_ANNOTATATION);
    }

    public boolean belongsTo(Object family) {
        return CONTENT_FAMILY == family;
    }

    public boolean isCoveredBy(BeanMetadataBuilderJob other) {
        if (other.affectedBeans != null && this.affectedBeans != null) {
            HashSet<IBean> allBeans = new HashSet<IBean>();
            for (Set<IBean> beans : other.affectedBeans.values()) {
                allBeans.addAll(beans);
            }
            HashSet<IBean> allMyBeans = new HashSet<IBean>();
            for (Set<IBean> beans : this.affectedBeans.values()) {
                allMyBeans.addAll(beans);
            }
            return allBeans.containsAll(allMyBeans);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                block12: {
                    if (!monitor.isCanceled()) break block12;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                Job[] buildJobs = Job.getJobManager().find(CONTENT_FAMILY);
                int i = 0;
                while (i < buildJobs.length) {
                    BeanMetadataBuilderJob job;
                    Job curr = buildJobs[i];
                    if (curr != this && curr instanceof BeanMetadataBuilderJob && (job = (BeanMetadataBuilderJob)curr).isCoveredBy(this)) {
                        curr.cancel();
                    }
                    ++i;
                }
            }
            monitor.beginTask("Attaching Spring bean meta data", this.affectedBeans.size());
            IBeanMetadataProvider[] providers = this.getMetadataProviders();
            LinkedHashSet<IBeansProject> projects = new LinkedHashSet<IBeansProject>();
            for (Map.Entry<IBeansConfig, Set<IBean>> entry : this.affectedBeans.entrySet()) {
                long start = System.currentTimeMillis();
                IResource resource = entry.getKey().getElementResource();
                projects.add((IBeansProject)BeansModelUtils.getParentOfClass((IModelElement)((IModelElement)entry.getKey()), IBeansProject.class));
                monitor.subTask("Attaching Spring bean meta data to file [" + resource.getFullPath().toString() + "]");
                this.attachMetadata(entry.getKey(), entry.getValue(), monitor, providers);
                monitor.worked(1);
                if (!BeanMetadataModel.DEBUG) continue;
                System.out.println("Attaching meta data [" + resource.getFullPath().toString() + "] took " + (System.currentTimeMillis() - start) + "ms");
            }
            for (IBeansProject project : projects) {
                ((BeansModel)BeansCorePlugin.getModel()).notifyListeners((IModelElement)project, ModelChangeEvent.Type.CHANGED);
            }
        }
        finally {
            this.affectedBeans = null;
        }
        return Status.OK_STATUS;
    }

    protected void attachMetadata(IBeansConfig beansConfig, Set<IBean> beans, IProgressMonitor progressMonitor, IBeanMetadataProvider[] providers) {
        for (IBean bean : beans) {
            this.attachMetadataToBean(beansConfig, progressMonitor, providers, bean);
        }
    }

    private void attachMetadataToBean(final IBeansConfig beansConfig, final IProgressMonitor progressMonitor, IBeanMetadataProvider[] providers, final IBean bean) {
        BeansMetadataPlugin.getMetadataModel().clearBeanMetadata(bean);
        BeansMetadataPlugin.getMetadataModel().clearBeanProperties(bean);
        LinkedHashSet<IBeanMetadata> beanMetaData = new LinkedHashSet<IBeanMetadata>();
        LinkedHashSet<IMethodMetadata> methodMetaData = new LinkedHashSet<IMethodMetadata>();
        final LinkedHashSet beanMetaDataSet = new LinkedHashSet();
        final LinkedHashSet<IBeanProperty> beanProperties = new LinkedHashSet<IBeanProperty>();
        IBeanMetadataProvider[] iBeanMetadataProviderArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            final IBeanMetadataProvider provider = iBeanMetadataProviderArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    beanMetaDataSet.addAll(provider.provideBeanMetadata(bean, beansConfig, progressMonitor));
                    beanProperties.addAll(provider.provideBeanProperties(bean, beansConfig, progressMonitor));
                }
            });
            for (IBeanMetadata metaData : beanMetaDataSet) {
                if (metaData instanceof IMethodMetadata) {
                    methodMetaData.add((IMethodMetadata)metaData);
                    continue;
                }
                beanMetaData.add(metaData);
            }
            ++n2;
        }
        if (beanMetaData.size() > 0 || methodMetaData.size() > 0) {
            BeansMetadataPlugin.getMetadataModel().setBeanMetadata(bean, beanMetaData, methodMetaData);
        }
        if (beanProperties.size() > 0) {
            BeansMetadataPlugin.getMetadataModel().setBeanProperties(bean, beanProperties);
        }
    }

    protected IBeanMetadataProvider[] getMetadataProviders() {
        ArrayList<IBeanMetadataProvider> providers = new ArrayList<IBeanMetadataProvider>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(META_DATA_PROVIDERS_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (METADATA_PROVIDER_ELEMENT.equals(config.getName()) && config.getAttribute(CLASS_ATTRIBUTE) != null) {
                        try {
                            Object handler = config.createExecutableExtension(CLASS_ATTRIBUTE);
                            if (handler instanceof IBeanMetadataProvider) {
                                IBeanMetadataProvider entityResolver = (IBeanMetadataProvider)handler;
                                providers.add(entityResolver);
                            }
                        }
                        catch (CoreException e) {
                            BeansMetadataPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.beans.core.metadata", 1, "Error loading metadata provider", (Throwable)e));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return providers.toArray(new IBeanMetadataProvider[providers.size()]);
    }
}

