/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.util;

import com.atlassian.theplugin.commons.exception.IncorrectVersionException;
import java.io.Serializable;
import java.util.Scanner;
import java.util.regex.MatchResult;

public class Version
implements Serializable {
    public static final String SPECIAL_DEV_VERSION = "${project.version}, SVN:${buildNumber}";
    public static final Version NULL_VERSION = Version.initNullVersion();
    private static final long serialVersionUID = 1846608052207718100L;
    private transient VersionNumber versionNumber;
    private final String version;
    private static final String PATTERN = "^(\\d+)\\.(\\d+)\\.(\\d+)((-(ALPHA|BETA|SNAPSHOT))?+)((-(\\d+))?+), SVN:(\\d+)$";
    private static final int MAJOR_TOKEN_GRP = 1;
    private static final int MINOR_TOKEN_GRP = 2;
    private static final int MICRO_TOKEN_GRP = 3;
    private static final int ALPHANUM_TOKEN_GRP = 6;
    private static final int ALPHANUM_VERSION_GRP = 9;
    private static final int BUILD_TOKEN_GRP = 10;

    private static Version initNullVersion() {
        Version result = null;
        try {
            result = new Version("0.0.0, SVN:0");
        }
        catch (IncorrectVersionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Version(String version) throws IncorrectVersionException {
        this.version = version;
        this.parseVersionString(version);
    }

    public Version() throws IncorrectVersionException {
        this(NULL_VERSION.getVersion());
    }

    public String getVersion() {
        return this.version;
    }

    private void parseVersionString(String aVersion) throws IncorrectVersionException {
        if (!aVersion.equals(SPECIAL_DEV_VERSION)) {
            this.tokenize(aVersion.toUpperCase());
        }
    }

    private void tokenize(String aVersion) throws IncorrectVersionException {
        Scanner s = new Scanner(aVersion);
        s.findInLine(PATTERN);
        try {
            MatchResult result = s.match();
            this.versionNumber = new VersionNumber(Integer.valueOf(result.group(1)), Integer.valueOf(result.group(2)), Integer.valueOf(result.group(3)), result.group(6), result.group(9), Integer.valueOf(result.group(10)));
        }
        catch (IllegalStateException ex) {
            throw new IncorrectVersionException("Version (" + aVersion + ") does not match pattern (\"" + PATTERN + "\")", ex);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Version thatVersion = (Version)that;
        return !(this.version != null ? !this.version.equals(thatVersion.version) : thatVersion.version != null);
    }

    public int hashCode() {
        return this.version != null ? this.version.hashCode() : 0;
    }

    public String toString() {
        return this.version;
    }

    public boolean greater(Version other) {
        if (other == null) {
            return false;
        }
        if (other.version.equals(SPECIAL_DEV_VERSION)) {
            return false;
        }
        if (this.version.equals(SPECIAL_DEV_VERSION)) {
            return true;
        }
        return this.getVersionNumber().greater(other.getVersionNumber());
    }

    private VersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    private static class VersionNumber {
        private int major;
        private int minor;
        private int micro;
        private int buildNo;
        private AlphaNum alphaNum;
        private int alphaNumValue = 0;
        private static final int PRIME = 31;

        public VersionNumber(int major, int minor, int micro, String alphaNum, String alphaNumValue, int buildNo) throws IncorrectVersionException {
            this.major = major;
            this.minor = minor;
            this.micro = micro;
            this.buildNo = buildNo;
            if (alphaNum == null) {
                this.alphaNum = AlphaNum.NONE;
            } else {
                try {
                    this.alphaNum = AlphaNum.valueOf(alphaNum);
                    if (alphaNumValue != null) {
                        this.alphaNumValue = Integer.valueOf(alphaNumValue);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IncorrectVersionException("Unknown version alphanum: " + alphaNum);
                }
            }
        }

        public boolean greater(VersionNumber other) {
            if (other == null) {
                return false;
            }
            if (this.major > other.major) {
                return true;
            }
            if (this.major == other.major && this.minor > other.minor) {
                return true;
            }
            if (this.major == other.major && this.minor == other.minor && this.micro > other.micro) {
                return true;
            }
            if (this.major == other.major && this.minor == other.minor && this.micro == other.micro) {
                return this.buildNo > other.buildNo;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionNumber that = (VersionNumber)o;
            if (this.major != that.major) {
                return false;
            }
            if (this.micro != that.micro) {
                return false;
            }
            if (this.minor != that.minor) {
                return false;
            }
            if (this.alphaNum != that.alphaNum) {
                return false;
            }
            return this.alphaNumValue == that.alphaNumValue;
        }

        public int hashCode() {
            int result = this.major;
            result = 31 * result + this.minor;
            result = 31 * result + this.micro;
            result = 31 * result + (this.alphaNum != null ? this.alphaNum.hashCode() : 0);
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum AlphaNum {
            SNAPSHOT,
            ALPHA,
            BETA,
            NONE;

        }
    }
}

