/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model.notification;

import com.atlassian.theplugin.commons.crucible.api.model.Comment;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleAction;
import com.atlassian.theplugin.commons.crucible.api.model.CrucibleFileInfo;
import com.atlassian.theplugin.commons.crucible.api.model.Review;
import com.atlassian.theplugin.commons.crucible.api.model.Reviewer;
import com.atlassian.theplugin.commons.crucible.api.model.notification.BasisReviewDetailsChangedNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.CommentReadUnreadStateChangedNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.CrucibleNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.CrucibleNotificationType;
import com.atlassian.theplugin.commons.crucible.api.model.notification.NewCommentNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.NewReviewItemNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.RemovedCommentNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.RemovedReviewItemNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.ReviewCompletedNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.ReviewDataChangedNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.ReviewStateChangedNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.ReviewerCompletedNotification;
import com.atlassian.theplugin.commons.crucible.api.model.notification.UpdatedCommentNotification;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewDifferenceProducer {
    private final Review oldReview;
    private final Review newReview;
    private final List<CrucibleNotification> notifications = new ArrayList<CrucibleNotification>();
    private boolean shortEqual;
    private boolean filesEqual;
    private int changes;

    public ReviewDifferenceProducer(@NotNull Review oldReview, @NotNull Review newReview) {
        this.oldReview = oldReview;
        this.newReview = newReview;
    }

    public boolean isShortEqual() {
        return this.shortEqual;
    }

    public boolean isFilesEqual() {
        return this.filesEqual;
    }

    public int getCommentChangesCount() {
        return this.changes;
    }

    public List<CrucibleNotification> getDiff() {
        this.notifications.clear();
        if (MiscUtil.isModified(this.oldReview.getDescription(), this.newReview.getDescription())) {
            this.notifications.add(new BasisReviewDetailsChangedNotification(this.newReview, CrucibleNotificationType.STATEMENT_OF_OBJECTIVES_CHANGED, "Statement of Objectives has been changed"));
        }
        if (MiscUtil.isModified(this.oldReview.getName(), this.newReview.getName())) {
            this.notifications.add(new BasisReviewDetailsChangedNotification(this.newReview, CrucibleNotificationType.NAME_CHANGED, "Review name has been changed"));
        }
        if (MiscUtil.isModified(this.oldReview.getModerator(), this.newReview.getModerator())) {
            this.notifications.add(new BasisReviewDetailsChangedNotification(this.newReview, CrucibleNotificationType.MODERATOR_CHANGED, "Moderator has changed"));
        }
        if (MiscUtil.isModified(this.oldReview.getAuthor(), this.newReview.getAuthor())) {
            this.notifications.add(new BasisReviewDetailsChangedNotification(this.newReview, CrucibleNotificationType.AUTHOR_CHANGED, "Author has changed"));
        }
        if (MiscUtil.isModified(this.oldReview.getSummary(), this.newReview.getSummary())) {
            this.notifications.add(new BasisReviewDetailsChangedNotification(this.newReview, CrucibleNotificationType.SUMMARY_CHANGED, "Summary has been changed"));
        }
        if (MiscUtil.isModified(this.oldReview.getProjectKey(), this.newReview.getProjectKey())) {
            this.notifications.add(new BasisReviewDetailsChangedNotification(this.newReview, CrucibleNotificationType.PROJECT_CHANGED, "Project has been changed"));
        }
        if (MiscUtil.isModified(this.oldReview.getDueDate(), this.newReview.getDueDate())) {
            this.notifications.add(new BasisReviewDetailsChangedNotification(this.newReview, CrucibleNotificationType.DUE_DATE_CHANGED, "Due date has been changed"));
        }
        this.processReviewers();
        this.shortEqual = this.isShortContentEqual();
        if (!this.shortEqual) {
            this.notifications.add(new ReviewDataChangedNotification(this.newReview));
        }
        this.filesEqual = this.areFilesEqual();
        this.changes = this.checkComments(this.oldReview, this.newReview, true);
        return this.notifications;
    }

    private boolean isShortContentEqual() {
        return !this.stateChanged() && this.areActionsEqual() && this.oldReview.isAllowReviewerToJoin() == this.newReview.isAllowReviewerToJoin() && this.oldReview.getMetricsVersion() == this.newReview.getMetricsVersion() && ReviewDifferenceProducer.areObjectsEqual(this.oldReview.getCloseDate(), this.newReview.getCloseDate()) && ReviewDifferenceProducer.areObjectsEqual(this.oldReview.getCreateDate(), this.newReview.getCreateDate()) && ReviewDifferenceProducer.areObjectsEqual(this.oldReview.getCreator(), this.newReview.getCreator()) && ReviewDifferenceProducer.areObjectsEqual(this.oldReview.getParentReview(), this.newReview.getParentReview()) && ReviewDifferenceProducer.areObjectsEqual(this.oldReview.getRepoName(), this.newReview.getRepoName()) && this.areTransitionsEqual();
    }

    private boolean areFilesEqual() {
        Set<CrucibleFileInfo> l = this.oldReview.getFiles();
        Set<CrucibleFileInfo> r = this.newReview.getFiles();
        if (l == null && r == null) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        boolean areFilesEqual = l.equals(r);
        if (!areFilesEqual) {
            for (CrucibleFileInfo crucibleFileInfo : r) {
                if (l.contains(crucibleFileInfo)) continue;
                this.notifications.add(new NewReviewItemNotification(this.newReview));
            }
            for (CrucibleFileInfo crucibleFileInfo : l) {
                if (r.contains(crucibleFileInfo)) continue;
                this.notifications.add(new RemovedReviewItemNotification(this.oldReview));
            }
        }
        return areFilesEqual;
    }

    private boolean areActionsEqual() {
        Set<CrucibleAction> l = this.oldReview.getActions();
        Set<CrucibleAction> r = this.newReview.getActions();
        return ReviewDifferenceProducer.areObjectsEqual(l, r);
    }

    private boolean areTransitionsEqual() {
        Set<CrucibleAction> l = this.oldReview.getTransitions();
        Set<CrucibleAction> r = this.newReview.getTransitions();
        return ReviewDifferenceProducer.areObjectsEqual(l, r);
    }

    private static <T> boolean areObjectsEqual(T oldReview, T newReview) {
        return MiscUtil.isEqual(oldReview, newReview);
    }

    private boolean stateChanged() {
        if (!MiscUtil.isEqual(this.oldReview.getState(), this.newReview.getState())) {
            this.notifications.add(new ReviewStateChangedNotification(this.newReview, this.oldReview.getState()));
            return true;
        }
        return false;
    }

    @Nullable
    private Collection<String> buildReviewerSet(@Nullable Set<Reviewer> reviewers) {
        if (reviewers == null) {
            return null;
        }
        HashSet<String> res = new HashSet<String>(reviewers.size() * 2);
        for (Reviewer reviewer : reviewers) {
            res.add(reviewer.getUsername());
        }
        return res;
    }

    private void processReviewers() {
        Collection<String> newR;
        boolean allCompleted = true;
        boolean atLeastOneChanged = false;
        Set<Reviewer> oldReviewers = this.oldReview.getReviewers();
        Set<Reviewer> newReviewers = this.newReview.getReviewers();
        Collection<String> oldR = this.buildReviewerSet(oldReviewers);
        if (MiscUtil.isModified(oldR, newR = this.buildReviewerSet(newReviewers))) {
            this.notifications.add(new BasisReviewDetailsChangedNotification(this.newReview, CrucibleNotificationType.REVIEWERS_CHANGED, "Reviewers have been changed"));
        }
        if (oldReviewers == null || newReviewers == null) {
            return;
        }
        for (Reviewer reviewer : newReviewers) {
            for (Reviewer oldReviewer : oldReviewers) {
                if (!reviewer.getUsername().equals(oldReviewer.getUsername()) || reviewer.isCompleted() == oldReviewer.isCompleted()) continue;
                this.notifications.add(new ReviewerCompletedNotification(this.newReview, reviewer));
                atLeastOneChanged = true;
            }
            if (reviewer.isCompleted()) continue;
            allCompleted = false;
        }
        if (allCompleted && atLeastOneChanged) {
            this.notifications.add(new ReviewCompletedNotification(this.newReview));
        }
    }

    private int checkComments(Review anOldReview, Review aNewReview, boolean checkFiles) {
        int commentChanges = 0;
        Set<Comment> allOldComments = this.getAllCommentsRecursively(anOldReview.getGeneralComments());
        Set<Comment> allNewComments = this.getAllCommentsRecursively(aNewReview.getGeneralComments());
        for (Comment comment : allNewComments) {
            Object existing = null;
            for (Comment oldComment : allOldComments) {
                if (!comment.getPermId().getId().equals(oldComment.getPermId().getId())) continue;
                existing = oldComment;
                break;
            }
            if (existing != null && !this.commentContentsDiffer((Comment)existing, comment) && ((Comment)existing).getReadState() == comment.getReadState()) continue;
            ++commentChanges;
            if (existing == null) {
                this.notifications.add(new NewCommentNotification(aNewReview, comment));
                continue;
            }
            if (this.commentContentsDiffer((Comment)existing, comment)) {
                this.notifications.add(new UpdatedCommentNotification(aNewReview, comment, ((Comment)existing).isDraft()));
            }
            this.checkAndNotifyReadUnreadStateChange(aNewReview, comment, (Comment)existing);
        }
        Set<Comment> deletedGen = this.getDeletedComments(allOldComments, allNewComments);
        for (Comment gc : deletedGen) {
            ++commentChanges;
            this.notifications.add(new RemovedCommentNotification(aNewReview, gc));
        }
        if (checkFiles) {
            int versionedChanges = 0;
            for (CrucibleFileInfo fileInfo : aNewReview.getFiles()) {
                allNewComments = this.getAllCommentsRecursively(fileInfo.getVersionedComments());
                for (Comment comment : allNewComments) {
                    if (comment == null) continue;
                    Comment existing = null;
                    block5: for (CrucibleFileInfo oldFile : anOldReview.getFiles()) {
                        if (!oldFile.getPermId().equals(fileInfo.getPermId())) continue;
                        allOldComments = this.getAllCommentsRecursively(oldFile.getVersionedComments());
                        for (Comment oldComment : allOldComments) {
                            if (comment.getPermId() == null || oldComment == null || oldComment.getPermId() == null || !comment.getPermId().getId().equals(oldComment.getPermId().getId())) continue;
                            existing = oldComment;
                            continue block5;
                        }
                    }
                    if (existing != null && !this.commentContentsDiffer(existing, comment) && existing.getReadState() == comment.getReadState()) continue;
                    ++versionedChanges;
                    if (existing == null) {
                        this.notifications.add(new NewCommentNotification(aNewReview, comment));
                        continue;
                    }
                    if (this.commentContentsDiffer(existing, comment)) {
                        this.notifications.add(new UpdatedCommentNotification(aNewReview, comment, existing.isDraft()));
                    }
                    this.checkAndNotifyReadUnreadStateChange(aNewReview, comment, existing);
                }
            }
            for (CrucibleFileInfo oldFile : anOldReview.getFiles()) {
                for (CrucibleFileInfo newFile : aNewReview.getFiles()) {
                    if (!oldFile.getPermId().equals(newFile.getPermId())) continue;
                    Set<Comment> oldVersionedComments = this.getAllCommentsRecursively(oldFile.getVersionedComments());
                    Set<Comment> newVersionedComments = this.getAllCommentsRecursively(newFile.getVersionedComments());
                    Set<Comment> deletedVcs = this.getDeletedComments(oldVersionedComments, newVersionedComments);
                    for (Comment vc : deletedVcs) {
                        ++versionedChanges;
                        this.notifications.add(new RemovedCommentNotification(aNewReview, vc));
                    }
                }
            }
            if (versionedChanges > 0) {
                commentChanges += versionedChanges;
                this.filesEqual = false;
            }
        }
        return commentChanges;
    }

    @NotNull
    private <T extends Comment> Set<Comment> getAllCommentsRecursively(@NotNull List<T> generalComments) {
        Set<Comment> result = MiscUtil.buildHashSet();
        for (Comment c : generalComments) {
            result.add(c);
            List<Comment> replies = c.getReplies();
            if (replies == null || replies.size() <= 0) continue;
            result.addAll(this.getAllCommentsRecursively(replies));
        }
        return result;
    }

    private void checkAndNotifyReadUnreadStateChange(Review aNewReview, Comment comment, Comment existing) {
        if (existing.getReadState() != comment.getReadState()) {
            this.notifications.add(new CommentReadUnreadStateChangedNotification(aNewReview, comment));
        }
    }

    private boolean commentContentsDiffer(Comment existing, Comment comment) {
        return !existing.getMessage().equals(comment.getMessage()) || existing.isDefectRaised() != comment.isDefectRaised() || existing.isDraft() != comment.isDraft();
    }

    private <T extends Comment> Set<T> getDeletedComments(Collection<T> org, Collection<T> modified) {
        Set deletedList = MiscUtil.buildHashSet();
        for (Comment corg : org) {
            boolean found = false;
            for (Comment cnew : modified) {
                if (cnew == null || cnew.getPermId() == null || corg == null || !cnew.getPermId().equals(corg.getPermId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            deletedList.add(corg);
        }
        return deletedList;
    }
}

