/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg.xstream;

import com.atlassian.theplugin.commons.cfg.PrivateConfigurationDao;
import com.atlassian.theplugin.commons.cfg.PrivateServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerCfgFactoryException;
import com.atlassian.theplugin.commons.cfg.ServerId;
import com.atlassian.theplugin.commons.cfg.xstream.BasePrivateConfigurationDao;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeDirPrivateConfigurationDao
extends BasePrivateConfigurationDao<PrivateServerCfgInfo>
implements PrivateConfigurationDao {
    private static final String ROOT_ELEMENT_NAME = "single-server-private-cfg";

    @Override
    public PrivateServerCfgInfo load(ServerId id) throws ServerCfgFactoryException {
        File atlassianDir = HomeDirPrivateConfigurationDao.getPrivateCfgDirectorySavePath();
        if (this.isDirReady()) {
            File serverCfgFile = new File(atlassianDir.getAbsolutePath(), id.toString());
            if (serverCfgFile.isFile() && serverCfgFile.canRead()) {
                Document doc;
                SAXBuilder builder = new SAXBuilder(false);
                try {
                    doc = builder.build(serverCfgFile.toURI().toString());
                }
                catch (JDOMException e) {
                    throw new ServerCfgFactoryException("Cannot parse server cfg file " + e.getMessage());
                }
                catch (IOException e) {
                    throw new ServerCfgFactoryException("Cannot read sever cfg file " + e.getMessage());
                }
                PrivateServerCfgInfo privateServerCfgInfo = null;
                if (doc != null) {
                    privateServerCfgInfo = HomeDirPrivateConfigurationDao.load(doc);
                }
                return privateServerCfgInfo;
            }
            return null;
        }
        throw new ServerCfgFactoryException("Cannot read private configuration stored in directory [" + atlassianDir.getAbsolutePath() + "]. Directory does not exist or is not accessible");
    }

    static PrivateServerCfgInfo load(Document doc) throws ServerCfgFactoryException {
        return HomeDirPrivateConfigurationDao.loadJDom(doc.getRootElement(), PrivateServerCfgInfo.class, false);
    }

    @Override
    public void save(@NotNull PrivateServerCfgInfo info) throws ServerCfgFactoryException {
        Document document = this.createJDom(info);
        try {
            this.writeXmlFile(document.getRootElement(), new File(HomeDirPrivateConfigurationDao.getPrivateCfgDirectorySavePath(), info.getServerId().toString()));
        }
        catch (IOException e) {
            ServerCfgFactoryException ex = new ServerCfgFactoryException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    public void deleteFile(ServerCfg server) {
        File toDelete = new File(HomeDirPrivateConfigurationDao.getPrivateCfgDirectoryPath(), server.getServerId().toString());
        if (toDelete.exists() && toDelete.canWrite()) {
            toDelete.delete();
        }
    }
}

