/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira.rest;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.jira.JIRAAction;
import com.atlassian.connector.commons.jira.JIRAActionBean;
import com.atlassian.connector.commons.jira.JIRAActionField;
import com.atlassian.connector.commons.jira.JIRAActionFieldBean;
import com.atlassian.connector.commons.jira.JIRAIssue;
import com.atlassian.connector.commons.jira.JIRAIssueBean;
import com.atlassian.connector.commons.jira.JIRASessionPartOne;
import com.atlassian.connector.commons.jira.JIRASessionPartTwo;
import com.atlassian.connector.commons.jira.JiraUserNotFoundException;
import com.atlassian.connector.commons.jira.beans.JIRAAttachment;
import com.atlassian.connector.commons.jira.beans.JIRAComment;
import com.atlassian.connector.commons.jira.beans.JIRAComponentBean;
import com.atlassian.connector.commons.jira.beans.JIRAConstant;
import com.atlassian.connector.commons.jira.beans.JIRAIssueTypeBean;
import com.atlassian.connector.commons.jira.beans.JIRAPriorityBean;
import com.atlassian.connector.commons.jira.beans.JIRAProject;
import com.atlassian.connector.commons.jira.beans.JIRAProjectBean;
import com.atlassian.connector.commons.jira.beans.JIRAQueryFragment;
import com.atlassian.connector.commons.jira.beans.JIRAResolutionBean;
import com.atlassian.connector.commons.jira.beans.JIRASavedFilter;
import com.atlassian.connector.commons.jira.beans.JIRASavedFilterBean;
import com.atlassian.connector.commons.jira.beans.JIRASecurityLevelBean;
import com.atlassian.connector.commons.jira.beans.JIRAStatusBean;
import com.atlassian.connector.commons.jira.beans.JIRAUserBean;
import com.atlassian.connector.commons.jira.beans.JIRAVersionBean;
import com.atlassian.connector.commons.jira.beans.JiraFilter;
import com.atlassian.connector.commons.jira.rss.JIRAException;
import com.atlassian.jira.rest.client.AuthenticationHandler;
import com.atlassian.jira.rest.client.GetCreateIssueMetadataOptionsBuilder;
import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.OptionalIterable;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.auth.AnonymousAuthenticationHandler;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.domain.Attachment;
import com.atlassian.jira.rest.client.domain.Authentication;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.BasicProject;
import com.atlassian.jira.rest.client.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.domain.CimIssueType;
import com.atlassian.jira.rest.client.domain.CimProject;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.FavouriteFilter;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueFieldId;
import com.atlassian.jira.rest.client.domain.IssueType;
import com.atlassian.jira.rest.client.domain.Priority;
import com.atlassian.jira.rest.client.domain.Resolution;
import com.atlassian.jira.rest.client.domain.SearchResult;
import com.atlassian.jira.rest.client.domain.SecurityLevel;
import com.atlassian.jira.rest.client.domain.SessionCookie;
import com.atlassian.jira.rest.client.domain.Status;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.User;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.domain.input.WorklogInputBuilder;
import com.atlassian.jira.rest.client.internal.jersey.JerseyJiraRestClientBuilder;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.ServerData;
import com.atlassian.theplugin.commons.remoteapi.jira.JiraCaptchaRequiredException;
import com.atlassian.theplugin.commons.util.HttpConfigurableAdapter;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.client.apache.config.ApacheHttpClientConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRestSessionImpl
implements JIRASessionPartOne,
JIRASessionPartTwo {
    private final ConnectionCfg server;
    private final HttpConfigurableAdapter proxyInfo;
    private final JiraRestClient restClient;
    final NullProgressMonitor pm = new NullProgressMonitor();
    private Authentication authentication = null;
    private ApacheHttpClientConfig apacheClientConfig = null;

    public JiraRestSessionImpl(ConnectionCfg server, HttpConfigurableAdapter proxyInfo) throws URISyntaxException {
        this.server = server;
        this.proxyInfo = proxyInfo;
        this.restClient = ((ServerData)server).isUseSessionCookies() ? new JerseyJiraRestClientBuilder().header("User-Agent", "Atlassian IntelliJ IDEA Connector").queryParam("requestSource", "intellij-ide-connector").create(new URI(server.getUrl()), (AuthenticationHandler)new AnonymousAuthenticationHandler(){

            public void configure(ApacheHttpClientConfig config) {
                super.configure(config);
                JiraRestSessionImpl.this.setupApacheClient(config);
            }

            public void configure(Filterable filterable, Client client) {
                super.configure(filterable, client);
                JiraRestSessionImpl.this.setupApacheClient(JiraRestSessionImpl.this.apacheClientConfig);
            }
        }) : new JerseyJiraRestClientBuilder().header("User-Agent", "Atlassian IntelliJ IDEA Connector").queryParam("requestSource", "intellij-ide-connector").create(new URI(server.getUrl()), (AuthenticationHandler)new BasicHttpAuthenticationHandler(server.getUsername(), server.getPassword()){

            public void configure(ApacheHttpClientConfig config) {
                config.getProperties().put("com.sun.jersey.impl.client.httpclient.handleCookies", true);
                config.getState().getHttpState().setCookiePolicy(0);
                super.configure(config);
                config.getProperties().put("com.sun.jersey.impl.client.httpclient.preemptiveAuthentication", false);
                JiraRestSessionImpl.this.setupApacheClient(config);
            }

            public void configure(Filterable filterable, Client client) {
                super.configure(filterable, client);
                JiraRestSessionImpl.this.setupApacheClient(JiraRestSessionImpl.this.apacheClientConfig);
            }
        });
        if (proxyInfo != null && proxyInfo.isUseHttpProxy()) {
            this.restClient.getTransportClient().getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + proxyInfo.getProxyHost() + ":" + proxyInfo.getProxyPort());
        }
        if (((ServerData)server).isUseSessionCookies()) {
            this.restClient.getTransportClient().getProperties().put("com.sun.jersey.impl.client.httpclient.handleCookies", true);
            this.restClient.getTransportClient().getClientHandler().getHttpClient().getParams().setCookiePolicy("compatibility");
        }
    }

    public boolean supportsRest() throws JIRAException {
        try {
            return this.restClient.getMetadataClient().getServerInfo((ProgressMonitor)this.pm).getBuildNumber() >= 700;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void login(final String userName, final String password) throws RemoteApiException {
        this.wrapWithRemoteApiException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JiraRestSessionImpl.this.authentication = JiraRestSessionImpl.this.restClient.getSessionClient().login(userName, password, (ProgressMonitor)JiraRestSessionImpl.this.pm);
                return null;
            }
        });
    }

    @Override
    public void logout() {
        this.authentication = null;
    }

    @Override
    public List<JIRAProject> getProjects() throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAProject>>(){

            @Override
            public List<JIRAProject> call() throws Exception {
                Iterable projects = JiraRestSessionImpl.this.restClient.getProjectClient().getAllProjects((ProgressMonitor)JiraRestSessionImpl.this.pm);
                ArrayList result = Lists.newArrayList();
                for (BasicProject project : projects) {
                    Long id = project.getId();
                    result.add(new JIRAProjectBean(id != null ? id : -1L, project.getKey(), project.getName()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAConstant> getIssueTypes() throws RemoteApiException {
        return this.getIssueTypes(false);
    }

    @Override
    public List<JIRAConstant> getSubtaskIssueTypes() throws RemoteApiException {
        return this.getIssueTypes(true);
    }

    private List<JIRAConstant> getIssueTypes(final boolean subtasks) throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAConstant>>(){

            @Override
            public List<JIRAConstant> call() throws Exception {
                Iterable issueTypes = JiraRestSessionImpl.this.restClient.getMetadataClient().getIssueTypes((ProgressMonitor)JiraRestSessionImpl.this.pm);
                ArrayList result = Lists.newArrayList();
                for (IssueType type : issueTypes) {
                    Long id = type.getId();
                    if (type.isSubtask() != subtasks || id == null) continue;
                    result.add(new JIRAIssueTypeBean(id, type.getName(), type.getIconUri().toURL()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAConstant> getIssueTypesForProject(long projectId, String projectKey) throws RemoteApiException {
        return this.getIssueTypesForProject(projectKey, false);
    }

    @Override
    public List<JIRAConstant> getSubtaskIssueTypesForProject(long projectId, String projectKey) throws RemoteApiException {
        return this.getIssueTypesForProject(projectKey, true);
    }

    private List<JIRAConstant> getIssueTypesForProject(final String projectKey, final boolean subtasks) throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAConstant>>(){

            @Override
            public List<JIRAConstant> call() throws Exception {
                OptionalIterable issueTypes = JiraRestSessionImpl.this.restClient.getProjectClient().getProject(projectKey, (ProgressMonitor)JiraRestSessionImpl.this.pm).getIssueTypes();
                ArrayList result = Lists.newArrayList();
                for (IssueType issueType : issueTypes) {
                    if (subtasks != issueType.isSubtask()) continue;
                    Long id = issueType.getId();
                    result.add(new JIRAIssueTypeBean(id != null ? id : -1L, issueType.getName(), issueType.getIconUri().toURL()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAConstant> getStatuses() throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAConstant>>(){

            @Override
            public List<JIRAConstant> call() throws Exception {
                Iterable statuses = JiraRestSessionImpl.this.restClient.getMetadataClient().getStatuses((ProgressMonitor)JiraRestSessionImpl.this.pm);
                ArrayList result = Lists.newArrayList();
                for (Status status : statuses) {
                    Long id = status.getId();
                    result.add(new JIRAStatusBean(id != null ? id : -1L, status.getName(), status.getIconUrl().toURL()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAComponentBean> getComponents(final String projectKey) throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAComponentBean>>(){

            @Override
            public List<JIRAComponentBean> call() throws Exception {
                Iterable components = JiraRestSessionImpl.this.restClient.getProjectClient().getProject(projectKey, (ProgressMonitor)JiraRestSessionImpl.this.pm).getComponents();
                ArrayList result = Lists.newArrayList();
                for (BasicComponent component : components) {
                    Long id = component.getId();
                    result.add(new JIRAComponentBean(id != null ? id : -1L, component.getName()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAVersionBean> getVersions(final String projectKey) throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAVersionBean>>(){

            @Override
            public List<JIRAVersionBean> call() throws Exception {
                Iterable versions = JiraRestSessionImpl.this.restClient.getProjectClient().getProject(projectKey, (ProgressMonitor)JiraRestSessionImpl.this.pm).getVersions();
                ArrayList result = Lists.newArrayList();
                for (Version version : versions) {
                    Long id = version.getId();
                    result.add(new JIRAVersionBean(id != null ? id : -1L, version.getName(), version.isReleased()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAPriorityBean> getPriorities() throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAPriorityBean>>(){

            @Override
            public List<JIRAPriorityBean> call() throws Exception {
                Iterable priorities = JiraRestSessionImpl.this.restClient.getMetadataClient().getPriorities((ProgressMonitor)JiraRestSessionImpl.this.pm);
                ArrayList result = Lists.newArrayList();
                int order = 0;
                for (Priority priority : priorities) {
                    Long id = priority.getId();
                    result.add(new JIRAPriorityBean(id != null ? id : -1L, order++, priority.getName(), priority.getIconUri().toURL()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAResolutionBean> getResolutions() throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAResolutionBean>>(){

            @Override
            public List<JIRAResolutionBean> call() throws Exception {
                Iterable resolutions = JiraRestSessionImpl.this.restClient.getMetadataClient().getResolutions((ProgressMonitor)JiraRestSessionImpl.this.pm);
                ArrayList result = Lists.newArrayList();
                for (Resolution status : resolutions) {
                    Long id = status.getId();
                    result.add(new JIRAResolutionBean(id != null ? id : -1L, status.getName()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAQueryFragment> getSavedFilters() throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAQueryFragment>>(){

            @Override
            public List<JIRAQueryFragment> call() throws Exception {
                Iterable filters = JiraRestSessionImpl.this.restClient.getSearchClient().getFavouriteFilters(JiraRestSessionImpl.this.pm);
                ArrayList result = Lists.newArrayList();
                for (FavouriteFilter filter : filters) {
                    Long id = filter.getId();
                    String jql = filter.getJql();
                    jql = jql != null ? jql.replace("\\\"", "\"") : "";
                    result.add(new JIRASavedFilterBean(filter.getName(), id != null ? id : -1L, jql, filter.getSearchUrl(), filter.getViewUrl()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAAction> getAvailableActions(final JIRAIssue issue) throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAAction>>(){

            @Override
            public List<JIRAAction> call() throws Exception {
                ArrayList result = Lists.newArrayList();
                Iterable transitions = JiraRestSessionImpl.this.restClient.getIssueClient().getTransitions((Issue)issue.getApiIssueObject(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                for (Transition transition : transitions) {
                    result.add(new JIRAActionBean(transition.getId(), transition.getName()));
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAActionField> getFieldsForAction(final JIRAIssue issue, final JIRAAction action) throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAActionField>>(){

            @Override
            public List<JIRAActionField> call() throws Exception {
                Iterable transitions = JiraRestSessionImpl.this.restClient.getIssueClient().getTransitions((Issue)issue.getApiIssueObject(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                ArrayList result = Lists.newArrayList();
                for (Transition transition : transitions) {
                    if ((long)transition.getId() != action.getId()) continue;
                    for (Transition.Field field : transition.getFields()) {
                        JIRAActionFieldBean f = new JIRAActionFieldBean(field.getId(), field.getName());
                        result.add(f);
                    }
                }
                return result;
            }
        });
    }

    @Override
    public void progressWorkflowAction(final JIRAIssue issue, final JIRAAction action, final List<JIRAActionField> fields) throws RemoteApiException {
        final ArrayList fieldValues = Lists.newArrayList();
        if (fields == null || fields.size() == 0) {
            this.wrapWithRemoteApiException(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    TransitionInput t = new TransitionInput((int)action.getId(), (Collection)fieldValues);
                    JiraRestSessionImpl.this.restClient.getIssueClient().transition((Issue)issue.getApiIssueObject(), t, (ProgressMonitor)JiraRestSessionImpl.this.pm);
                    return null;
                }
            });
        } else {
            this.wrapWithRemoteApiException(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Issue iszju = JiraRestSessionImpl.this.restClient.getIssueClient().getIssue(issue.getKey(), (Iterable)ImmutableList.of((Object)IssueRestClient.Expandos.EDITMETA), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                    fieldValues.addAll(JiraRestSessionImpl.this.generateFieldValues(issue, iszju, fields));
                    TransitionInput t = new TransitionInput((int)action.getId(), (Collection)fieldValues);
                    JiraRestSessionImpl.this.restClient.getIssueClient().transition((Issue)issue.getApiIssueObject(), t, (ProgressMonitor)JiraRestSessionImpl.this.pm);
                    return null;
                }
            });
        }
    }

    @Override
    public void setField(JIRAIssue issue, String fieldId, String value) throws RemoteApiException {
        JIRAActionFieldBean f = new JIRAActionFieldBean(fieldId, null);
        f.addValue(value);
        this.setFields(issue, (List<JIRAActionField>)ImmutableList.of((Object)f));
    }

    @Override
    public void setField(JIRAIssue issue, String fieldId, String[] values) throws RemoteApiException {
        JIRAActionFieldBean f = new JIRAActionFieldBean(fieldId, null);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            f.addValue(value);
            ++n2;
        }
        this.setFields(issue, (List<JIRAActionField>)ImmutableList.of((Object)f));
    }

    @Override
    public void setFields(final JIRAIssue issue, final List<JIRAActionField> fields) throws RemoteApiException {
        this.wrapWithRemoteApiException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Issue iszju = JiraRestSessionImpl.this.restClient.getIssueClient().getIssue(issue.getKey(), (Iterable)ImmutableList.of((Object)IssueRestClient.Expandos.EDITMETA), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                JiraRestSessionImpl.this.restClient.getIssueClient().update(iszju, (Iterable)JiraRestSessionImpl.this.generateFieldValues(issue, iszju, fields), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                return null;
            }
        });
    }

    private Collection<FieldInput> generateFieldValues(JIRAIssue issue, Issue iszju, List<JIRAActionField> fieldValues) throws RemoteApiException {
        JSONObject editmeta = JsonParseUtil.getOptionalJsonObject((JSONObject)iszju.getRawObject(), (String)"editmeta");
        if (editmeta == null) {
            throw new RemoteApiException("Unable to retrieve issue's editmeta information");
        }
        JSONObject fields = JsonParseUtil.getOptionalJsonObject((JSONObject)editmeta, (String)"fields");
        try {
            if (fields != null) {
                ArrayList result = Lists.newArrayList();
                for (JIRAActionField field : fieldValues) {
                    JSONObject fieldDef = JsonParseUtil.getOptionalJsonObject((JSONObject)fields, (String)field.getFieldId());
                    FieldInput fieldInput = null;
                    if (fieldDef != null) {
                        fieldInput = field.generateFieldValue(issue, fieldDef);
                    } else if (field.getFieldId().equals("resolution")) {
                        fieldInput = new FieldInput("resolution", (Object)new ComplexIssueInputFieldValue((Map)ImmutableMap.of((Object)"id", (Object)field.getValues().get(0))));
                    }
                    if (fieldInput == null) continue;
                    result.add(fieldInput);
                }
                return result;
            }
        }
        catch (JSONException e) {
            throw new RemoteApiException("Unable to generate field values", e);
        }
        return null;
    }

    @Override
    public JIRAUserBean getUser(final String loginName) throws RemoteApiException, JiraUserNotFoundException {
        return this.wrapWithRemoteApiException(new Callable<JIRAUserBean>(){

            @Override
            public JIRAUserBean call() throws Exception {
                User user = JiraRestSessionImpl.this.restClient.getUserClient().getUser(loginName, (ProgressMonitor)JiraRestSessionImpl.this.pm);
                return new JIRAUserBean(-1L, user.getDisplayName(), user.getName()){

                    public String getQueryStringFragment() {
                        return null;
                    }

                    public JIRAQueryFragment getClone() {
                        return null;
                    }
                };
            }
        });
    }

    @Override
    public List<JIRAComment> getComments(JIRAIssue issue) throws RemoteApiException {
        if (issue.getComments() == null) {
            return Lists.newArrayList();
        }
        return issue.getComments();
    }

    @Override
    public Collection<JIRAAttachment> getIssueAttachements(final JIRAIssue issue) throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<Collection<JIRAAttachment>>(){

            @Override
            public Collection<JIRAAttachment> call() throws Exception {
                Issue iszju = JiraRestSessionImpl.this.restClient.getIssueClient().getIssue(issue.getKey(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                ArrayList result = Lists.newArrayList();
                Iterable attachments = iszju.getAttachments();
                if (attachments != null) {
                    for (Attachment attachment : attachments) {
                        Long id = attachment.getId();
                        JIRAAttachment a = new JIRAAttachment(id != null ? id.toString() : "-1", attachment.getAuthor().getName(), attachment.getFilename(), attachment.getSize(), attachment.getMimeType(), attachment.getCreationDate().toGregorianCalendar());
                        result.add(a);
                    }
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRASecurityLevelBean> getSecurityLevels(final String projectKey) throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRASecurityLevelBean>>(){

            @Override
            public List<JIRASecurityLevelBean> call() throws Exception {
                GetCreateIssueMetadataOptionsBuilder builder = new GetCreateIssueMetadataOptionsBuilder();
                builder.withExpandedIssueTypesFields().withProjectKeys(new String[]{projectKey});
                Iterable metadata = JiraRestSessionImpl.this.restClient.getIssueClient().getCreateIssueMetadata(builder.build(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                if (metadata == null || !metadata.iterator().hasNext()) {
                    return Lists.newArrayList();
                }
                CimProject project = (CimProject)metadata.iterator().next();
                HashMap levels = Maps.newHashMap();
                for (CimIssueType type : project.getIssueTypes()) {
                    Iterable allowedValues;
                    Map fields = type.getFields();
                    CimFieldInfo security = (CimFieldInfo)fields.get("security");
                    if (security == null || (allowedValues = security.getAllowedValues()) == null) continue;
                    for (Object lvl : allowedValues) {
                        SecurityLevel secLevel = (SecurityLevel)lvl;
                        Long id = secLevel.getId();
                        if (levels.containsKey(id)) continue;
                        levels.put(id, new JIRASecurityLevelBean(id, secLevel.getName()));
                    }
                }
                return Lists.newArrayList(levels.values());
            }
        });
    }

    public List<JIRAProject> getProjectsForIssueCreation() throws RemoteApiException {
        return this.wrapWithRemoteApiException(new Callable<List<JIRAProject>>(){

            @Override
            public List<JIRAProject> call() throws Exception {
                GetCreateIssueMetadataOptionsBuilder builder = new GetCreateIssueMetadataOptionsBuilder();
                Iterable metadata = JiraRestSessionImpl.this.restClient.getIssueClient().getCreateIssueMetadata(builder.build(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                if (metadata == null || !metadata.iterator().hasNext()) {
                    return Lists.newArrayList();
                }
                ArrayList result = Lists.newArrayList();
                for (CimProject cimProject : metadata) {
                    Long id = cimProject.getId();
                    if (id == null) continue;
                    JIRAProjectBean p = new JIRAProjectBean(id, cimProject.getKey(), cimProject.getName());
                    result.add(p);
                }
                return result;
            }
        });
    }

    @Override
    public List<JIRAIssue> getIssues(JiraFilter filter, String sortBy, String sortOrder, int start, int max) throws JIRAException {
        return this.getIssues(filter.getJql(), sortBy, sortOrder, start, max);
    }

    @Override
    public List<JIRAIssue> getSavedFilterIssues(JIRASavedFilter filter, String sortBy, String sortOrder, int start, int max) throws JIRAException {
        return this.getIssues(filter.getJql(), sortBy, sortOrder, start, max);
    }

    @Override
    public List<JIRAIssue> getIssues(final String jql, final String sortBy, final String sortOrder, final int start, final int max) throws JIRAException {
        return this.wrapWithJiraException(new Callable<List<JIRAIssue>>(){

            @Override
            public List<JIRAIssue> call() throws Exception {
                String sort = jql.toLowerCase().contains("order by") ? "" : (StringUtils.isNotEmpty((String)sortBy) && StringUtils.isNotEmpty((String)sortOrder) ? " order by " + sortBy + " " + sortOrder : "");
                SearchResult result = JiraRestSessionImpl.this.restClient.getSearchClient().searchJqlWithFullIssues(String.valueOf(jql) + sort, max, start, (ProgressMonitor)JiraRestSessionImpl.this.pm);
                ArrayList list = Lists.newArrayList();
                for (BasicIssue issue : result.getIssues()) {
                    JIRAIssueBean bean = new JIRAIssueBean(JiraRestSessionImpl.this.server.getUrl(), (Issue)issue);
                    list.add(bean);
                }
                return list;
            }
        });
    }

    @Override
    public JIRAIssue getIssue(final String issueKey) throws JIRAException {
        return this.wrapWithJiraException(new Callable<JIRAIssue>(){

            @Override
            public JIRAIssue call() throws Exception {
                Issue issue = JiraRestSessionImpl.this.restClient.getIssueClient().getIssue(issueKey, (Iterable)ImmutableList.of((Object)IssueRestClient.Expandos.RENDERED_FIELDS, (Object)IssueRestClient.Expandos.EDITMETA), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                return new JIRAIssueBean(JiraRestSessionImpl.this.server.getUrl(), issue);
            }
        });
    }

    @Override
    public JIRAIssue getIssueDetails(JIRAIssue issue) throws RemoteApiException {
        try {
            return this.getIssue(issue.getKey());
        }
        catch (JIRAException e) {
            throw new RemoteApiException(e);
        }
    }

    @Override
    public void logWork(final JIRAIssue issue, final String timeSpent, final Calendar startDate, final String comment, final boolean updateEstimate, final String newEstimate) throws RemoteApiException {
        this.wrapWithRemoteApiException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Issue iszju = JiraRestSessionImpl.this.restClient.getIssueClient().getIssue(issue.getKey(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                WorklogInputBuilder builder = new WorklogInputBuilder(iszju.getSelf());
                builder.setStartDate(new DateTime((Object)startDate));
                builder.setTimeSpent(timeSpent);
                if (updateEstimate) {
                    if (newEstimate != null) {
                        builder.setAdjustEstimateNew(newEstimate);
                    } else {
                        builder.setAdjustEstimateAuto();
                    }
                } else {
                    builder.setAdjustEstimateLeave();
                }
                builder.setComment(comment);
                JiraRestSessionImpl.this.restClient.getIssueClient().addWorklog(iszju.getWorklogUri(), builder.build(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                return null;
            }
        });
    }

    @Override
    public void addComment(final String issueKey, final String comment) throws RemoteApiException {
        this.wrapWithRemoteApiException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Issue issue = JiraRestSessionImpl.this.restClient.getIssueClient().getIssue(issueKey, (ProgressMonitor)JiraRestSessionImpl.this.pm);
                JiraRestSessionImpl.this.restClient.getIssueClient().addComment((ProgressMonitor)JiraRestSessionImpl.this.pm, issue.getCommentsUri(), Comment.valueOf((String)comment));
                return null;
            }
        });
    }

    @Override
    public void addAttachment(final String issueKey, final String name, final byte[] content) throws RemoteApiException {
        this.wrapWithRemoteApiException(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Issue issue = JiraRestSessionImpl.this.restClient.getIssueClient().getIssue(issueKey, (ProgressMonitor)JiraRestSessionImpl.this.pm);
                JiraRestSessionImpl.this.restClient.getIssueClient().addAttachment((ProgressMonitor)JiraRestSessionImpl.this.pm, issue.getAttachmentsUri(), (InputStream)new ByteArrayInputStream(content), name);
                return null;
            }
        });
    }

    @Override
    public JIRAIssue createIssue(JIRAIssue issue) throws RemoteApiException {
        return this.createIssueOrSubtask(null, issue);
    }

    public JIRAIssue createSubtask(JIRAIssue parent, JIRAIssue issue) throws RemoteApiException {
        return this.createIssueOrSubtask(parent, issue);
    }

    private JIRAIssue createIssueOrSubtask(final JIRAIssue parent, final JIRAIssue issue) throws RemoteApiException {
        final BasicIssue newIssue = this.wrapWithRemoteApiException(new Callable<BasicIssue>(){

            @Override
            public BasicIssue call() throws Exception {
                JIRASecurityLevelBean securityLevel;
                ArrayList versions;
                GetCreateIssueMetadataOptionsBuilder metaBuilder = new GetCreateIssueMetadataOptionsBuilder().withProjectKeys(new String[]{issue.getProjectKey()}).withIssueTypeIds(new Long[]{issue.getTypeConstant().getId()}).withExpandedIssueTypesFields();
                Iterable metadata = JiraRestSessionImpl.this.restClient.getIssueClient().getCreateIssueMetadata(metaBuilder.build(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                String message = "Invalid issue creation metadata";
                if (metadata == null) {
                    throw new RemoteApiException(message);
                }
                Optional cimProjectOptional = Iterables.tryFind((Iterable)metadata, (Predicate)new Predicate<CimProject>(){

                    public boolean apply(CimProject input) {
                        return input != null && input.getKey().equals(issue.getProjectKey());
                    }
                });
                if (!cimProjectOptional.isPresent()) {
                    throw new RemoteApiException(message);
                }
                Optional issueTypeOptional = Iterables.tryFind((Iterable)((CimProject)cimProjectOptional.get()).getIssueTypes(), (Predicate)new Predicate<CimIssueType>(){

                    public boolean apply(CimIssueType input) {
                        return input != null && input.getId().longValue() == issue.getTypeConstant().getId();
                    }
                });
                if (!issueTypeOptional.isPresent()) {
                    throw new RemoteApiException(message);
                }
                CimIssueType typeMeta = (CimIssueType)issueTypeOptional.get();
                IssueInputBuilder builder = new IssueInputBuilder(issue.getProjectKey(), Long.valueOf(issue.getTypeConstant().getId()), issue.getSummary());
                List<JIRAConstant> components = issue.getComponents();
                List<JIRAConstant> affectsVersions = issue.getAffectsVersions();
                List<JIRAConstant> fixVersions = issue.getFixVersions();
                if (JiraRestSessionImpl.this.has(typeMeta, IssueFieldId.COMPONENTS_FIELD) && components != null && components.size() > 0) {
                    ArrayList comps = Lists.newArrayList();
                    for (JIRAConstant component : components) {
                        comps.add(component.getName());
                    }
                    builder.setComponentsNames((Iterable)comps);
                }
                if (JiraRestSessionImpl.this.has(typeMeta, IssueFieldId.AFFECTS_VERSIONS_FIELD) && affectsVersions != null && affectsVersions.size() > 0) {
                    versions = Lists.newArrayList();
                    for (JIRAConstant version : affectsVersions) {
                        versions.add(version.getName());
                    }
                    builder.setAffectedVersionsNames((Iterable)versions);
                }
                if (JiraRestSessionImpl.this.has(typeMeta, IssueFieldId.FIX_VERSIONS_FIELD) && fixVersions != null && fixVersions.size() > 0) {
                    versions = Lists.newArrayList();
                    for (JIRAConstant version : fixVersions) {
                        versions.add(version.getName());
                    }
                    builder.setFixVersionsNames((Iterable)versions);
                }
                if (JiraRestSessionImpl.this.has(typeMeta, IssueFieldId.PRIORITY_FIELD)) {
                    builder.setPriorityId(Long.valueOf(issue.getPriorityConstant().getId()));
                }
                if (JiraRestSessionImpl.this.has(typeMeta, IssueFieldId.DESCRIPTION_FIELD)) {
                    builder.setDescription(issue.getDescription());
                }
                if (JiraRestSessionImpl.this.has(typeMeta, IssueFieldId.ASSIGNEE_FIELD) && issue.getAssigneeId() != null) {
                    builder.setAssigneeName(issue.getAssigneeId());
                }
                String originalEstimate = issue.getOriginalEstimate();
                if (JiraRestSessionImpl.this.has(typeMeta, IssueFieldId.TIMETRACKING_FIELD) && originalEstimate != null && originalEstimate.length() > 0) {
                    builder.setFieldValue(IssueFieldId.TIMETRACKING_FIELD.id, new ComplexIssueInputFieldValue((Map)ImmutableMap.of((Object)"originalEstimate", (Object)originalEstimate)));
                }
                if ((securityLevel = issue.getSecurityLevel()) != null && securityLevel.getId() > 0L) {
                    builder.setFieldValue("security", new ComplexIssueInputFieldValue((Map)ImmutableMap.of((Object)"id", (Object)Long.valueOf(securityLevel.getId()).toString())));
                }
                if (parent != null) {
                    builder.setFieldValue("parent", new ComplexIssueInputFieldValue((Map)ImmutableMap.of((Object)"key", (Object)parent.getKey())));
                }
                return JiraRestSessionImpl.this.restClient.getIssueClient().createIssue(builder.build(), (ProgressMonitor)JiraRestSessionImpl.this.pm);
            }
        });
        return this.wrapWithRemoteApiException(new Callable<JIRAIssue>(){

            @Override
            public JIRAIssue call() throws Exception {
                Issue issue = JiraRestSessionImpl.this.restClient.getIssueClient().getIssue(newIssue.getKey(), (Iterable)ImmutableList.of((Object)IssueRestClient.Expandos.RENDERED_FIELDS, (Object)IssueRestClient.Expandos.EDITMETA), (ProgressMonitor)JiraRestSessionImpl.this.pm);
                return new JIRAIssueBean(JiraRestSessionImpl.this.server.getUrl(), issue);
            }
        });
    }

    private boolean has(CimIssueType meta, IssueFieldId id) {
        return meta.getField(id) != null;
    }

    @Override
    public void login() throws JIRAException, JiraCaptchaRequiredException {
        throw new JIRAException("Not implemented");
    }

    @Override
    public boolean isLoggedIn(ConnectionCfg server) {
        return false;
    }

    @Override
    public void testConnection() throws RemoteApiException {
        this.login(this.server.getUsername(), this.server.getPassword());
    }

    @Override
    public boolean isLoggedIn() {
        return this.isLoggedIn(this.server);
    }

    private <T> T wrapWithJiraException(Callable<T> c) throws JIRAException {
        try {
            return this.doCall(c);
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof UniformInterfaceException && ((UniformInterfaceException)e.getCause()).getResponse().getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                try {
                    this.authentication = this.restClient.getSessionClient().login(this.server.getUsername(), this.server.getPassword(), (ProgressMonitor)this.pm);
                    return this.doCall(c);
                }
                catch (Exception e1) {
                    throw new JIRAException(String.valueOf(this.getConnectionCfgString()) + "\n\n" + e1.getMessage(), e1);
                }
            }
            throw new JIRAException(String.valueOf(this.getConnectionCfgString()) + "\n\n" + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new JIRAException(String.valueOf(this.getConnectionCfgString()) + "\n\n" + e.getMessage(), e);
        }
    }

    private <T> T wrapWithRemoteApiException(Callable<T> c) throws RemoteApiException {
        try {
            return this.doCall(c);
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof UniformInterfaceException && ((UniformInterfaceException)e.getCause()).getResponse().getStatus() == ClientResponse.Status.UNAUTHORIZED.getStatusCode()) {
                try {
                    this.authentication = this.restClient.getSessionClient().login(this.server.getUsername(), this.server.getPassword(), (ProgressMonitor)this.pm);
                    return this.doCall(c);
                }
                catch (Exception e1) {
                    throw new RemoteApiException(String.valueOf(this.getConnectionCfgString()) + "\n\n" + e1.getMessage(), e1);
                }
            }
            throw new RemoteApiException(String.valueOf(this.getConnectionCfgString()) + "\n\n" + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RemoteApiException(String.valueOf(this.getConnectionCfgString()) + "\n\n" + e.getMessage(), e);
        }
    }

    private <T> T doCall(Callable<T> c) throws Exception {
        this.setSessionCookies();
        T res = c.call();
        this.getSessionCookies();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionCookies() {
        if (this.apacheClientConfig != null) {
            if (this.authentication == null) {
                this.authentication = this.restClient.getSessionClient().login(this.server.getUsername(), this.server.getPassword(), (ProgressMonitor)this.pm);
            }
            JiraRestSessionImpl jiraRestSessionImpl = this;
            synchronized (jiraRestSessionImpl) {
                if (this.authentication != null) {
                    Cookie cookie = new Cookie();
                    cookie.setName(this.authentication.getSession().getName());
                    cookie.setValue(this.authentication.getSession().getValue());
                    cookie.setPath("/");
                    int idx = this.server.getUrl().indexOf("//");
                    String domain = idx > 0 ? this.server.getUrl().substring(idx + 2) : this.server.getUrl();
                    cookie.setDomain(domain);
                    this.apacheClientConfig.getState().getHttpState().addCookie(cookie);
                } else {
                    this.apacheClientConfig.getState().getHttpState().clearCookies();
                }
            }
        }
    }

    private synchronized void getSessionCookies() {
        Cookie[] cookies;
        if (this.apacheClientConfig == null) {
            return;
        }
        Cookie[] cookieArray = cookies = this.apacheClientConfig.getState().getHttpState().getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (cookie.getName().toLowerCase().equals("jsessionid")) {
                this.authentication = new Authentication(null, new SessionCookie(cookie.getName(), cookie.getValue()));
            }
            ++n2;
        }
    }

    private void setupApacheClient(ApacheHttpClientConfig config) {
        this.apacheClientConfig = config;
        if (this.proxyInfo != null && this.proxyInfo.isUseHttpProxy() && this.proxyInfo.isProxyAuthentication()) {
            config.getState().setProxyCredentials(AuthScope.ANY_REALM, this.proxyInfo.getProxyHost(), this.proxyInfo.getProxyPort(), this.proxyInfo.getProxyLogin(), this.proxyInfo.getPlainProxyPassword());
        }
    }

    private String getConnectionCfgString() {
        return String.valueOf(JiraRestSessionImpl.notNullString(this.server.getUsername())) + (this.server.getPassword() != null ? ":[password " + this.server.getPassword().length() + " chars]" : "<null>") + "@" + this.server.getUrl();
    }

    private static String notNullString(String str) {
        if (str == null) {
            return "<null>";
        }
        return str;
    }
}

