/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira;

import com.atlassian.connector.commons.jira.JIRAIssue;
import com.atlassian.connector.commons.jira.JiraCustomField;
import com.atlassian.connector.commons.jira.JiraCustomFieldImpl;
import com.atlassian.connector.commons.jira.beans.JIRAComment;
import com.atlassian.connector.commons.jira.beans.JIRACommentBean;
import com.atlassian.connector.commons.jira.beans.JIRAComponentBean;
import com.atlassian.connector.commons.jira.beans.JIRAConstant;
import com.atlassian.connector.commons.jira.beans.JIRAPriorityBean;
import com.atlassian.connector.commons.jira.beans.JIRASecurityLevelBean;
import com.atlassian.connector.commons.jira.beans.JIRAVersionBean;
import com.atlassian.connector.commons.jira.soap.axis.RemoteIssue;
import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.domain.BasicComponent;
import com.atlassian.jira.rest.client.domain.BasicIssueType;
import com.atlassian.jira.rest.client.domain.BasicPriority;
import com.atlassian.jira.rest.client.domain.BasicResolution;
import com.atlassian.jira.rest.client.domain.BasicStatus;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Field;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueLink;
import com.atlassian.jira.rest.client.domain.IssueType;
import com.atlassian.jira.rest.client.domain.Priority;
import com.atlassian.jira.rest.client.domain.Status;
import com.atlassian.jira.rest.client.domain.Subtask;
import com.atlassian.jira.rest.client.domain.Version;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIRAIssueBean
implements JIRAIssue {
    private Long id;
    private String serverUrl;
    private String key;
    private String summary;
    private String status;
    private String statusUrl;
    private String type;
    private String typeUrl;
    private String priority;
    private String priorityUrl;
    private String description;
    private String wikiDescription;
    private String projectKey;
    private JIRAConstant statusConstant;
    private JIRAConstant typeConstant;
    private JIRAPriorityBean priorityConstant;
    private String assignee;
    private String assigneeId;
    private String reporter;
    private String reporterId;
    private String resolution;
    private String created;
    private String updated;
    private long statusId;
    private long priorityId;
    private long typeId;
    private List<JIRAConstant> affectsVersions;
    private List<JIRAConstant> fixVersions;
    private List<JIRAConstant> components;
    private List<String> subTaskList;
    private boolean thisIsASubTask;
    private Map<String, Map<String, List<String>>> issueLinks;
    private String parentIssueKey;
    private String originalEstimate;
    private String remainingEstimate;
    private String timeSpent;
    private List<JIRAComment> commentsList;
    private Object apiIssueObject;
    private String originalEstimateInSeconds;
    private String remainingEstimateInSeconds;
    private String timeSpentInSeconds;
    private JIRASecurityLevelBean securityLevel;
    private String environment;
    private List<JiraCustomField> basicCustomFields = new ArrayList<JiraCustomField>();
    private Locale locale;
    private static final int ONE_EFF = 31;

    public JIRAIssueBean() {
        this.locale = Locale.US;
    }

    public JIRAIssueBean(JIRAIssue issue) {
        this.locale = issue.getLocale();
        this.id = issue.getId();
        this.serverUrl = issue.getServerUrl();
        this.key = issue.getKey();
        this.summary = issue.getSummary();
        this.status = issue.getStatus();
        this.statusUrl = issue.getStatusTypeUrl();
        this.type = issue.getType();
        this.typeUrl = issue.getTypeIconUrl();
        this.priority = issue.getPriority();
        this.priorityUrl = issue.getPriorityIconUrl();
        this.description = issue.getDescription();
        this.wikiDescription = issue.getWikiDescription();
        this.projectKey = issue.getProjectKey();
        this.statusConstant = issue.getStatusConstant();
        this.typeConstant = issue.getTypeConstant();
        this.priorityConstant = issue.getPriorityConstant();
        this.assignee = issue.getAssignee();
        this.assigneeId = issue.getAssigneeId();
        this.reporter = issue.getReporter();
        this.reporterId = issue.getReporterId();
        this.resolution = issue.getResolution();
        this.created = issue.getCreated();
        this.updated = issue.getUpdated();
        this.statusId = issue.getStatusId();
        this.priorityId = issue.getPriorityId();
        this.typeId = issue.getTypeId();
        this.affectsVersions = issue.getAffectsVersions();
        this.fixVersions = issue.getFixVersions();
        this.components = issue.getComponents();
        this.subTaskList = issue.getSubTaskKeys();
        this.thisIsASubTask = issue.isSubTask();
        this.issueLinks = issue.getIssueLinks();
        this.parentIssueKey = issue.getParentIssueKey();
        this.originalEstimate = issue.getOriginalEstimate();
        this.remainingEstimate = issue.getRemainingEstimate();
        this.timeSpent = issue.getTimeSpent();
        this.commentsList = issue.getComments();
        this.apiIssueObject = issue.getApiIssueObject();
        this.originalEstimateInSeconds = issue.getOriginalEstimateInSeconds();
        this.remainingEstimateInSeconds = issue.getRemainingEstimateInSeconds();
        this.timeSpentInSeconds = issue.getTimeSpentInSeconds();
        this.securityLevel = issue.getSecurityLevel();
        this.environment = issue.getEnvironment();
        this.basicCustomFields = issue.getCustomFields();
    }

    public JIRAIssueBean(String serverUrl, Element e, Locale locale) {
        Element customfields;
        Element issueLinksElement;
        this.locale = locale;
        this.summary = this.getTextSafely(e, "summary");
        this.key = this.getTextSafely(e, "key");
        this.id = new Long(this.getAttributeSafely(e, "key", "id"));
        this.updateProjectKey();
        this.status = this.getTextSafely(e, "status");
        this.statusUrl = this.getAttributeSafely(e, "status", "iconUrl");
        try {
            this.statusId = Long.parseLong(this.getAttributeSafely(e, "status", "id"));
        }
        catch (NumberFormatException numberFormatException) {
            this.statusId = 0L;
        }
        this.priority = this.getTextSafely(e, "priority", "Unknown");
        this.priorityUrl = this.getAttributeSafely(e, "priority", "iconUrl");
        try {
            this.priorityId = Long.parseLong(this.getAttributeSafely(e, "priority", "id"));
        }
        catch (NumberFormatException numberFormatException) {
            this.priorityId = 0L;
        }
        this.description = this.getTextSafely(e, "description");
        this.environment = this.getTextSafely(e, "environment");
        this.type = this.getTextSafely(e, "type");
        this.typeUrl = this.getAttributeSafely(e, "type", "iconUrl");
        try {
            this.typeId = Long.parseLong(this.getAttributeSafely(e, "type", "id"));
        }
        catch (NumberFormatException numberFormatException) {
            this.typeId = 0L;
        }
        this.assignee = this.getTextSafely(e, "assignee");
        this.assigneeId = this.getAttributeSafely(e, "assignee", "username");
        this.reporter = this.getTextSafely(e, "reporter");
        this.reporterId = this.getAttributeSafely(e, "reporter", "username");
        this.created = this.getTextSafely(e, "created");
        this.updated = this.getTextSafely(e, "updated");
        this.resolution = this.getTextSafely(e, "resolution");
        this.parentIssueKey = this.getTextSafely(e, "parent");
        this.thisIsASubTask = this.parentIssueKey != null;
        this.subTaskList = new ArrayList<String>();
        Element subtasks = e.getChild("subtasks");
        if (subtasks != null) {
            for (Object subtask : subtasks.getChildren("subtask")) {
                String subTaskKey = ((Element)subtask).getText();
                if (subTaskKey == null) continue;
                this.subTaskList.add(subTaskKey);
            }
        }
        if ((issueLinksElement = e.getChild("issuelinks")) != null) {
            this.issueLinks = new HashMap<String, Map<String, List<String>>>();
            for (Object issueLinkTypeObj : issueLinksElement.getChildren("issuelinktype")) {
                Element issueLinkType = (Element)issueLinkTypeObj;
                String linkName = this.getTextSafely(issueLinkType, "name");
                HashMap map = new HashMap();
                String[] stringArray = new String[]{"outwardlinks", "inwardlinks"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String direction = stringArray[n2];
                    Element outwardLinks = issueLinkType.getChild(direction);
                    if (outwardLinks != null) {
                        String linkDescription = outwardLinks.getAttributeValue("description");
                        ArrayList<String> issueLinkList = new ArrayList<String>();
                        map.put(linkDescription, issueLinkList);
                        for (Object issueLinkObj : outwardLinks.getChildren("issuelink")) {
                            Element issueLink = (Element)issueLinkObj;
                            String issueKey = this.getTextSafely(issueLink, "issuekey");
                            if (issueKey == null) continue;
                            issueLinkList.add(issueKey);
                        }
                        this.issueLinks.put(linkName, map);
                    }
                    ++n2;
                }
            }
        }
        this.originalEstimate = this.getTextSafely(e, "timeoriginalestimate");
        this.remainingEstimate = this.getTextSafely(e, "timeestimate");
        this.timeSpent = this.getTextSafely(e, "timespent");
        this.originalEstimateInSeconds = this.getAttributeSafely(e, "timeoriginalestimate", "seconds");
        this.remainingEstimateInSeconds = this.getAttributeSafely(e, "timeestimate", "seconds");
        this.timeSpentInSeconds = this.getAttributeSafely(e, "timespent", "seconds");
        this.serverUrl = serverUrl;
        Element comments = e.getChild("comments");
        if (comments != null) {
            this.commentsList = new ArrayList<JIRAComment>();
            for (Object comment : comments.getChildren("comment")) {
                Element el = (Element)comment;
                String commentId = el.getAttributeValue("id", "-1");
                String author = el.getAttributeValue("author", "Unknown");
                String text = el.getText();
                String creationDate = el.getAttributeValue("created", "Unknown");
                Calendar cal = Calendar.getInstance();
                SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z (z)", locale);
                try {
                    cal.setTime(df.parse(creationDate));
                }
                catch (ParseException parseException) {
                    df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", locale);
                    try {
                        cal.setTime(df.parse(creationDate));
                    }
                    catch (ParseException parseException2) {}
                }
                this.commentsList.add(new JIRACommentBean(commentId, author, text, cal));
            }
        }
        if ((customfields = e.getChild("customfields")) != null && customfields.getChildren().size() > 0) {
            for (Object fieldElement : customfields.getChildren()) {
                this.basicCustomFields.add(new JiraCustomFieldImpl.Builder((Element)fieldElement).build());
            }
        }
    }

    public JIRAIssueBean(String url, RemoteIssue remoteIssue) {
        this.serverUrl = url;
        this.id = Long.valueOf(remoteIssue.getId());
        this.key = remoteIssue.getKey();
        this.summary = remoteIssue.getSummary();
        this.status = remoteIssue.getStatus();
        this.environment = remoteIssue.getEnvironment();
        this.type = remoteIssue.getType();
        this.priority = remoteIssue.getPriority();
        this.wikiDescription = remoteIssue.getDescription();
        this.projectKey = remoteIssue.getProject();
        this.assignee = remoteIssue.getAssignee();
        this.reporter = remoteIssue.getReporter();
        this.resolution = remoteIssue.getResolution();
    }

    public JIRAIssueBean(String url, Issue issue) {
        JSONObject editmeta;
        JSONObject timetracking;
        JSONObject rfs;
        Iterable comments;
        BasicPriority prio;
        BasicUser rep;
        BasicResolution res;
        Object parent;
        this.locale = Locale.US;
        this.apiIssueObject = issue;
        this.serverUrl = url;
        this.id = issue.getId();
        this.key = issue.getKey();
        this.projectKey = issue.getProject().getKey();
        this.thisIsASubTask = issue.getIssueType().isSubtask();
        if (this.thisIsASubTask && issue.getField("parent") != null && (parent = issue.getField("parent").getValue()) instanceof JSONObject) {
            this.parentIssueKey = JsonParseUtil.getOptionalString((JSONObject)((JSONObject)parent), (String)"key");
        }
        this.summary = issue.getSummary();
        this.description = this.getHtmlDescription(issue);
        this.wikiDescription = issue.getDescription();
        BasicIssueType issueType = issue.getIssueType();
        this.type = issueType.getName();
        Long issueTypeId = issueType.getId();
        if (issueType instanceof IssueType) {
            this.typeUrl = ((IssueType)issueType).getIconUri().toString();
        }
        this.typeId = issueTypeId != null ? issueTypeId : -1L;
        BasicStatus s = issue.getStatus();
        this.statusId = s.getId();
        this.status = s.getName();
        if (s instanceof Status) {
            this.statusUrl = ((Status)s).getIconUrl().toString();
        }
        this.resolution = (res = issue.getResolution()) != null ? res.getName() : "Unresolved";
        BasicUser ass = issue.getAssignee();
        if (ass != null) {
            this.assigneeId = ass.getName();
            this.assignee = ass.getDisplayName();
        }
        if ((rep = issue.getReporter()) != null) {
            this.reporterId = rep.getName();
            this.reporter = rep.getDisplayName();
        }
        if ((prio = issue.getPriority()) != null) {
            Long prioId = prio.getId();
            this.priorityId = prioId != null ? prioId : -1L;
            this.priority = prio.getName();
            if (prio instanceof Priority) {
                this.priorityUrl = ((Priority)prio).getIconUri().toString();
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
        this.created = df.format(issue.getCreationDate().toDate());
        this.updated = df.format(issue.getUpdateDate().toDate());
        this.subTaskList = Lists.newArrayList();
        Iterable subtasks = issue.getSubtasks();
        if (subtasks != null) {
            for (Subtask subtask : subtasks) {
                this.subTaskList.add(subtask.getIssueKey());
            }
        }
        this.components = Lists.newArrayList();
        Iterable components = issue.getComponents();
        if (components != null) {
            for (BasicComponent component : components) {
                this.components.add(new JIRAComponentBean(component.getId(), component.getName()));
            }
        }
        this.affectsVersions = Lists.newArrayList();
        Iterable aVersions = issue.getAffectedVersions();
        if (aVersions != null) {
            for (Version v : aVersions) {
                this.affectsVersions.add(new JIRAVersionBean((long)v.getId(), v.getName(), v.isReleased()));
            }
        }
        this.fixVersions = Lists.newArrayList();
        Iterable fVersions = issue.getFixVersions();
        if (fVersions != null) {
            for (Version v : fVersions) {
                this.fixVersions.add(new JIRAVersionBean((long)v.getId(), v.getName(), v.isReleased()));
            }
        }
        this.issueLinks = Maps.newHashMap();
        Iterable links = issue.getIssueLinks();
        if (links != null) {
            for (IssueLink link : links) {
                String description;
                List issueKeys;
                String linkName = link.getIssueLinkType().getName();
                HashMap map = this.issueLinks.get(linkName);
                if (map == null) {
                    map = Maps.newHashMap();
                }
                if ((issueKeys = (List)map.get(description = link.getIssueLinkType().getDescription())) == null) {
                    issueKeys = Lists.newArrayList();
                }
                issueKeys.add(link.getTargetIssueKey());
                map.put(description, issueKeys);
                this.issueLinks.put(linkName, map);
            }
        }
        if ((comments = issue.getComments()) != null) {
            this.commentsList = Lists.newArrayList();
            for (Comment comment : comments) {
                Long cmtId = comment.getId();
                BasicUser commentAuthor = comment.getAuthor();
                GregorianCalendar created = comment.getCreationDate().toGregorianCalendar();
                ((Calendar)created).setTimeZone(comment.getCreationDate().getZone().toTimeZone());
                this.commentsList.add(new JIRACommentBean(cmtId != null ? cmtId.toString() : "", commentAuthor != null ? commentAuthor.getName() : null, this.getHtmlBodyForComment(issue, comment), created));
            }
        }
        if ((rfs = JIRAIssueBean.getRenderedFields(issue.getRawObject())) != null && (timetracking = JsonParseUtil.getOptionalJsonObject((JSONObject)rfs, (String)"timetracking")) != null) {
            this.originalEstimate = JsonParseUtil.getOptionalString((JSONObject)timetracking, (String)"originalEstimate");
            this.remainingEstimate = JsonParseUtil.getOptionalString((JSONObject)timetracking, (String)"remainingEstimate");
            this.timeSpent = JsonParseUtil.getOptionalString((JSONObject)timetracking, (String)"timeSpent");
            try {
                this.originalEstimateInSeconds = ((Long)Optional.fromNullable((Object)JsonParseUtil.getOptionalLong((JSONObject)timetracking, (String)"originalEstimateSeconds")).or((Object)0L)).toString();
                this.remainingEstimateInSeconds = ((Long)Optional.fromNullable((Object)JsonParseUtil.getOptionalLong((JSONObject)timetracking, (String)"remainingEstimateSeconds")).or((Object)0L)).toString();
                this.timeSpentInSeconds = ((Long)Optional.fromNullable((Object)JsonParseUtil.getOptionalLong((JSONObject)timetracking, (String)"timeSpentSeconds")).or((Object)0L)).toString();
            }
            catch (JSONException jSONException) {}
        }
        JSONObject fields = (editmeta = JsonParseUtil.getOptionalJsonObject((JSONObject)issue.getRawObject(), (String)"editmeta")) != null ? JsonParseUtil.getOptionalJsonObject((JSONObject)editmeta, (String)"fields") : null;
        this.basicCustomFields = Lists.newArrayList();
        if (fields != null) {
            for (Field field : issue.getFields()) {
                if (!field.getId().startsWith("customfield_")) continue;
                try {
                    this.basicCustomFields.add(new JiraCustomFieldImpl.Builder((JSONObject)fields.get(field.getId()), field).build());
                }
                catch (JSONException jSONException) {}
            }
        }
    }

    private String getHtmlDescription(Issue issue) {
        JSONObject rf = JIRAIssueBean.getRenderedFields(issue.getRawObject());
        if (rf == null) {
            return issue.getDescription();
        }
        String result = JsonParseUtil.getOptionalString((JSONObject)rf, (String)"description");
        return result != null ? result : issue.getDescription();
    }

    private String getHtmlBodyForComment(Issue issue, Comment comment) {
        JSONObject rf = JIRAIssueBean.getRenderedFields(issue.getRawObject());
        if (rf == null) {
            return comment.getBody();
        }
        try {
            JSONArray array = rf.getJSONObject("comment").getJSONArray("comments");
            int i = 0;
            while (i < array.length()) {
                JSONObject element = (JSONObject)array.get(i);
                if (Objects.equal((Object)element.getLong("id"), (Object)comment.getId())) {
                    return element.getString("body");
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return comment.getBody();
    }

    private static JSONObject getRenderedFields(JSONObject issue) {
        if (issue == null) {
            return null;
        }
        return JsonParseUtil.getOptionalJsonObject((JSONObject)issue, (String)IssueRestClient.Expandos.RENDERED_FIELDS.getFieldName());
    }

    @Override
    public JIRAPriorityBean getPriorityConstant() {
        return this.priorityConstant;
    }

    public void setPriority(JIRAPriorityBean priority) {
        this.priority = priority.getName();
        this.priorityConstant = priority;
    }

    public JIRAIssueBean(Map params) {
        this.summary = (String)params.get("summary");
        this.status = (String)params.get("status");
        this.key = (String)params.get("key");
        this.id = new Long(params.get("key").toString());
        this.updateProjectKey();
        this.description = (String)params.get("description");
        this.type = (String)params.get("type");
        this.priority = (String)params.get("priority");
    }

    private void updateProjectKey() {
        if (this.key != null) {
            this.projectKey = this.key.contains("-") ? this.key.substring(0, this.key.indexOf("-")) : this.key;
        }
    }

    private String getTextSafely(Element e, String name, String defaultName) {
        String text = this.getTextSafely(e, name);
        return text != null ? text : defaultName;
    }

    private String getTextSafely(Element e, String name) {
        Element child = e.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    private String getAttributeSafely(Element e, String elementName, String attributeName) {
        Element child = e.getChild(elementName);
        if (child == null || child.getAttribute(attributeName) == null) {
            return null;
        }
        return child.getAttributeValue(attributeName);
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public String getProjectUrl() {
        return String.valueOf(this.getServerUrl()) + "/browse/" + this.getProjectKey();
    }

    @Override
    public String getIssueUrl() {
        return String.valueOf(this.getServerUrl()) + "/browse/" + this.getKey();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public boolean isSubTask() {
        return this.thisIsASubTask;
    }

    @Override
    public Map<String, Map<String, List<String>>> getIssueLinks() {
        return this.issueLinks;
    }

    @Override
    public String getParentIssueKey() {
        return this.parentIssueKey;
    }

    @Override
    public List<String> getSubTaskKeys() {
        return this.subTaskList;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getStatusTypeUrl() {
        return this.statusUrl;
    }

    @Override
    public String getPriority() {
        return this.priority;
    }

    @Override
    public String getPriorityIconUrl() {
        return this.priorityUrl;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypeIconUrl() {
        return this.typeUrl;
    }

    public void setTypeIconUrl(String newTypeUrl) {
        this.typeUrl = newTypeUrl;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getWikiDescription() {
        return this.wikiDescription;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public JIRAConstant getTypeConstant() {
        return this.typeConstant;
    }

    public void setType(JIRAConstant type) {
        this.type = type.getName();
        this.typeConstant = type;
    }

    @Override
    public JIRAConstant getStatusConstant() {
        return this.statusConstant;
    }

    public void setStatus(JIRAConstant status) {
        this.status = status.getName();
        this.statusConstant = status;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @Override
    public long getPriorityId() {
        return this.priorityId;
    }

    @Override
    public long getStatusId() {
        return this.statusId;
    }

    @Override
    public long getTypeId() {
        return this.typeId;
    }

    @Override
    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    @Override
    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    @Override
    public String getUpdated() {
        return this.updated;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JIRAIssueBean that = (JIRAIssueBean)o;
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }

    @Override
    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
    }

    @Override
    public String getReporterId() {
        return this.reporterId;
    }

    public void setReporterId(String reporterId) {
        this.reporterId = reporterId;
    }

    @Override
    public List<JIRAConstant> getAffectsVersions() {
        return this.affectsVersions;
    }

    @Override
    public void setAffectsVersions(List<JIRAConstant> affectsVersions) {
        this.affectsVersions = affectsVersions;
    }

    @Override
    public List<JIRAConstant> getFixVersions() {
        return this.fixVersions;
    }

    @Override
    public void setFixVersions(List<JIRAConstant> fixVersions) {
        this.fixVersions = fixVersions;
    }

    @Override
    public List<JIRAConstant> getComponents() {
        return this.components;
    }

    @Override
    public void setComponents(List<JIRAConstant> components) {
        this.components = components;
    }

    @Override
    public String getOriginalEstimate() {
        return this.originalEstimate;
    }

    @Override
    public void setOriginalEstimate(String originalEstimate) {
        this.originalEstimate = originalEstimate;
    }

    @Override
    public String getOriginalEstimateInSeconds() {
        return this.originalEstimateInSeconds;
    }

    @Override
    public String getRemainingEstimate() {
        return this.remainingEstimate;
    }

    @Override
    public String getRemainingEstimateInSeconds() {
        return this.remainingEstimateInSeconds;
    }

    @Override
    public void setRemainingEstimate(String remainingEstimate) {
        this.remainingEstimate = remainingEstimate;
    }

    @Override
    public String getTimeSpent() {
        return this.timeSpent;
    }

    @Override
    public String getTimeSpentInSeconds() {
        return this.timeSpentInSeconds;
    }

    @Override
    public void setTimeSpent(String timeSpent) {
        this.timeSpent = timeSpent;
    }

    @Override
    public List<JIRAComment> getComments() {
        return this.commentsList;
    }

    @Override
    public Object getApiIssueObject() {
        return this.apiIssueObject;
    }

    @Override
    public void setApiIssueObject(Object o) {
        this.apiIssueObject = o;
    }

    @Override
    public JIRASecurityLevelBean getSecurityLevel() {
        return this.securityLevel;
    }

    @Override
    public List<JiraCustomField> getCustomFields() {
        return this.basicCustomFields;
    }

    public void setSecurityLevel(JIRASecurityLevelBean securityLevelBean) {
        this.securityLevel = securityLevelBean;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean usesRest() {
        return this.apiIssueObject instanceof Issue;
    }

    public void setWikiDescription(String wikiDescription) {
        this.wikiDescription = wikiDescription;
    }
}

