/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalBranchTagCompareInput;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.dialogs.ShowDifferencesAsUnifiedDiffDialogWC;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardCompareMultipleResourcesWithBranchTagPage;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class ShowDifferencesAsUnifiedDiffActionWC
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IResource[] resources = this.getSelectedResources();
        boolean refreshFile = false;
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFile && !resources[i].isSynchronized(4)) {
                if (!refreshFile && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("DifferencesDialog.compare"), (String)Policy.bind("CompareWithRemoteAction.fileChanged"))) break;
                refreshFile = true;
                try {
                    resources[i].refreshLocal(4, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            ++i;
        }
        if (resources.length > 1) {
            SvnWizardCompareMultipleResourcesWithBranchTagPage comparePage = new SvnWizardCompareMultipleResourcesWithBranchTagPage(resources);
            SvnWizard wizard = new SvnWizard(comparePage);
            SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                ISVNLocalResource[] localResources = new ISVNLocalResource[resources.length];
                int i2 = 0;
                while (i2 < resources.length) {
                    localResources[i2] = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i2]);
                    ++i2;
                }
                try {
                    SVNLocalBranchTagCompareInput compareInput = new SVNLocalBranchTagCompareInput(localResources, comparePage.getUrls(), comparePage.getRevision(), this.getTargetPart());
                    CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)this.getTargetPage());
                }
                catch (SVNException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ShowDifferencesAsUnifiedDiffDialog.branchTag"), (String)e.getMessage());
                }
            }
            return;
        }
        ShowDifferencesAsUnifiedDiffDialogWC dialog = new ShowDifferencesAsUnifiedDiffDialogWC(this.getShell(), resources[0], this.getTargetPart());
        if (dialog.open() == 0) {
            try {
                if (dialog.isDiffToOutputFile()) {
                    dialog.getOperation().run();
                }
                if (!dialog.isDiffToOutputFile()) {
                    SVNRevision pegRevision = dialog.getPegRevision();
                    if (pegRevision == null) {
                        pegRevision = SVNRevision.HEAD;
                    }
                    if (resources[0] instanceof IContainer) {
                        RemoteFolder remoteFolder = new RemoteFolder(dialog.getSvnResource().getRepository(), dialog.getToUrl(), dialog.getToRevision());
                        remoteFolder.setPegRevision(pegRevision);
                        SVNLocalCompareInput compareInput = new SVNLocalCompareInput(dialog.getSvnResource(), (ISVNRemoteResource)remoteFolder, pegRevision);
                        compareInput.setDiffOperation(dialog.getOperation());
                        CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)this.getTargetPage());
                    } else {
                        RemoteFile remoteFile = new RemoteFile(dialog.getSvnResource().getRepository(), dialog.getToUrl(), dialog.getToRevision());
                        remoteFile.setPegRevision(pegRevision);
                        SVNLocalCompareInput compareInput = new SVNLocalCompareInput(dialog.getSvnResource(), (ISVNRemoteResource)remoteFile, pegRevision);
                        CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)this.getTargetPage());
                    }
                }
            }
            catch (SVNException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ShowDifferencesAsUnifiedDiffDialog.branchTag"), (String)e.getMessage());
            }
        }
    }

    protected boolean isEnabled() throws TeamException {
        return true;
    }

    protected String getImageId() {
        return "Menu Compare";
    }
}

