/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.type.asm;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.asm.ClassReader;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;
import org.springframework.util.ClassUtils;

public class SimpleClassReaderFactory
implements ClassReaderFactory {
    private final ResourceLoader resourceLoader;

    public SimpleClassReaderFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public SimpleClassReaderFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public SimpleClassReaderFactory(ClassLoader classLoader) {
        this.resourceLoader = classLoader != null ? new DefaultResourceLoader(classLoader) : new DefaultResourceLoader();
    }

    public ClassReader getClassReader(String className) throws IOException {
        String resourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath((String)className) + ".class";
        return this.getClassReader(this.resourceLoader.getResource(resourcePath));
    }

    public ClassReader getClassReader(Resource resource) throws IOException {
        InputStream is = resource.getInputStream();
        try {
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
        finally {
            is.close();
        }
    }
}

