/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.type.asm;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.ClassReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ide.eclipse.core.type.asm.SimpleClassReaderFactory;

public class CachingClassReaderFactory
extends SimpleClassReaderFactory {
    private final Map<Resource, ClassReader> classReaderCache = new HashMap<Resource, ClassReader>();

    public CachingClassReaderFactory() {
    }

    public CachingClassReaderFactory(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public CachingClassReaderFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassReader getClassReader(Resource resource) throws IOException {
        Map<Resource, ClassReader> map = this.classReaderCache;
        synchronized (map) {
            ClassReader classReader = this.classReaderCache.get(resource);
            if (classReader == null) {
                classReader = super.getClassReader(resource);
                this.classReaderCache.put(resource, classReader);
            }
            return classReader;
        }
    }
}

