/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model.java;

import java.io.Serializable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.core.io.FileResource;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.util.ObjectUtils;

public class JavaModelSourceLocation
implements Serializable,
IModelSourceLocation {
    private static final long serialVersionUID = -1689438887512112705L;
    private String handleIdentifier;
    private int lineNumber;

    public JavaModelSourceLocation(IJavaElement type) throws JavaModelException {
        this.handleIdentifier = type.getHandleIdentifier();
        this.lineNumber = JdtUtils.getLineNumber(JdtUtils.getByHandle(this.handleIdentifier));
    }

    public int getEndLine() {
        return this.lineNumber;
    }

    public int getStartLine() {
        return this.getEndLine();
    }

    public Resource getResource() {
        try {
            IJavaElement element = JdtUtils.getByHandle(this.handleIdentifier);
            if (element != null) {
                IResource resource = element.getUnderlyingResource();
                if (resource != null) {
                    return new FileResource(resource.getFullPath().toString());
                }
                resource = element.getCorrespondingResource();
                if (resource != null) {
                    return new FileResource(resource.getFullPath().toString());
                }
                resource = element.getResource();
                if (resource != null) {
                    return new FileResource(resource.getFullPath().toString());
                }
                IPath path = element.getPath();
                if (path != null && path.toFile().exists()) {
                    if (path.isAbsolute()) {
                        return new FileSystemResource(path.toFile());
                    }
                    return new FileResource(path.toString());
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaModelSourceLocation)) {
            return false;
        }
        JavaModelSourceLocation that = (JavaModelSourceLocation)other;
        return ObjectUtils.nullSafeEquals((Object)this.handleIdentifier, (Object)that.handleIdentifier);
    }

    public int hashCode() {
        return this.handleIdentifier.hashCode();
    }

    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }
}

