/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.util.ObjectUtils;

public abstract class AbstractModelElement
implements IModelElement {
    private IModelElement parent;
    private String name;

    protected AbstractModelElement(IModelElement parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IModelElement getElementParent() {
        return this.parent;
    }

    public void setElementParent(IModelElement parent) {
        this.parent = parent;
    }

    public IModelElement[] getElementChildren() {
        return NO_CHILDREN;
    }

    public String getElementName() {
        return this.name;
    }

    public void setElementName(String name) {
        this.name = name;
    }

    public final String getElementID() {
        StringBuffer id = new StringBuffer();
        if (this.getElementParent() != null) {
            id.append(this.getElementParent().getElementID());
            id.append('|');
        }
        id.append(this.getElementType());
        id.append(':');
        if (this.getElementName() != null) {
            id.append(this.getUniqueElementName());
        } else {
            id.append(super.hashCode());
        }
        return id.toString();
    }

    protected String getUniqueElementName() {
        return this.getElementName();
    }

    public IModelElement getElement(String id) {
        int sepPos = id.indexOf(58);
        if (sepPos > 0) {
            try {
                int type = Integer.valueOf(id.substring(0, sepPos));
                if (type == this.getElementType()) {
                    int delPos = id.indexOf(124);
                    if (delPos > 0) {
                        String name = id.substring(sepPos + 1, delPos);
                        if (name.equals(this.getUniqueElementName())) {
                            id = id.substring(delPos + 1);
                            IModelElement[] iModelElementArray = this.getElementChildren();
                            int n = iModelElementArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IModelElement element;
                                IModelElement child = iModelElementArray[n2];
                                if (child instanceof AbstractModelElement && (element = ((AbstractModelElement)child).getElement(id)) != null) {
                                    return element;
                                }
                                ++n2;
                            }
                        }
                    } else {
                        String name = id.substring(sepPos + 1);
                        if (name.equals(this.getUniqueElementName())) {
                            return this;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            visitor.visit(this, monitor);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractModelElement)) {
            return false;
        }
        AbstractModelElement that = (AbstractModelElement)other;
        return ObjectUtils.nullSafeEquals((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.name);
    }
}

