/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.core.Ordered;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinition;
import org.springframework.ide.eclipse.core.internal.project.SpringProjectContributionManager;
import org.springframework.ide.eclipse.core.java.TypeStructureState;
import org.springframework.ide.eclipse.core.project.IProjectContributor;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinition;
import org.springframework.ide.eclipse.core.project.ProjectContributionEventListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeStructureStateRegisteringEventListener
extends ProjectContributionEventListenerAdapter
implements Ordered {
    @Override
    public void start(int kind, IResourceDelta delta, List<ProjectBuilderDefinition> builderDefinitions, List<ValidatorDefinition> validatorDefinitions, IProjectContributorState state, IProject project) {
        state.hold(new TypeStructureState());
    }

    @Override
    public void finish(int kind, IResourceDelta delta, List<ProjectBuilderDefinition> builderDefinitions, List<ValidatorDefinition> validatorDefinitions, IProjectContributorState state, IProject project) {
        try {
            this.updateTypeStructures(kind, project, delta);
        }
        catch (CoreException coreException) {}
    }

    private void updateTypeStructures(int kind, IProject project, IResourceDelta delta) throws CoreException {
        if (delta == null || kind == 6 || kind == 15) {
            this.recoredFullTypeStructures(project);
        } else if (!SpringCore.getTypeStructureCache().hasRecordedTypeStructures(project)) {
            this.recoredFullTypeStructures(project);
        } else {
            JavaResourceRecordingProjectContributor contributor = new JavaResourceRecordingProjectContributor();
            SpringProjectContributionManager.ResourceDeltaVisitor visitor = new SpringProjectContributionManager.ResourceDeltaVisitor(contributor, kind);
            delta.accept((IResourceDeltaVisitor)visitor);
            SpringCore.getTypeStructureCache().recordTypeStructures(project, visitor.getResources().toArray(new IResource[visitor.getResources().size()]));
        }
    }

    private void recoredFullTypeStructures(IProject project) throws CoreException {
        SpringCore.getTypeStructureCache().clearStateForProject(project);
        JavaResourceRecordingProjectContributor contributor = new JavaResourceRecordingProjectContributor();
        SpringProjectContributionManager.ResourceTreeVisitor visitor = new SpringProjectContributionManager.ResourceTreeVisitor(contributor);
        project.accept((IResourceVisitor)visitor);
        SpringCore.getTypeStructureCache().recordTypeStructures(project, visitor.getResources().toArray(new IResource[visitor.getResources().size()]));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaResourceRecordingProjectContributor
    implements IProjectContributor {
        private JavaResourceRecordingProjectContributor() {
        }

        @Override
        public void cleanup(IResource resource, IProgressMonitor monitor) throws CoreException {
        }

        @Override
        public Set<IResource> getAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
            if (resource.getName().endsWith(".class") && JavaCore.create((IResource)resource) != null) {
                HashSet<IResource> resources = new HashSet<IResource>();
                resources.add(resource);
                return resources;
            }
            return Collections.emptySet();
        }
    }
}

