/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLWriter
extends PrintWriter {
    private static final String CDATA_PREFIX = "<![CDATA[";
    private static final String CDATA_SUFFIX = "]]>";
    public static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    protected int tab = 0;

    public XMLWriter(OutputStream output) throws UnsupportedEncodingException {
        super(new OutputStreamWriter(output, "UTF8"));
        this.println(XML_VERSION);
    }

    public void endTag(String name) {
        --this.tab;
        this.printTag(String.valueOf('/') + name, null);
    }

    public void printSimpleTag(String name, Object value) {
        if (value != null) {
            this.printTag(name, null, true, false);
            this.print(XMLWriter.getEscaped(String.valueOf(value)));
            this.printTag(String.valueOf('/') + name, null, false, true);
        }
    }

    public void printCDataTag(String name, Object value) {
        if (value != null) {
            this.printTag(name, null, true, false);
            this.print(CDATA_PREFIX + String.valueOf(value) + CDATA_SUFFIX);
            this.printTag(String.valueOf('/') + name, null, false, true);
        }
    }

    public void printTabulation() {
        int i = 0;
        while (i < this.tab) {
            super.print('\t');
            ++i;
        }
    }

    public void printTag(String name, HashMap<String, ?> parameters) {
        this.printTag(name, parameters, true, true);
    }

    public void printTag(String name, HashMap<String, ?> parameters, boolean tab, boolean newLine) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(name);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                buffer.append(" ");
                buffer.append(key);
                buffer.append("=\"");
                buffer.append(XMLWriter.getEscaped(String.valueOf(parameters.get(key))));
                buffer.append("\"");
            }
        }
        buffer.append(">");
        if (tab) {
            this.printTabulation();
        }
        if (newLine) {
            this.println(buffer.toString());
        } else {
            this.print(buffer.toString());
        }
    }

    public void startTag(String name, HashMap<String, ?> parameters) {
        this.startTag(name, parameters, true);
    }

    public void startTag(String name, HashMap<String, ?> parameters, boolean newLine) {
        this.printTag(name, parameters, true, newLine);
        ++this.tab;
    }

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = XMLWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    public static String getEscaped(String text) {
        StringBuffer result = new StringBuffer(text.length() + 10);
        int i = 0;
        while (i < text.length()) {
            XMLWriter.appendEscapedChar(result, text.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

