/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.core.io.EclipsePathMatchingResourcePatternResolver;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class StorageResource
extends AbstractResource
implements IAdaptable {
    private IProject project;
    private ZipEntryStorage storage;

    public StorageResource(ZipEntryStorage storage, IProject project) {
        this.storage = storage;
    }

    public boolean exists() {
        return this.storage != null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.storage == null) {
            throw new FileNotFoundException("Storage not available");
        }
        try {
            return this.storage.getContents();
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getDescription() {
        return "storage [" + (this.storage != null ? this.storage.getName() : "") + "]";
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IStorage.class)) {
            return this.storage;
        }
        if (adapter.equals(ZipEntryStorage.class)) {
            return this.storage;
        }
        return this.storage.getAdapter(adapter);
    }

    public String getFilename() throws IllegalStateException {
        return this.storage.getFile().getProjectRelativePath() + "!" + this.storage.getEntryName();
    }

    public Resource createRelative(String relativePath) {
        String pathToUse = StringUtils.applyRelativePath((String)this.storage.getEntryName(), (String)relativePath);
        return new EclipsePathMatchingResourcePatternResolver(this.project).getResource(pathToUse);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StorageResource)) {
            return false;
        }
        StorageResource that = (StorageResource)((Object)other);
        return ObjectUtils.nullSafeEquals((Object)this.storage, (Object)that.storage);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.storage);
    }

    public IStorage getRawStorage() {
        return this.storage;
    }
}

