/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

abstract class InputStreamUtils {
    InputStreamUtils() {
    }

    public static InputStream getWrappedInputStream(ZipFile file, ZipEntry entry) throws IOException {
        return new ZipFileClosingZipEntryInputStream(file, entry);
    }

    static class ZipFileClosingZipEntryInputStream
    extends InputStream {
        private final InputStream is;
        private final ZipFile file;

        public ZipFileClosingZipEntryInputStream(ZipFile file, ZipEntry entry) throws IOException {
            this.is = file.getInputStream(entry);
            this.file = file;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
            this.file.close();
        }

        protected void finalize() throws IOException {
            this.close();
        }
    }
}

