/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.project.uaa;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinition;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinition;
import org.springframework.ide.eclipse.core.project.ProjectContributionEventListenerAdapter;
import org.springframework.ide.eclipse.uaa.IUaa;
import org.springframework.ide.eclipse.uaa.UaaPlugin;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectContributionUsageMonitor
extends ProjectContributionEventListenerAdapter {
    private static final boolean UAA_AVAILABLE = ClassUtils.isPresent((String)"org.springframework.ide.eclipse.uaa.UaaPlugin", (ClassLoader)ProjectContributionEventListenerAdapter.class.getClassLoader());

    @Override
    public void finishProjectBuilder(ProjectBuilderDefinition contributor, Set<IResource> affectedResources, IProgressMonitor monitor) {
        if (UAA_AVAILABLE) {
            UaaDependentProjectContributionUsageMonitor.finishProjectBuilder(contributor, affectedResources, monitor);
        }
    }

    @Override
    public void finishValidator(ValidatorDefinition contributor, Set<IResource> affectedResources, IProgressMonitor monitor) {
        if (UAA_AVAILABLE) {
            UaaDependentProjectContributionUsageMonitor.finishValidator(contributor, affectedResources, monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UaaDependentProjectContributionUsageMonitor {
        private static IUaa manager;

        private UaaDependentProjectContributionUsageMonitor() {
        }

        public static void finishProjectBuilder(ProjectBuilderDefinition contributor, Set<IResource> affectedResources, IProgressMonitor monitor) {
            if (affectedResources != null && affectedResources.size() > 0) {
                UaaDependentProjectContributionUsageMonitor.getUaa().registerFeatureUse(contributor.getNamespaceUri(), Collections.singletonMap("name", contributor.getName()));
            }
        }

        public static void finishValidator(ValidatorDefinition contributor, Set<IResource> affectedResources, IProgressMonitor monitor) {
            if (affectedResources != null && affectedResources.size() > 0) {
                UaaDependentProjectContributionUsageMonitor.getUaa().registerFeatureUse(contributor.getNamespaceUri(), Collections.singletonMap("name", contributor.getName()));
            }
        }

        private static synchronized IUaa getUaa() {
            if (manager == null) {
                manager = UaaPlugin.getUAA();
            }
            return manager;
        }
    }
}

