/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model.validation;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.validation.SpringValidationContext;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidator;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationElementLifecycleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringValidator
extends AbstractValidator {
    @Override
    protected IValidationContext createContext(IResourceModelElement rootElement, IResourceModelElement contextElement) {
        return new SpringValidationContext(rootElement, contextElement);
    }

    @Override
    protected IValidationElementLifecycleManager createValidationElementLifecycleManager() {
        return new SpringValidationElementLifecycleManager();
    }

    @Override
    protected boolean supports(IModelElement element) {
        return element instanceof ISpringProject;
    }

    @Override
    public Set<IResource> deriveResources(Object object) {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        if (object instanceof IResource) {
            resources.add((IResource)((IResource)object).getProject());
        } else if (object instanceof ISpringProject) {
            resources.add((IResource)((ISpringProject)object).getProject());
        }
        return resources;
    }

    @Override
    public Set<IResource> getAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        resources.add((IResource)resource.getProject());
        return resources;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpringValidationElementLifecycleManager
    implements IValidationElementLifecycleManager {
        private IResourceModelElement rootElement;

        private SpringValidationElementLifecycleManager() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public Set<IResourceModelElement> getContextElements() {
            LinkedHashSet<IResourceModelElement> resources = new LinkedHashSet<IResourceModelElement>();
            resources.add(this.getRootElement());
            return resources;
        }

        @Override
        public IResourceModelElement getRootElement() {
            return this.rootElement;
        }

        @Override
        public void init(IResource resource) {
            this.rootElement = SpringCore.getModel().getProject(resource.getProject());
        }
    }
}

