/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.navigator.actions;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.progress.IProgressConstants;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinition;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinitionFactory;
import org.springframework.ide.eclipse.core.model.validation.IValidator;
import org.springframework.ide.eclipse.ui.SpringUIImages;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationAction
extends AbstractNavigatorAction {
    private Map<ValidatorDefinition, Set<IResource>> validatorResources;

    public ValidationAction(ICommonActionExtensionSite site) {
        super(site);
        this.setText("Validate");
        this.setToolTipText("Validate the selected model element");
    }

    @Override
    public final boolean isEnabled(IStructuredSelection selection) {
        this.validatorResources = new LinkedHashMap<ValidatorDefinition, Set<IResource>>();
        if (selection.size() > 0) {
            for (ValidatorDefinition validatorDefinition : ValidatorDefinitionFactory.getValidatorDefinitions()) {
                IValidator validator = validatorDefinition.getValidator();
                for (Object object : selection.toList()) {
                    Set resources = validator.deriveResources(object);
                    if (resources == null || resources.size() <= 0) continue;
                    Set<IResource> valResources = this.validatorResources.get(validatorDefinition);
                    if (valResources == null) {
                        valResources = new LinkedHashSet<IResource>();
                        this.validatorResources.put(validatorDefinition, valResources);
                    }
                    valResources.addAll(resources);
                }
            }
        }
        return this.validatorResources.size() > 0;
    }

    public final void run() {
        Job job = new Job("Validating"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Validating selected model elements", ValidationAction.this.validatorResources.size());
                for (ValidatorDefinition validatorDefinition : ValidationAction.this.validatorResources.keySet()) {
                    ValidationAction.this.runValidator(validatorDefinition, (Set)ValidationAction.this.validatorResources.get(validatorDefinition), monitor);
                    monitor.worked(1);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(40);
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)SpringUIImages.DESC_OBJS_SPRING);
        job.schedule();
    }

    private void runValidator(final ValidatorDefinition validatorDefinition, final Set<IResource> resources, final IProgressMonitor monitor) {
        ISafeRunnable code = new ISafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                IValidator validator = validatorDefinition.getValidator();
                LinkedHashSet affectedResources = new LinkedHashSet();
                for (IResource resource : resources) {
                    affectedResources.addAll(validator.getAffectedResources(resource, 10, 4));
                }
                validator.validate(affectedResources, 10, monitor);
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }
}

