/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinition;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinitionFactory;
import org.springframework.ide.eclipse.ui.SpringUIImages;
import org.springframework.ide.eclipse.ui.SpringUIMessages;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuilderPropertyTab {
    private List<ProjectBuilderDefinition> projectBuilderDefinitions = ProjectBuilderDefinitionFactory.getProjectBuilderDefinitions();
    private CheckboxTableViewer builderViewer;
    private Text descriptionText;
    private IProject project;

    public ProjectBuilderPropertyTab(IProject project) {
        this.project = project;
    }

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.project != null) {
            Label beansLabel = new Label(composite, 0);
            beansLabel.setText(SpringUIMessages.ProjectBuilderPropertyPage_description);
        }
        this.builderViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.builderViewer.getTable().setLayoutData((Object)gd);
        this.builderViewer.setContentProvider((IContentProvider)new ProjectBuilderDefinitionContentProvider(this.projectBuilderDefinitions));
        this.builderViewer.setLabelProvider((IBaseLabelProvider)new ProjectBuilderLabelProvider());
        this.builderViewer.setInput((Object)this);
        this.builderViewer.setCheckedElements(this.getEnabledProjectBuilderDefinitions().toArray());
        this.builderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ProjectBuilderDefinition definition = (ProjectBuilderDefinition)sel.getFirstElement();
                    if (definition == null) {
                        ProjectBuilderPropertyTab.this.clearDescription();
                    } else {
                        ProjectBuilderPropertyTab.this.showDescription(definition);
                    }
                }
            }
        });
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(SpringUIMessages.ProjectBuilderPropertyPage_builderDescription);
        this.descriptionText = new Text(composite, 2378);
        GridData data = new GridData(1808);
        data.heightHint = 30;
        this.descriptionText.setLayoutData((Object)data);
        return composite;
    }

    private List<ProjectBuilderDefinition> getEnabledProjectBuilderDefinitions() {
        List<ProjectBuilderDefinition> builderDefinitions = this.projectBuilderDefinitions;
        ArrayList<ProjectBuilderDefinition> filteredBuilderDefinitions = new ArrayList<ProjectBuilderDefinition>();
        for (ProjectBuilderDefinition builderDefinition : builderDefinitions) {
            if (!builderDefinition.isEnabled(this.project)) continue;
            filteredBuilderDefinitions.add(builderDefinition);
        }
        return filteredBuilderDefinitions;
    }

    private void showDescription(ProjectBuilderDefinition definition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String text = definition.getDescription();
        if (text == null || text.length() == 0) {
            this.descriptionText.setText(SpringUIMessages.ProjectBuilderPropertyPage_noBuilderDescription);
        } else {
            this.descriptionText.setText(text);
        }
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    public boolean performOk() {
        final List<Object> checkElements = Arrays.asList(this.builderViewer.getCheckedElements());
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                for (ProjectBuilderDefinition projectBuilderDefinition : ProjectBuilderPropertyTab.this.projectBuilderDefinitions) {
                    if (checkElements.contains(projectBuilderDefinition)) {
                        projectBuilderDefinition.setEnabled(true, ProjectBuilderPropertyTab.this.project);
                        continue;
                    }
                    projectBuilderDefinition.setEnabled(false, ProjectBuilderPropertyTab.this.project);
                }
            }
        };
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectBuilderDefinitionContentProvider
    implements IStructuredContentProvider {
        private List<ProjectBuilderDefinition> projectBuilderDefinitions;

        public ProjectBuilderDefinitionContentProvider(List<ProjectBuilderDefinition> projectBuilderDefinitions) {
            this.projectBuilderDefinitions = projectBuilderDefinitions;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.projectBuilderDefinitions.toArray();
        }
    }

    private static class ProjectBuilderLabelProvider
    extends LabelProvider {
        private ProjectBuilderLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ProjectBuilderDefinition) {
                return ((ProjectBuilderDefinition)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof ProjectBuilderDefinition) {
                String icon = ((ProjectBuilderDefinition)element).getIconUri();
                String ns = ((ProjectBuilderDefinition)element).getNamespaceUri();
                if (icon != null && ns != null && (image = SpringUIPlugin.getDefault().getImageRegistry().get(icon)) == null) {
                    ImageDescriptor imageDescriptor = SpringUIPlugin.imageDescriptorFromPlugin((String)ns, (String)icon);
                    SpringUIPlugin.getDefault().getImageRegistry().put(icon, imageDescriptor);
                    image = SpringUIPlugin.getDefault().getImageRegistry().get(icon);
                }
            }
            if (image == null) {
                return SpringUIImages.getImage("org.springframework.ide.eclipse.ui.rule_obj.gif");
            }
            return image;
        }
    }
}

