/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.wizards;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGMethodWizardPage
extends WizardPage {
    private List<IMethod> m_elements = Lists.newArrayList();
    private Table m_table;

    protected TestNGMethodWizardPage(List<Utils.JavaElement> elements) {
        super(ResourceUtil.getString("NewTestNGClassWizardPage.title"));
        this.setTitle(ResourceUtil.getString("NewTestNGClassWizardPage.title"));
        this.setDescription(ResourceUtil.getString("TestNGMethodWizardPage.description"));
        for (Utils.JavaElement je : elements) {
            if (je.compilationUnit == null) continue;
            try {
                IType[] iTypeArray = je.compilationUnit.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    IMethod[] iMethodArray = type.getMethods();
                    int n3 = iMethodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod method = iMethodArray[n4];
                        this.m_elements.add(method);
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        Collections.sort(this.m_elements, new Comparator<IMethod>(){

            @Override
            public int compare(IMethod o1, IMethod o2) {
                return o1.getElementName().compareTo(o2.getElementName());
            }
        });
    }

    private String toSignature(IMethod method) {
        StringBuilder result = new StringBuilder(method.getElementName());
        String[] types = method.getParameterTypes();
        try {
            String[] names = method.getParameterNames();
            result.append("(");
            int i = 0;
            while (i < types.length) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(String.valueOf(Signature.toString((String)types[i])) + " " + names[i]);
                ++i;
            }
            result.append(")");
        }
        catch (JavaModelException javaModelException) {}
        return result.toString();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.m_table = new Table(container, 2848);
        for (IMethod element : this.m_elements) {
            TableItem item = new TableItem(this.m_table, 0);
            item.setText(this.toSignature(element));
            item.setData((Object)element);
        }
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        this.m_table.setLayoutData((Object)gd);
        Composite cb = new Composite(container, 0);
        GridLayout layout2 = new GridLayout();
        cb.setLayout((Layout)layout2);
        Button selectAll = new Button(cb, 0);
        selectAll.setText("Select all");
        selectAll.setLayoutData((Object)new GridData(4, 128, true, true));
        selectAll.addSelectionListener((SelectionListener)new Listener(true));
        Button deselectAll = new Button(cb, 0);
        deselectAll.setText("Deselect all");
        deselectAll.setLayoutData((Object)new GridData(4, 128, true, true));
        deselectAll.addSelectionListener((SelectionListener)new Listener(false));
        this.setControl((Control)container);
    }

    private void selectAll(boolean select) {
        TableItem[] tableItemArray = this.m_table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            ti.setChecked(select);
            ++n2;
        }
    }

    public List<IMethod> getSelectedMethods() {
        ArrayList result = Lists.newArrayList();
        TableItem[] tableItemArray = this.m_table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getChecked()) {
                result.add((IMethod)ti.getData());
            }
            ++n2;
        }
        return result;
    }

    class Listener
    implements SelectionListener {
        private boolean m_select;

        public Listener(boolean select) {
            this.m_select = select;
        }

        public void widgetSelected(SelectionEvent e) {
            TestNGMethodWizardPage.this.selectAll(this.m_select);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

