/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util.signature;

import java.util.List;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.testng.eclipse.util.signature.IMethodDescriptor;
import org.testng.eclipse.util.signature.TypeSignature;

public class ASTMethodDescriptor
implements IMethodDescriptor {
    private MethodDeclaration m_method;
    private String m_annotationType;

    public ASTMethodDescriptor(MethodDeclaration methodDeclaration, String annotationType) {
        this.m_method = methodDeclaration;
        this.m_annotationType = annotationType;
    }

    public String getName() {
        return this.m_method.getName().toString();
    }

    public String getReturnTypeSignature() {
        Type returnType = this.m_method.getReturnType2();
        if (returnType == null && this.m_method.getAST().apiLevel() < 3) {
            returnType = this.m_method.getReturnType();
        }
        return TypeSignature.getSignature(returnType);
    }

    public String getSignature() {
        StringBuffer buf = new StringBuffer("(");
        List paramVars = this.m_method.parameters();
        int i = 0;
        while (i < paramVars.size()) {
            buf.append(TypeSignature.getSignature(((SingleVariableDeclaration)paramVars.get(i)).getType()));
            ++i;
        }
        buf.append(")").append(this.getReturnTypeSignature());
        return buf.toString();
    }

    public String getFullSignature() {
        return String.valueOf(this.getName()) + this.getSignature();
    }

    public int getParameterCount() {
        return this.m_method.parameters().size();
    }

    public String getAnnotationType() {
        return this.m_annotationType;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.getFullSignature().hashCode();
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof IMethodDescriptor)) {
            return false;
        }
        IMethodDescriptor castedObj = (IMethodDescriptor)o;
        return this.getFullSignature().equals(castedObj.getFullSignature());
    }
}

