/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.testng.eclipse.launch.components.Filters;
import org.testng.eclipse.refactoring.FindTestsRunnableContext;
import org.testng.eclipse.ui.conversion.JUnitConverterQuickAssistProcessor;
import org.testng.eclipse.ui.conversion.JUnitVisitor;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.TestSearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final Filters.ITypeFilter CONVERSION_FILTER = new Filters.ITypeFilter(){

        public boolean accept(IType type) {
            IResource resource = type.getResource();
            ICompilationUnit cu = JDTUtil.getJavaElement((IFile)resource);
            CompilationUnit astRoot = JUnitConverterQuickAssistProcessor.createCompilationUnit(cu);
            JUnitVisitor visitor = new JUnitVisitor();
            astRoot.accept((ASTVisitor)visitor);
            return visitor.needsConversion();
        }
    };

    public static List<IType> findSelectedTypes(IWorkbenchPage page, Filters.ITypeFilter filter) {
        return Utils.findTypes(Utils.getSelectedJavaElements(page), filter);
    }

    public static List<IType> findTypes(List<JavaElement> elements, Filters.ITypeFilter filter) {
        ArrayList result = Lists.newArrayList();
        if (filter == null) {
            filter = new Filters.ITypeFilter(){

                public boolean accept(IType type) {
                    return true;
                }
            };
        }
        for (JavaElement pp : elements) {
            if (pp.compilationUnit != null) {
                try {
                    IType[] iTypeArray = pp.compilationUnit.getAllTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType t = iTypeArray[n2];
                        if (filter.accept(t)) {
                            result.add(t);
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                continue;
            }
            IPackageFragmentRoot pfr = pp.packageFragmentRoot;
            IPackageFragment pf = pp.packageFragment;
            try {
                FindTestsRunnableContext context = new FindTestsRunnableContext();
                if (pf != null) {
                    result.addAll(Arrays.asList(TestSearchEngine.findTests(context, new Object[]{pf}, filter)));
                    continue;
                }
                if (pfr != null) {
                    result.addAll(Arrays.asList(TestSearchEngine.findTests(context, new Object[]{pfr}, filter)));
                    continue;
                }
                result.addAll(Arrays.asList(TestSearchEngine.findTests(context, new Object[]{pp.getProject()}, filter)));
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException interruptedException) {}
        }
        return result;
    }

    public static List<JavaElement> getSelectedJavaElements() {
        return Utils.getSelectedJavaElements(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
    }

    public static List<JavaElement> getSelectedJavaElements(IWorkbenchPage page) {
        ArrayList result = Lists.newArrayList();
        ISelection selection = page.getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection sel = (TreeSelection)selection;
            Iterator it = sel.iterator();
            while (it.hasNext()) {
                result.add(Utils.convertToJavaElement(it.next()));
            }
        } else {
            IEditorReference[] editors;
            IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeRoot root;
                IEditorReference ref = iEditorReferenceArray[n2];
                IEditorPart editor = ref.getEditor(false);
                if (editor != null && (root = JavaUI.getEditorInputTypeRoot((IEditorInput)editor.getEditorInput())) != null && root.getElementType() == 5) {
                    result.add(Utils.convertToJavaElement(root));
                }
                ++n2;
            }
        }
        return result;
    }

    private static JavaElement convertToJavaElement(Object element) {
        IResource resource;
        JavaElement result = new JavaElement();
        if (element instanceof IFile) {
            IJavaElement je = JavaCore.create((IFile)((IFile)element));
            if (je instanceof ICompilationUnit) {
                result.compilationUnit = (ICompilationUnit)je;
            }
        } else if (element instanceof ICompilationUnit) {
            result.compilationUnit = (ICompilationUnit)element;
        } else if (element instanceof IPackageFragment) {
            result.packageFragment = (IPackageFragment)element;
        } else if (element instanceof IPackageFragmentRoot) {
            result.packageFragmentRoot = (IPackageFragmentRoot)element;
        } else if (element instanceof IJavaProject) {
            result.m_project = (IJavaProject)element;
        } else if (element instanceof IProject) {
            result.m_project = JavaCore.create((IProject)((IProject)element));
        }
        if ((resource = result.getResource()) != null) {
            result.sourceFolder = resource.getFullPath().removeLastSegments(1).toOSString();
            for (IClasspathEntry entry : Utils.getSourceFolders(result.getProject())) {
                String source = entry.getPath().toOSString();
                if (source.endsWith("src/test/java")) {
                    result.sourceFolder = source;
                    break;
                }
                if (source.contains("test")) {
                    result.sourceFolder = source;
                    break;
                }
                if (!resource.getFullPath().toString().startsWith(source)) continue;
                result.sourceFolder = source;
                break;
            }
            if (result.sourceFolder.endsWith("src/main/java")) {
                result.sourceFolder = result.sourceFolder.replace("main", "test");
            }
        }
        return result;
    }

    public static List<IClasspathEntry> getSourceFolders(IJavaProject jp) {
        ArrayList result = Lists.newArrayList();
        try {
            IClasspathEntry[] iClasspathEntryArray = jp.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    result.add(entry);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void openFile(Shell shell, final IFile javaFile, IProgressMonitor monitor) {
        monitor.setTaskName("Opening file for editing...");
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)javaFile, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    public static class JavaElement {
        public IJavaProject m_project;
        public IPackageFragmentRoot packageFragmentRoot;
        public IPackageFragment packageFragment;
        public ICompilationUnit compilationUnit;
        public String sourceFolder;

        public String getPath() {
            String result = null;
            result = this.compilationUnit != null ? this.resourceToPath((IJavaElement)this.compilationUnit) : (this.packageFragmentRoot != null ? this.resourceToPath((IJavaElement)this.packageFragmentRoot) : (this.packageFragment != null ? this.resourceToPath((IJavaElement)this.packageFragment) : this.resourceToPath((IJavaElement)this.getProject())));
            return result;
        }

        public IJavaProject getProject() {
            if (this.m_project != null) {
                return this.m_project;
            }
            if (this.packageFragmentRoot != null) {
                return this.packageFragmentRoot.getJavaProject();
            }
            if (this.packageFragment != null) {
                return this.packageFragment.getJavaProject();
            }
            if (this.compilationUnit != null) {
                return this.compilationUnit.getJavaProject();
            }
            throw new AssertionError((Object)"Couldn't find a project");
        }

        private String resourceToPath(IJavaElement element) {
            return ((IResource)element.getAdapter(IResource.class)).getFullPath().toOSString();
        }

        public String getPackageName() {
            String result = null;
            if (this.packageFragment != null) {
                result = this.packageFragment.getElementName();
            } else if (this.compilationUnit != null) {
                try {
                    IPackageDeclaration[] pkg = this.compilationUnit.getPackageDeclarations();
                    result = pkg.length > 0 ? pkg[0].getElementName() : null;
                }
                catch (JavaModelException javaModelException) {}
            }
            return result;
        }

        public String getClassName() {
            String result = null;
            if (this.compilationUnit != null && (result = this.compilationUnit.getElementName()).endsWith(".java")) {
                result = result.substring(0, result.length() - ".java".length());
            }
            return result;
        }

        public IResource getResource() {
            if (this.compilationUnit != null) {
                return (IResource)this.compilationUnit.getAdapter(IResource.class);
            }
            if (this.packageFragment != null) {
                return (IResource)this.packageFragment.getAdapter(IResource.class);
            }
            if (this.m_project != null) {
                return (IResource)this.m_project.getAdapter(IResource.class);
            }
            return null;
        }
    }
}

