/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.TestNGException;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.LaunchSuite;
import org.testng.xml.Parser;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CustomSuite
extends LaunchSuite {
    public static final String DEFAULT_SUITE_TAG_NAME = "Default suite";
    public static final String DEFAULT_TEST_TAG_NAME = "Default test";
    protected String m_projectName;
    protected String m_suiteName;
    protected Map<String, String> m_parameters;
    protected int m_logLevel;
    private XMLStringBuffer m_suiteBuffer;

    public CustomSuite(String projectName, String suiteName, Map<String, String> parameters, int logLevel) {
        super(true);
        this.init(Collections.<String>emptyList(), projectName, suiteName, parameters, logLevel);
    }

    private void init(List<String> suiteFiles, String projectName, String suiteName, Map<String, String> parameters, int logLevel) {
        this.m_projectName = projectName;
        this.m_suiteName = suiteName;
        this.m_parameters = parameters;
        this.m_logLevel = logLevel;
    }

    protected abstract String getTestName();

    protected String getSuiteName() {
        return this.m_suiteName;
    }

    private void put(Properties p, String key, Object value) {
        if (value != null) {
            p.put(key, value);
        }
    }

    protected XMLStringBuffer createContentBuffer() {
        PreferenceStoreUtil storage = new PreferenceStoreUtil(TestNGPlugin.getDefault().getPreferenceStore());
        String xmlFile = storage.getXmlTemplateFile(this.m_projectName, false);
        boolean hasEclipseXmlFile = !Utils.isStringEmpty((String)xmlFile);
        XMLStringBuffer suiteBuffer = new XMLStringBuffer();
        suiteBuffer.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        if (hasEclipseXmlFile) {
            this.createXmlFileFromTemplate(suiteBuffer, xmlFile);
        } else {
            this.createXmlFileFromParameters(suiteBuffer);
        }
        this.initContentBuffer(suiteBuffer);
        suiteBuffer.pop("suite");
        return suiteBuffer;
    }

    private void createXmlFileFromParameters(XMLStringBuffer suiteBuffer) {
        Properties attrs = new Properties();
        attrs.setProperty("name", this.getSuiteName());
        suiteBuffer.push("suite", attrs);
        if (this.m_parameters != null) {
            for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
                Properties paramAttrs = new Properties();
                paramAttrs.setProperty("name", entry.getKey());
                paramAttrs.setProperty("value", entry.getValue());
                suiteBuffer.addEmptyElement("parameter", paramAttrs);
            }
        }
    }

    private void createXmlFileFromTemplate(XMLStringBuffer suiteBuffer, String fileName) {
        try {
            Parser parser = new Parser(fileName);
            parser.setLoadClasses(false);
            Collection suites = parser.parse();
            if (suites.size() > 0) {
                Properties p;
                XmlSuite s = (XmlSuite)suites.iterator().next();
                Properties attr = new Properties();
                this.put(attr, "name", s.getName());
                this.put(attr, "junit", s.isJUnit());
                this.put(attr, "verbose", s.getVerbose());
                this.put(attr, "parallel", s.getParallel());
                this.put(attr, "thread-count", s.getThreadCount());
                this.put(attr, "time-out", s.getTimeOut());
                this.put(attr, "skipfailedinvocationcounts", s.skipFailedInvocationCounts());
                this.put(attr, "configfailurepolicy", s.getConfigFailurePolicy());
                this.put(attr, "data-provider-thread-count", s.getDataProviderThreadCount());
                this.put(attr, "object-factory", s.getObjectFactory());
                this.put(attr, "allow-return-values", s.getAllowReturnValues());
                suiteBuffer.push("suite", attr);
                if (s.getListeners().size() > 0) {
                    suiteBuffer.push("listeners");
                    for (String l : s.getListeners()) {
                        p = new Properties();
                        p.put("class-name", l);
                        suiteBuffer.addEmptyElement("listener", p);
                    }
                    suiteBuffer.pop("listeners");
                }
                for (Map.Entry parameter : s.getParameters().entrySet()) {
                    p = new Properties();
                    p.put("name", parameter.getKey());
                    p.put("value", parameter.getValue());
                    suiteBuffer.addEmptyElement("parameter", p);
                }
                if (s.getMethodSelectors().size() > 0) {
                    suiteBuffer.push("method-selectors");
                    for (XmlMethodSelector ms : s.getMethodSelectors()) {
                        String cls = ms.getClassName();
                        if (cls == null || cls.length() <= 0) continue;
                        suiteBuffer.push("method-selector");
                        Properties p2 = new Properties();
                        p2.put("name", cls);
                        p2.put("priority", (Object)ms.getPriority());
                        suiteBuffer.addEmptyElement("selector-class", p2);
                        suiteBuffer.pop("method-selector");
                    }
                    suiteBuffer.pop("method-selectors");
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new TestNGException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new TestNGException((Throwable)e);
        }
        catch (SAXException e) {
            throw new TestNGException((Throwable)e);
        }
        catch (IOException e) {
            throw new TestNGException((Throwable)e);
        }
    }

    public XMLStringBuffer getSuiteBuffer() {
        if (this.m_suiteBuffer == null) {
            this.m_suiteBuffer = this.createContentBuffer();
        }
        return this.m_suiteBuffer;
    }

    public String getFileName() {
        return "testng-customsuite.xml";
    }

    public File save(File directory) {
        directory.mkdirs();
        File suiteFile = new File(directory, this.getFileName());
        this.saveSuiteContent(suiteFile, this.getSuiteBuffer());
        return suiteFile;
    }

    protected void saveSuiteContent(File file, XMLStringBuffer content) {
        block23: {
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                try {
                    fw = new FileWriter(file);
                    bw = new BufferedWriter(fw);
                    bw.write(content.getStringBuffer().toString());
                    bw.flush();
                }
                catch (IOException iOException) {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void initContentBuffer(XMLStringBuffer suiteBuffer) {
        Properties testAttrs = new Properties();
        testAttrs.setProperty("name", this.getTestName());
        testAttrs.setProperty("verbose", String.valueOf(this.m_logLevel));
        suiteBuffer.push("test", testAttrs);
        this.groupsElement(suiteBuffer);
        this.packagesElement(suiteBuffer);
        this.classesElement(suiteBuffer);
        suiteBuffer.pop("test");
    }

    protected void groupsElement(XMLStringBuffer suiteBuffer) {
    }

    protected void packagesElement(XMLStringBuffer suiteBuffer) {
    }

    protected void classesElement(XMLStringBuffer suiteBuffer) {
    }

    protected void generateDefaultGroupsElement(XMLStringBuffer suiteBuffer, Collection groupNames) {
        if (groupNames == null || groupNames.isEmpty()) {
            return;
        }
        suiteBuffer.push("groups");
        suiteBuffer.push("run");
        for (String groupName : groupNames) {
            Properties includeAttrs = new Properties();
            includeAttrs.setProperty("name", groupName);
            suiteBuffer.addEmptyElement("include", includeAttrs);
        }
        suiteBuffer.pop("run");
        suiteBuffer.pop("groups");
    }

    protected void generateDefaultPackagesElement(XMLStringBuffer suiteBuffer, List<String> packageNames) {
        if (packageNames == null || packageNames.isEmpty()) {
            return;
        }
        suiteBuffer.push("packages");
        for (String packageName : packageNames) {
            Properties packageAttrs = new Properties();
            packageAttrs.setProperty("name", packageName);
            suiteBuffer.addEmptyElement("package", packageAttrs);
        }
        suiteBuffer.pop("packages");
    }

    protected void generateDefaultClassesElement(XMLStringBuffer suiteBuffer, List<String> classNames) {
        if (classNames == null || classNames.isEmpty()) {
            return;
        }
        suiteBuffer.push("classes");
        for (String className : classNames) {
            Properties classAttrs = new Properties();
            classAttrs.setProperty("name", className);
            suiteBuffer.addEmptyElement("class", classAttrs);
        }
        suiteBuffer.pop("classes");
    }
}

