/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.tree;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.testng.eclipse.ui.Images;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.tree.ITreeItem;

public abstract class BaseTreeItem
implements ITreeItem {
    private static final String DATA_TREE_ITEM = "treeItem";
    private float m_time;
    private TreeItem m_treeItem;
    private RunInfo m_runInfo;
    private boolean m_hasImage = false;

    public static ITreeItem getTreeItem(TreeItem ti) {
        return (ITreeItem)ti.getData(DATA_TREE_ITEM);
    }

    public BaseTreeItem(TreeItem parent, RunInfo runInfo) {
        this.m_treeItem = new TreeItem(parent, 0);
        this.init(runInfo);
    }

    public BaseTreeItem(Tree parent, RunInfo runInfo) {
        this.m_treeItem = new TreeItem(parent, 0);
        this.init(runInfo);
    }

    private void init(RunInfo runInfo) {
        this.m_runInfo = runInfo;
        this.m_treeItem.setExpanded(true);
        this.m_treeItem.setData(DATA_TREE_ITEM, (Object)this);
    }

    public void addToCumulatedTime(RunInfo runInfo) {
        this.m_time += (float)runInfo.getTime();
        this.update(runInfo);
    }

    protected float getTime() {
        return this.m_time;
    }

    public TreeItem getTreeItem() {
        return this.m_treeItem;
    }

    public RunInfo getRunInfo() {
        return this.m_runInfo;
    }

    protected Image getSuiteImage(int state) {
        switch (state) {
            case 1: {
                return Images.getImage("suiteOk");
            }
            case 2: 
            case 4: {
                return Images.getImage("suiteFail");
            }
            case 3: {
                return Images.getImage("suiteSkip");
            }
        }
        throw new IllegalArgumentException("Illegal state:" + state);
    }

    protected void maybeUpdateImage(RunInfo runInfo) {
        int status = runInfo.getStatus();
        TreeItem treeItem = this.getTreeItem();
        if (!this.m_hasImage || status != 1) {
            treeItem.setImage(this.getSuiteImage(status));
            this.m_hasImage = true;
        }
    }
}

