/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.tree;

import java.text.MessageFormat;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;
import org.testng.eclipse.ui.Images;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.tree.BaseTreeItem;
import org.testng.eclipse.ui.tree.ITreeItem;

public abstract class BaseTestMethodTreeItem
extends BaseTreeItem
implements ITreeItem {
    private static final String FORMATTED_MESSAGE = "{0} {1} ({2,number,#.###} s)";

    public BaseTestMethodTreeItem(TreeItem parent, RunInfo runInfo) {
        super(parent, runInfo);
        this.update(runInfo);
    }

    public void update(RunInfo runInfo) {
        float time = this.getTime() / 1000.0f;
        this.getTreeItem().setText(MessageFormat.format(FORMATTED_MESSAGE, this.getLabel(), "", Float.valueOf(time)));
        this.getTreeItem().setImage(this.getImage(runInfo.getStatus()));
    }

    private Image getImage(int state) {
        switch (state) {
            case 1: {
                return Images.getImage("testOk");
            }
            case 2: 
            case 4: {
                return Images.getImage("testFail");
            }
            case 3: {
                return Images.getImage("testSkip");
            }
        }
        throw new IllegalArgumentException("Illegal state: state");
    }

    protected abstract String getLabel();
}

