/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.conversion;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.testng.AssertJUnit;
import org.testng.collections.Lists;
import org.testng.eclipse.ui.conversion.Visitor;
import org.testng.internal.annotations.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitVisitor
extends Visitor {
    private List<MethodDeclaration> m_testMethods = Lists.newArrayList();
    private List<MethodDeclaration> m_disabledTestMethods = Lists.newArrayList();
    private List<MethodDeclaration> m_beforeMethods = Lists.newArrayList();
    private List<MethodDeclaration> m_afterMethods = Lists.newArrayList();
    private List<MethodDeclaration> m_beforeClasses = Lists.newArrayList();
    private List<MethodDeclaration> m_afterClasses = Lists.newArrayList();
    private MethodDeclaration m_suite = null;
    private SimpleType m_testCase = null;
    private boolean m_isTestSuite = false;
    private List<ImportDeclaration> m_junitImports = Lists.newArrayList();
    private Set<String> m_assertStaticImports = Sets.newHashSet();
    private Map<MemberValuePair, String> m_testsWithExpected = Maps.newHashMap();
    private Set<MethodInvocation> m_asserts = Sets.newHashSet();
    private Set<MethodInvocation> m_fails = Sets.newHashSet();
    private boolean m_hasTestMethods = false;
    private List<ASTNode> m_nodesToRemove = Lists.newArrayList();
    private SuperConstructorInvocation m_superConstructorInvocation;
    private String m_className;
    private SingleMemberAnnotation m_runWithParameterized;
    private MethodDeclaration m_parametersMethod;
    private TypeDeclaration m_type;
    private boolean m_hasDefaultConstructor = false;
    private Map<MethodDeclaration, Annotation> m_ignoredMethods = Maps.newHashMap();
    private static Set<String> m_assertMethods = Sets.newHashSet();
    private static Map<String, Class> BINARY_CLASS_NAMES;

    static {
        Method[] methodArray = Assert.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            m_assertMethods.add(m.getName());
            ++n2;
        }
        m_assertMethods.add("assertArrayEquals");
        BINARY_CLASS_NAMES = new HashMap<String, Class>(){
            {
                this.put("B", Byte.TYPE);
                this.put("C", Character.TYPE);
                this.put("D", Double.TYPE);
                this.put("F", Float.TYPE);
                this.put("I", Integer.TYPE);
                this.put("J", Long.TYPE);
                this.put("L", Class.class);
                this.put("S", Short.TYPE);
                this.put("Z", Boolean.TYPE);
                this.put("[", Object[].class);
            }
        };
    }

    public boolean visit(ImportDeclaration id) {
        Name simpleName = id.getName();
        String name = simpleName.getFullyQualifiedName();
        if (name.indexOf("junit") != -1) {
            int ind = simpleName.toString().indexOf("assert");
            if (id.isStatic() && ind > 0) {
                this.m_assertStaticImports.add(simpleName.toString().substring(ind));
            }
            this.m_junitImports.add(id);
        }
        return super.visit(id);
    }

    public boolean visit(SuperMethodInvocation smi) {
        String name = smi.getName().toString();
        if (this.m_testCase != null && ("setUp".equals(name) || "tearDown".equals(name))) {
            this.m_nodesToRemove.add(smi.getParent());
        }
        return super.visit(smi);
    }

    public boolean visit(SuperConstructorInvocation sci) {
        Expression arg;
        ITypeBinding binding;
        List args;
        if (this.m_testCase != null && (args = sci.arguments()).size() == 1 && (binding = (arg = (Expression)args.get(0)).resolveTypeBinding()) != null && String.class.getName().equals(binding.getBinaryName())) {
            this.m_superConstructorInvocation = sci;
        }
        return super.visit(sci);
    }

    public SuperConstructorInvocation getSuperConstructorInvocation() {
        return this.m_superConstructorInvocation;
    }

    public boolean visit(MethodDeclaration md) {
        String methodName = md.getName().getFullyQualifiedName();
        if (methodName.equals("setUp") || this.hasAnnotation(md, "Before")) {
            this.m_beforeMethods.add(md);
        } else if (methodName.equals("tearDown") || this.hasAnnotation(md, "After")) {
            this.m_afterMethods.add(md);
        } else if (methodName.equals("suite")) {
            this.m_suite = md;
        } else if (methodName.equals(this.m_type.getName().toString())) {
            if (md.parameters().size() == 0) {
                this.m_hasDefaultConstructor = true;
            }
        } else if (this.hasAnnotation(md, "Parameters")) {
            this.m_parametersMethod = md;
        } else if (this.hasAnnotation(md, "BeforeClass")) {
            this.m_beforeClasses.add(md);
        } else if (this.hasAnnotation(md, "AfterClass")) {
            this.m_afterClasses.add(md);
        } else if (this.hasAnnotation(md, "Ignore")) {
            this.m_ignoredMethods.put(md, this.getAnnotation(md, "Ignore"));
        } else if (!this.hasAnnotation(md, "Test")) {
            boolean isPrivate;
            boolean bl = isPrivate = (md.getModifiers() & 2) != 0;
            if (methodName.startsWith("test") && !isPrivate) {
                this.m_testMethods.add(md);
            } else if (methodName.startsWith("_test") || methodName.startsWith("test") && isPrivate) {
                this.m_disabledTestMethods.add(md);
            }
        } else if (this.hasAnnotation(md, "Test")) {
            this.m_hasTestMethods = true;
            MemberValuePair mvp = this.getAttribute(md, "expected");
            if (mvp != null) {
                this.m_testsWithExpected.put(mvp, "expectedExceptions");
            }
            if ((mvp = this.getAttribute(md, "timeout")) != null) {
                this.m_testsWithExpected.put(mvp, "timeOut");
            }
        }
        return super.visit(md);
    }

    private MemberValuePair getAttribute(MethodDeclaration md, String attribute) {
        List modifiers = md.modifiers();
        for (IExtendedModifier m : modifiers) {
            Annotation a;
            if (!m.isAnnotation() || !"Test".equals((a = (Annotation)m).getTypeName().toString()) || !(a instanceof NormalAnnotation)) continue;
            NormalAnnotation na = (NormalAnnotation)a;
            for (Object o : na.values()) {
                MemberValuePair mvp = (MemberValuePair)o;
                if (!mvp.getName().toString().equals(attribute)) continue;
                return mvp;
            }
        }
        return null;
    }

    public boolean visit(TypeDeclaration td) {
        SimpleType st;
        this.m_className = td.getName().toString();
        this.m_type = td;
        List modifiers = td.modifiers();
        for (IExtendedModifier m : modifiers) {
            SingleMemberAnnotation a;
            if (!m.isAnnotation() || !(m instanceof SingleMemberAnnotation) || !"RunWith".equals((a = (SingleMemberAnnotation)m).getTypeName().toString()) || !"Parameterized.class".equals(a.getValue().toString())) continue;
            this.m_runWithParameterized = a;
        }
        Type superClass = td.getSuperclassType();
        if (superClass instanceof SimpleType && "TestCase".equals((st = (SimpleType)superClass).getName().getFullyQualifiedName())) {
            this.m_testCase = st;
        }
        if (superClass != null) {
            ITypeBinding binding = superClass.resolveBinding();
            while (binding != null) {
                if ("TestSuite".equals(binding.getName())) {
                    this.m_isTestSuite = true;
                    break;
                }
                binding = binding.getSuperclass();
            }
        }
        return super.visit(td);
    }

    public SingleMemberAnnotation getRunWithParameterized() {
        return this.m_runWithParameterized;
    }

    public MethodDeclaration getParametersMethod() {
        return this.m_parametersMethod;
    }

    public boolean visit(MethodInvocation node) {
        Expression exp = node.getExpression();
        String method = node.getName().toString();
        if (exp != null && "Assert".equals(exp.toString()) || method.startsWith("assert")) {
            if (this.belongsToAssertJUnit(node) && !this.m_assertStaticImports.contains(node.getName().toString())) {
                this.m_asserts.add(node);
            }
        } else if ("fail".equals(method) && this.belongsToAssertJUnit(node)) {
            this.m_fails.add(node);
        }
        return super.visit(node);
    }

    private Class getBinaryClassName(String binaryName) {
        return BINARY_CLASS_NAMES.get(binaryName);
    }

    private boolean belongsToAssertJUnit(MethodInvocation method) {
        if (!m_assertMethods.contains(method.getName().toString())) {
            return false;
        }
        List arguments = method.arguments();
        List types = Lists.newArrayList();
        for (Expression e : arguments) {
            ITypeBinding binding = e.resolveTypeBinding();
            if (binding == null) {
                return true;
            }
            Class c = this.bindingToClass(binding);
            types.add(c);
        }
        boolean result = false;
        this.adjustForOverloading(types);
        try {
            AssertJUnit.class.getMethod(method.getName().getFullyQualifiedName(), types.toArray(new Class[types.size()]));
            result = true;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (!(result || arguments.size() != 2 && arguments.size() != 3)) {
            result = true;
        }
        return result;
    }

    private void adjustForOverloading(List<Class> types) {
        if (types.size() > 2) {
            Class t2 = types.get(1);
            Class t3 = types.get(2);
            if (t2 == Long.TYPE && t3 == Integer.TYPE || t3 == Long.TYPE && t2 == Integer.TYPE) {
                types.set(1, Long.TYPE);
                types.set(2, Long.TYPE);
            }
        }
    }

    private Class bindingToClass(ITypeBinding binding) {
        Class result = this.getBinaryClassName(binding.getBinaryName());
        if (result == null) {
            try {
                result = Class.forName(binding.getQualifiedName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (result == null) {
            result = Object.class;
        }
        return result;
    }

    public Set<MethodInvocation> getAsserts() {
        return this.m_asserts;
    }

    private static void ppp(String s) {
        System.out.println("[JUnitVisitor] " + s);
        Assert.assertTrue((boolean)true);
    }

    public Collection<MethodDeclaration> getBeforeMethods() {
        return this.m_beforeMethods;
    }

    public Collection<MethodDeclaration> getAfterMethods() {
        return this.m_afterMethods;
    }

    public Collection<MethodDeclaration> getBeforeClasses() {
        return this.m_beforeClasses;
    }

    public Collection<MethodDeclaration> getAfterClasses() {
        return this.m_afterClasses;
    }

    public MethodDeclaration getSuite() {
        return this.m_suite;
    }

    public void setSuite(MethodDeclaration suite) {
        this.m_suite = suite;
    }

    public Collection<MethodDeclaration> getTestMethods() {
        return this.m_testMethods;
    }

    public Collection<MethodDeclaration> getDisabledTestMethods() {
        return this.m_disabledTestMethods;
    }

    public boolean hasTestMethods() {
        return this.m_hasTestMethods || this.m_testMethods.size() > 0 || this.m_disabledTestMethods.size() > 0;
    }

    public void setTestMethods(List<MethodDeclaration> testMethods) {
        this.m_testMethods = testMethods;
    }

    public SimpleType getTestCase() {
        return this.m_testCase;
    }

    public List<ImportDeclaration> getJUnitImports() {
        return this.m_junitImports;
    }

    public Set<String> getStaticImports() {
        return this.m_assertStaticImports;
    }

    public boolean hasAsserts() {
        return this.m_asserts.size() > 0;
    }

    public Set<MethodInvocation> getFails() {
        return this.m_fails;
    }

    public boolean hasFail() {
        return this.m_fails.size() > 0;
    }

    public Map<MemberValuePair, String> getTestsWithExpected() {
        return this.m_testsWithExpected;
    }

    public String toString() {
        return "[JUnitVisitor for class " + this.m_className + "]";
    }

    public List<ASTNode> getNodesToRemove() {
        return this.m_nodesToRemove;
    }

    public boolean needsConversion() {
        if (this.m_isTestSuite) {
            return false;
        }
        return this.m_hasTestMethods || this.getTestMethods().size() > 0 || this.getDisabledTestMethods().size() > 0 || this.getBeforeMethods().size() > 0 || this.getAfterMethods().size() > 0 || this.m_suite != null;
    }

    public TypeDeclaration getType() {
        return this.m_type;
    }

    public boolean hasDefaultConstructor() {
        return this.m_hasDefaultConstructor;
    }

    public Map<MethodDeclaration, Annotation> getIgnoredMethods() {
        return this.m_ignoredMethods;
    }
}

