/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.conversion;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.conversion.IRewriteProvider;
import org.testng.eclipse.ui.conversion.JUnitVisitor;
import org.testng.eclipse.util.PreferenceStoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationRewriter
implements IRewriteProvider {
    private static final Set<String> IMPORTS_TO_REMOVE = new HashSet<String>(){
        {
            this.add("junit.framework.Assert");
            this.add("junit.framework.Test");
            this.add("junit.framework.TestCase");
            this.add("junit.framework.TestSuite");
            this.add("org.junit.After");
            this.add("org.junit.AfterClass");
            this.add("org.junit.Before");
            this.add("org.junit.BeforeClass");
            this.add("org.junit.Ignore");
            this.add("org.junit.Test");
            this.add("org.junit.runner.RunWith");
            this.add("org.junit.runners.Parameterized");
        }
    };
    private static final Set<String> STATIC_IMPORTS_TO_REMOVE = new HashSet<String>(){
        {
            this.add("org.junit.Assert");
        }
    };

    @Override
    public ASTRewrite createRewriter(CompilationUnit astRoot, AST ast) {
        SingleMemberAnnotation runWith;
        Expression exp;
        ASTRewrite result = ASTRewrite.create((AST)astRoot.getAST());
        JUnitVisitor visitor = new JUnitVisitor();
        astRoot.accept((ASTVisitor)visitor);
        List<ImportDeclaration> oldImports = visitor.getJUnitImports();
        int i = 0;
        while (i < oldImports.size()) {
            Name importName = oldImports.get(i).getName();
            String fqn = importName.getFullyQualifiedName();
            if (IMPORTS_TO_REMOVE.contains(fqn)) {
                result.remove((ASTNode)oldImports.get(i), null);
            }
            for (String s : STATIC_IMPORTS_TO_REMOVE) {
                if (!fqn.contains(s)) continue;
                result.remove((ASTNode)oldImports.get(i), null);
            }
            ++i;
        }
        this.maybeAddImport(ast, result, astRoot, visitor.hasAsserts(), "org.testng.AssertJUnit");
        this.maybeAddImport(ast, result, astRoot, visitor.hasFail(), "org.testng.Assert");
        this.maybeAddImport(ast, result, astRoot, !visitor.getBeforeClasses().isEmpty(), "org.testng.annotations.BeforeClass");
        this.maybeAddImport(ast, result, astRoot, !visitor.getBeforeMethods().isEmpty(), "org.testng.annotations.BeforeMethod");
        this.maybeAddImport(ast, result, astRoot, visitor.hasTestMethods(), "org.testng.annotations.Test");
        this.maybeAddImport(ast, result, astRoot, !visitor.getAfterMethods().isEmpty(), "org.testng.annotations.AfterMethod");
        this.maybeAddImport(ast, result, astRoot, !visitor.getAfterClasses().isEmpty(), "org.testng.annotations.AfterClass");
        Set<String> staticImports = visitor.getStaticImports();
        for (String si : staticImports) {
            this.addImport(ast, result, astRoot, "org.testng.AssertJUnit." + si, true);
        }
        SimpleType td = visitor.getTestCase();
        if (td != null) {
            result.remove((ASTNode)td, null);
        }
        this.maybeAddAnnotations(ast, visitor, result, visitor.getTestMethods(), "Test", null, null);
        this.maybeAddAnnotations(ast, visitor, result, visitor.getDisabledTestMethods(), "Test", null, this.createDisabledAttribute(ast));
        this.maybeAddAnnotations(ast, visitor, result, visitor.getBeforeMethods(), "BeforeMethod", "@Before");
        this.maybeAddAnnotations(ast, visitor, result, visitor.getAfterMethods(), "AfterMethod", "@After");
        PreferenceStoreUtil.SuiteMethodTreatment smt = TestNGPlugin.getPluginPreferenceStore().getSuiteMethodTreatement();
        MethodDeclaration suiteMethod = visitor.getSuite();
        if (smt != PreferenceStoreUtil.SuiteMethodTreatment.DONT_TOUCH && suiteMethod != null) {
            if (smt == PreferenceStoreUtil.SuiteMethodTreatment.REMOVE) {
                result.remove((ASTNode)suiteMethod, null);
            } else {
                TypeDeclaration typeDeclaration = visitor.getType();
                ListRewrite listRewrite = result.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
                listRewrite.insertBefore(result.createStringPlaceholder("/*", 31), (ASTNode)suiteMethod, null);
                listRewrite.insertAfter(result.createStringPlaceholder("*/", 31), (ASTNode)suiteMethod, null);
            }
        }
        for (ASTNode aSTNode : visitor.getNodesToRemove()) {
            result.remove(aSTNode, null);
        }
        for (Map.Entry<MethodDeclaration, Annotation> entry : visitor.getIgnoredMethods().entrySet()) {
            MethodDeclaration md = entry.getKey();
            Annotation ignored = entry.getValue();
            NormalAnnotation test = ast.newNormalAnnotation();
            test.setTypeName(ast.newName("Test"));
            MemberValuePair mvp = ast.newMemberValuePair();
            mvp.setName(ast.newSimpleName("enabled"));
            mvp.setValue((Expression)ast.newBooleanLiteral(false));
            test.values().add(mvp);
            result.remove((ASTNode)ignored, null);
            ListRewrite lr = result.getListRewrite((ASTNode)md, MethodDeclaration.MODIFIERS2_PROPERTY);
            lr.insertFirst((ASTNode)test, null);
        }
        Set<MethodInvocation> set = visitor.getAsserts();
        for (MethodInvocation methodInvocation : set) {
            if (staticImports.contains(methodInvocation.getName().toString())) continue;
            exp = methodInvocation.getExpression();
            Name name = ast.newName("AssertJUnit");
            if (exp != null) {
                result.replace((ASTNode)exp, (ASTNode)name, null);
                continue;
            }
            result.set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)name, null);
        }
        for (MethodInvocation methodInvocation : visitor.getFails()) {
            exp = ast.newSimpleName("Assert");
            result.set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)exp, null);
        }
        for (Map.Entry entry : visitor.getTestsWithExpected().entrySet()) {
            result.replace((ASTNode)((MemberValuePair)entry.getKey()).getName(), (ASTNode)ast.newSimpleName((String)entry.getValue()), null);
        }
        SuperConstructorInvocation superConstructorInvocation = visitor.getSuperConstructorInvocation();
        if (superConstructorInvocation != null) {
            result.remove((ASTNode)superConstructorInvocation, null);
        }
        if ((runWith = visitor.getRunWithParameterized()) != null) {
            result.remove((ASTNode)runWith, null);
            this.addImport(ast, result, astRoot, "org.testng.ConversionUtils.wrapDataProvider", true);
            this.addImport(ast, result, astRoot, "org.testng.annotations.Factory", false);
            MethodDeclaration parameterMethod = visitor.getParametersMethod();
            ListRewrite lr = result.getListRewrite((ASTNode)visitor.getType(), TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            MethodDeclaration md = ast.newMethodDeclaration();
            md.setName(ast.newSimpleName("factory" + this.capitalize(parameterMethod.getName().toString())));
            MarkerAnnotation factory = ast.newMarkerAnnotation();
            factory.setTypeName(ast.newName("Factory"));
            md.modifiers().add(factory);
            md.modifiers().addAll(ast.newModifiers(9));
            ArrayType returnType = ast.newArrayType((Type)ast.newSimpleType(ast.newName("Object")));
            md.setReturnType2((Type)returnType);
            MethodInvocation mi = ast.newMethodInvocation();
            mi.setName(ast.newSimpleName("wrapDataProvider"));
            TypeLiteral tl = ast.newTypeLiteral();
            tl.setType((Type)ast.newSimpleType((Name)ast.newSimpleName(visitor.getType().getName().toString())));
            mi.arguments().add(tl);
            MethodInvocation pmi = ast.newMethodInvocation();
            pmi.setName(ast.newSimpleName(parameterMethod.getName().getFullyQualifiedName()));
            mi.arguments().add(pmi);
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression((Expression)mi);
            Block block = ast.newBlock();
            block.statements().add(returnStatement);
            md.setBody(block);
            lr.insertFirst((ASTNode)md, null);
        }
        return result;
    }

    private String capitalize(String s) {
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    private Map<String, Boolean> createDisabledAttribute(AST ast) {
        HashMap result = Maps.newHashMap();
        result.put("enabled", false);
        return result;
    }

    private void maybeAddImport(AST ast, ASTRewrite rewriter, CompilationUnit astRoot, boolean add, String imp) {
        if (add) {
            this.addImport(ast, rewriter, astRoot, imp);
        }
    }

    private void addImport(AST ast, ASTRewrite rewriter, CompilationUnit astRoot, String imp) {
        this.addImport(ast, rewriter, astRoot, imp, false);
    }

    private void addImport(AST ast, ASTRewrite rewriter, CompilationUnit astRoot, String imp, boolean isStatic) {
        ListRewrite lr = rewriter.getListRewrite((ASTNode)astRoot, CompilationUnit.IMPORTS_PROPERTY);
        ImportDeclaration id = ast.newImportDeclaration();
        id.setStatic(isStatic);
        id.setName(ast.newName(imp));
        lr.insertFirst((ASTNode)id, null);
    }

    private void maybeAddAnnotation(AST ast, JUnitVisitor visitor, ASTRewrite rewriter, MethodDeclaration method, String annotation, String annotationToRemove, Map<String, Boolean> attributes) {
        if (method != null) {
            this.addAnnotation(ast, visitor, rewriter, method, this.createAnnotation(ast, annotation, attributes), annotationToRemove);
        }
    }

    private Annotation createAnnotation(AST ast, String name, Map<String, Boolean> attributes) {
        MarkerAnnotation result = null;
        NormalAnnotation normalAnnotation = null;
        if (attributes != null && attributes.size() > 0) {
            normalAnnotation = ast.newNormalAnnotation();
            result = normalAnnotation;
        } else {
            result = ast.newMarkerAnnotation();
        }
        result.setTypeName(ast.newName(name));
        if (attributes != null) {
            for (Map.Entry<String, Boolean> a : attributes.entrySet()) {
                MemberValuePair mvp = ast.newMemberValuePair();
                mvp.setName(ast.newSimpleName(a.getKey()));
                mvp.setValue((Expression)ast.newBooleanLiteral(a.getValue().booleanValue()));
                normalAnnotation.values().add(mvp);
            }
        }
        return result;
    }

    private void maybeAddAnnotations(AST ast, JUnitVisitor visitor, ASTRewrite rewriter, Collection<MethodDeclaration> methods, String annotation, String annotationToRemove) {
        this.maybeAddAnnotations(ast, visitor, rewriter, methods, annotation, annotationToRemove, null);
    }

    private void maybeAddAnnotations(AST ast, JUnitVisitor visitor, ASTRewrite rewriter, Collection<MethodDeclaration> methods, String annotation, String annotationToRemove, Map<String, Boolean> attributes) {
        for (MethodDeclaration method : methods) {
            this.maybeAddAnnotation(ast, visitor, rewriter, method, annotation, annotationToRemove, attributes);
        }
    }

    private void addAnnotation(AST ast, JUnitVisitor visitor, ASTRewrite rewriter, MethodDeclaration md, Annotation a, String annotationToRemove) {
        ListRewrite lr = rewriter.getListRewrite((ASTNode)md, MethodDeclaration.MODIFIERS2_PROPERTY);
        if (annotationToRemove != null) {
            List modifiers = md.modifiers();
            int k = 0;
            while (k < modifiers.size()) {
                String oldAnnotation;
                Object old = modifiers.get(k);
                if (old instanceof Annotation && ((oldAnnotation = old.toString()).equals(annotationToRemove) || "@Override".equals(oldAnnotation))) {
                    lr.remove((ASTNode)((Annotation)old), null);
                    break;
                }
                ++k;
            }
        }
        lr.insertFirst((ASTNode)a, null);
    }

    @Override
    public String getName() {
        return "Convert to TestNG (Annotations)";
    }
}

