/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.ClearResultsAction;
import org.testng.eclipse.ui.CounterPanel;
import org.testng.eclipse.ui.EclipseTestRunnerClient;
import org.testng.eclipse.ui.FailureTab;
import org.testng.eclipse.ui.Images;
import org.testng.eclipse.ui.OpenTestAction;
import org.testng.eclipse.ui.ProgressBar;
import org.testng.eclipse.ui.RunHistoryAction;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.ShowNextFailureAction;
import org.testng.eclipse.ui.ShowPreviousFailureAction;
import org.testng.eclipse.ui.SuccessTab;
import org.testng.eclipse.ui.SuiteRunInfo;
import org.testng.eclipse.ui.TestRunTab;
import org.testng.eclipse.ui.WatchResultThread;
import org.testng.eclipse.ui.summary.SummaryTab;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.LaunchUtil;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.StringUtils;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IMessageSender;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.remote.strprotocol.SerializedMessageSender;
import org.testng.remote.strprotocol.StringMessageSender;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunnerViewPart
extends ViewPart
implements IPropertyChangeListener,
IRemoteSuiteListener,
IRemoteTestListener {
    private static final Object FAMILY_RUN = new Object();
    protected boolean m_partIsVisible = false;
    private IMemento m_stateMemento;
    private IJavaProject m_workingProject;
    protected volatile String m_statusMessage;
    private Composite m_parentComposite;
    private CTabFolder m_tabFolder;
    private TestRunTab m_activeRunTab;
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    private int fOrientation = 2;
    private int fCurrentOrientation;
    protected CounterPanel m_counterPanel;
    private Composite m_counterComposite;
    final Image m_viewIcon = TestNGPlugin.getImageDescriptor("main16/testng_noshadow.gif").createImage();
    private Action fNextAction;
    private Action fPrevAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private Action m_rerunAction;
    private Action m_rerunFailedAction;
    private RunHistoryAction m_runHistoryAction;
    private Action m_openReportAction;
    protected boolean fAutoScroll = true;
    protected ProgressBar fProgressBar;
    private ToolItem m_stopButton;
    private Color fOKColor;
    private Color fFailureColor;
    private boolean m_isDisposed = false;
    private UpdateUIJob m_updateUIJob;
    private IsRunningJob m_isRunningJob;
    private ILock m_runLock;
    public static final String NAME = "org.testng.eclipse.ResultView";
    public static final String ID_EXTENSION_POINT_TESTRUN_TABS = "org.testng.eclipse.internal_testRunTabs";
    static final int REFRESH_INTERVAL = 200;
    static final String TAG_PAGE = "page";
    static final String TAG_ORIENTATION = "orientation";
    private static final int MAX_RESULTS_THRESHOLD = 1000;
    private static final int MAX_TEXT_SIZE_THRESHOLD = 3;
    private SuiteRunInfo currentSuiteRunInfo;
    private EclipseTestRunnerClient fTestRunnerClient;
    private Set<String> testDescriptions;
    private Text m_searchText;
    private WatchResultThread m_watchThread;
    private Action m_clearTreeAction;
    private static TestRunTab m_failureTab = new FailureTab();
    private static SummaryTab m_summaryTab = new SummaryTab();
    private static final TestRunTab[] LISTENING_TABS = new TestRunTab[]{m_summaryTab};
    private static final TestRunTab[] REPORTING_TABS = new TestRunTab[]{new SuccessTab(), m_failureTab};
    private static final List<TestRunTab> ALL_TABS = new ArrayList<TestRunTab>(){
        {
            this.addAll(Arrays.asList(REPORTING_TABS));
            this.addAll(Arrays.asList(LISTENING_TABS));
        }
    };
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.m_partIsVisible = true;
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.m_partIsVisible = false;
            }
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.m_stateMemento = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(FAMILY_RUN);
        }
        this.updateResultThread();
    }

    private IWorkbenchSiteProgressService getProgressService() {
        Object siteService = this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    private void restoreLayoutState(IMemento memento) {
        Integer page = memento.getInteger(TAG_PAGE);
        if (page != null) {
            int p = page;
            this.m_tabFolder.setSelection(p);
            this.m_activeRunTab = ALL_TABS.get(p);
        }
        for (TestRunTab trt : ALL_TABS) {
            trt.restoreState(memento);
        }
        Integer orientation = memento.getInteger(TAG_ORIENTATION);
        if (orientation != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
    }

    void computeOrientation() {
        if (this.fOrientation != 2) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.m_parentComposite.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void setOrientation(int orientation) {
        boolean horizontal = orientation == 1;
        for (TestRunTab trt : ALL_TABS) {
            trt.setOrientation(horizontal);
        }
        ToggleOrientationAction[] toggleOrientationActionArray = this.fToggleOrientationActions;
        int n = this.fToggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction fToggleOrientationAction;
            fToggleOrientationAction.setChecked(this.fOrientation == (fToggleOrientationAction = toggleOrientationActionArray[n2]).getOrientation());
            ++n2;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.m_counterComposite.getLayout();
        this.setCounterColumns(layout);
        try {
            this.m_parentComposite.layout();
        }
        catch (Throwable cause) {
            cause.printStackTrace();
        }
    }

    private void stopTest() {
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
        this.stopUpdateJobs();
    }

    public void selectNextFailure() {
        this.m_activeRunTab.selectNext();
    }

    public void selectPreviousFailure() {
        this.m_activeRunTab.selectPrevious();
    }

    public void showTest(RunInfo test) {
        this.m_activeRunTab.setSelectedTest(test.getId());
        new OpenTestAction(this, test.getClassName(), test.getMethodName(), false).run();
    }

    public void reset() {
        this.reset(0, 0);
        this.clearStatus();
        this.fNextAction.setEnabled(false);
        this.fPrevAction.setEnabled(false);
        this.m_rerunAction.setEnabled(false);
        this.m_rerunFailedAction.setEnabled(false);
        this.m_openReportAction.setEnabled(false);
    }

    private void stopUpdateJobs() {
        if (this.m_updateUIJob != null) {
            this.m_updateUIJob.stop();
            this.m_updateUIJob = null;
        }
        if (this.m_isRunningJob != null && this.m_runLock != null) {
            this.m_runLock.release();
            this.m_isRunningJob = null;
        }
    }

    public void startTestRunListening(IJavaProject project, String subName, int port, ILaunch launch) {
        this.m_workingProject = project;
        this.aboutToLaunch(subName);
        this.fTestRunnerClient = new EclipseTestRunnerClient();
        StringMessageSender messageMarshaller = LaunchUtil.useStringProtocol(launch.getLaunchConfiguration()) ? new StringMessageSender("localhost", port) : new SerializedMessageSender("localhost", port);
        boolean isInitSuccess = false;
        do {
            try {
                messageMarshaller.initReceiver();
                isInitSuccess = true;
            }
            catch (SocketTimeoutException e) {
                TestNGPlugin.log(e);
            }
        } while (!isInitSuccess && !launch.isTerminated());
        if (isInitSuccess) {
            this.newSuiteRunInfo(launch);
            this.fTestRunnerClient.startListening((IRemoteSuiteListener)this.currentSuiteRunInfo, (IRemoteTestListener)this.currentSuiteRunInfo, (IMessageSender)messageMarshaller);
            this.m_rerunAction.setEnabled(true);
            this.m_rerunFailedAction.setEnabled(false);
            this.m_openReportAction.setEnabled(true);
        } else {
            boolean useProjectJar = TestNGPlugin.getPluginPreferenceStore().getUseProjectJar(project.getProject().getName());
            String suggestion = useProjectJar ? "Uncheck the 'Use Project testng.jar' option from your Project properties and try again." : "Make sure you don't have an older version of testng.jar on your class path.";
            new ErrorDialog(this.m_counterComposite.getShell(), "Couldn't launch TestNG", "Couldn't contact the RemoteTestNG client. " + suggestion, (IStatus)new StatusInfo(4, "Timeout while trying to contact RemoteTestNG."), 4).open();
        }
    }

    private void updateResultThread() {
        boolean enabled = this.getWatchResults();
        String path = this.getWatchResultDirectory();
        if (this.m_watchThread != null) {
            this.m_watchThread.stopWatching();
        }
        if (enabled) {
            TestNGPlugin.log("Monitoring results at " + path);
            this.newSuiteRunInfo(null);
            this.m_watchThread = new WatchResultThread(path, this.currentSuiteRunInfo, this.currentSuiteRunInfo);
        } else {
            if (!StringUtils.isEmptyString(path)) {
                TestNGPlugin.log("No longer monitoring results at " + path);
            }
            this.m_watchThread = null;
        }
    }

    private void newSuiteRunInfo(ILaunch launch) {
        if (this.currentSuiteRunInfo != null) {
            this.currentSuiteRunInfo.removeDelegateListeners();
        }
        this.currentSuiteRunInfo = new SuiteRunInfo(this, this, launch);
        this.m_runHistoryAction.add(this.currentSuiteRunInfo);
    }

    private void initProject() {
        IEditorInput input;
        IEditorPart ieditorpart;
        IWorkbenchPage iworkbenchpage;
        IWorkbenchWindow iworkbenchwindow;
        IWorkbench iworkbench = PlatformUI.getWorkbench();
        if (iworkbench != null && (iworkbenchwindow = iworkbench.getActiveWorkbenchWindow()) != null && (iworkbenchpage = iworkbenchwindow.getActivePage()) != null && (ieditorpart = iworkbenchpage.getActiveEditor()) != null && (input = ieditorpart.getEditorInput()) != null && input instanceof IFileEditorInput) {
            IFile resource = ((IFileEditorInput)input).getFile();
            IProject project = resource.getProject();
            IJavaProject javaProject = JDTUtil.getJavaProject(project.getName());
            if (javaProject != null) {
                this.m_workingProject = javaProject;
            } else {
                TestNGPlugin.log("Current project " + project.getName() + " is not a Java project");
            }
        }
    }

    protected void aboutToLaunch(String message) {
        String msg = ResourceUtil.getFormattedString("TestRunnerViewPart.message.launching", message);
        this.setPartName(msg);
        this.firePropertyChange(1);
    }

    public synchronized void dispose() {
        this.m_isDisposed = true;
        this.stopTest();
        TestNGPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        this.m_viewIcon.dispose();
        this.fOKColor.dispose();
        this.fFailureColor.dispose();
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void postAsyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(r);
        }
    }

    private void refreshCounters() {
        this.m_counterPanel.setMethodCount(this.currentSuiteRunInfo.getMethodCount());
        this.m_counterPanel.setPassedCount(this.currentSuiteRunInfo.getPassedCount());
        this.m_counterPanel.setFailedCount(this.currentSuiteRunInfo.getFailedCount());
        this.m_counterPanel.setSkippedCount(this.currentSuiteRunInfo.getSkippedCount());
        String msg = "";
        if (this.currentSuiteRunInfo.hasRun()) {
            msg = " (" + this.currentSuiteRunInfo.getRunDuration() + " ms)";
        }
        this.fProgressBar.refresh(this.currentSuiteRunInfo.getStatus(), msg);
    }

    protected void postShowTestResultsView() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.showTestResultsView();
            }
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        TestRunnerViewPart testRunner = null;
        if (page != null) {
            try {
                testRunner = (TestRunnerViewPart)page.findView(NAME);
                if (testRunner == null) {
                    IWorkbenchPart activePart = page.getActivePart();
                    testRunner = (TestRunnerViewPart)page.showView(NAME);
                    page.activate(activePart);
                } else {
                    page.bringToTop((IWorkbenchPart)testRunner);
                }
            }
            catch (PartInitException pie) {
                TestNGPlugin.log(pie);
            }
        }
    }

    protected void setInfoMessage(String message) {
        this.m_statusMessage = message;
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    protected CTabFolder createTestRunTabs(Composite parent) {
        CTabFolder tabFolder = new CTabFolder(parent, 128);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadTestRunTabs(tabFolder);
        tabFolder.setSelection(0);
        this.m_activeRunTab = ALL_TABS.get(0);
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestRunnerViewPart.this.testTabChanged(event);
            }
        });
        return tabFolder;
    }

    private void loadTestRunTabs(CTabFolder tabFolder) {
        TestRunTab t;
        TestRunTab[] testRunTabArray = REPORTING_TABS;
        int n = REPORTING_TABS.length;
        int n2 = 0;
        while (n2 < n) {
            t = testRunTabArray[n2];
            this.createTabControl(t, tabFolder, this);
            ++n2;
        }
        testRunTabArray = LISTENING_TABS;
        n = LISTENING_TABS.length;
        n2 = 0;
        while (n2 < n) {
            t = testRunTabArray[n2];
            this.createTabControl(t, tabFolder, this);
            ++n2;
        }
    }

    private void createTabControl(TestRunTab testRunTab, CTabFolder tabFolder, TestRunnerViewPart testRunnerViewPart) {
        Composite composite = testRunTab.createTabControl((Composite)tabFolder, this);
        CTabItem tab = new CTabItem(tabFolder, 0);
        tab.setText(ResourceUtil.getString(testRunTab.getNameKey()));
        tab.setImage(testRunTab.getImage());
        tab.setToolTipText(ResourceUtil.getString(testRunTab.getTooltipKey()));
        tab.setControl((Control)composite);
    }

    private void testTabChanged(SelectionEvent event) {
        String selectedTestId = this.m_activeRunTab.getSelectedTestId();
        for (TestRunTab tab : ALL_TABS) {
            tab.setSelectedTest(selectedTestId);
            String name = ResourceUtil.getString(tab.getNameKey());
            if (((CTabFolder)event.widget).getSelection().getText() != name) continue;
            this.m_activeRunTab = tab;
            this.m_activeRunTab.activate();
        }
    }

    void reset(int suiteCount, final int testCount) {
        this.currentSuiteRunInfo.setSuitesTotalCount(suiteCount);
        this.currentSuiteRunInfo.setTestsTotalCount(testCount);
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.m_counterPanel.reset();
                TestRunnerViewPart.this.fProgressBar.reset(testCount);
                TestRunnerViewPart.this.clearStatus();
                for (TestRunTab tab : ALL_TABS) {
                    tab.aboutToStart();
                }
            }
        });
    }

    public void setFocus() {
        if (this.m_activeRunTab != null) {
            this.m_activeRunTab.setFocus();
        }
    }

    private boolean getWatchResults() {
        return TestNGPlugin.getPluginPreferenceStore().getWatchResults(this.getProjectName());
    }

    private String getWatchResultDirectory() {
        String projectName = this.getProjectName();
        return projectName != null ? TestNGPlugin.getPluginPreferenceStore().getWatchResultDirectory(projectName) : null;
    }

    public void createPartControl(Composite parent) {
        if (this.getWatchResultDirectory() != null) {
            this.updateResultThread();
        }
        this.m_parentComposite = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.configureToolBar();
        this.createProgressCountPanel(parent);
        this.m_tabFolder = this.createTestRunTabs(parent);
        TestNGPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        if (this.m_stateMemento != null) {
            this.restoreLayoutState(this.m_stateMemento);
        }
        this.m_stateMemento = null;
    }

    public void saveState(IMemento memento) {
        int activePage = this.m_tabFolder.getSelectionIndex();
        memento.putInteger(TAG_PAGE, activePage);
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
        for (TestRunTab tab : ALL_TABS) {
            tab.saveState(memento);
        }
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 2)};
        this.fNextAction = new ShowNextFailureAction(this);
        this.fPrevAction = new ShowPreviousFailureAction(this);
        this.m_rerunAction = new RerunAction();
        this.m_rerunFailedAction = new RerunFailedAction();
        this.m_runHistoryAction = new RunHistoryAction(this);
        this.m_openReportAction = new OpenReportAction();
        this.m_clearTreeAction = new ClearResultsAction(ALL_TABS);
        this.fNextAction.setEnabled(false);
        this.fPrevAction.setEnabled(false);
        this.m_rerunAction.setEnabled(false);
        this.m_rerunFailedAction.setEnabled(false);
        this.m_openReportAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPrevAction);
        toolBar.add((IAction)this.m_clearTreeAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fNextAction);
        toolBar.add((IAction)this.fPrevAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.m_rerunAction);
        toolBar.add((IAction)this.m_rerunFailedAction);
        toolBar.add((IAction)this.m_runHistoryAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.m_openReportAction);
        ToggleOrientationAction[] toggleOrientationActionArray = this.fToggleOrientationActions;
        int n = this.fToggleOrientationActions.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleOrientationAction fToggleOrientationAction = toggleOrientationActionArray[n2];
            viewMenu.add((IAction)fToggleOrientationAction);
            ++n2;
        }
        actionBars.updateActionBars();
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    protected void createProgressCountPanel(Composite parent) {
        Display display = parent.getDisplay();
        this.fFailureColor = new Color((Device)display, 159, 63, 63);
        this.fOKColor = new Color((Device)display, 95, 191, 95);
        this.m_counterComposite = new Composite(parent, 0);
        this.m_counterComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        this.m_counterComposite.setLayout((Layout)layout);
        this.setCounterColumns(layout);
        this.fProgressBar = new ProgressBar(this.m_counterComposite);
        this.fProgressBar.setLayoutData(new GridData(768));
        ToolBar toolBar = new ToolBar(this.m_counterComposite, 0x800000);
        this.m_stopButton = new ToolItem(toolBar, 8);
        this.m_stopButton.setEnabled(false);
        this.m_stopButton.setImage(Images.getImage("stop"));
        this.m_stopButton.setToolTipText("Stop the current test run");
        this.m_stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestRunnerViewPart.this.stopTest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite line2 = new Composite(parent, 0);
        line2.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 3;
        line2.setLayout((Layout)layout2);
        new Label(line2, 0).setText("Search:");
        this.m_searchText = new Text(line2, 2052);
        this.m_searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.m_searchText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String filter = "";
                if (TestRunnerViewPart.this.currentSuiteRunInfo.getNbResults() < 1000 || TestRunnerViewPart.this.currentSuiteRunInfo.getNbResults() >= 1000 && TestRunnerViewPart.this.m_searchText.getText().length() >= 3) {
                    filter = TestRunnerViewPart.this.m_searchText.getText();
                }
                for (TestRunTab tab : ALL_TABS) {
                    tab.updateSearchFilter(filter);
                }
            }
        });
        this.m_counterPanel = new CounterPanel(line2);
    }

    public IJavaProject getLaunchedProject() {
        if (this.m_workingProject == null) {
            this.initProject();
        }
        return this.m_workingProject;
    }

    public void setLaunchedProject(IJavaProject project) {
        this.m_workingProject = project;
    }

    public ILaunch getLastLaunch() {
        if (this.currentSuiteRunInfo != null) {
            return this.currentSuiteRunInfo.getLaunch();
        }
        return null;
    }

    private boolean isDisposed() {
        return this.m_isDisposed || this.m_counterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public boolean isCreated() {
        return this.m_counterPanel != null;
    }

    public void warnOfContentChange() {
        IWorkbenchSiteProgressService service = this.getProgressService();
        if (service != null) {
            service.warnOfContentChange();
        }
    }

    public boolean lastLaunchIsKeptAlive() {
        return false;
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == 1 ? 3 : 2;
    }

    private static void ppp(Object message) {
        System.out.println("[TestRunnerViewPart] " + message);
    }

    public Image getTitleImage() {
        return this.m_viewIcon;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getProperty();
        String statusChanged = String.valueOf(this.getProjectName()) + ".watchResults";
        String directoryChanged = String.valueOf(this.getProjectName()) + ".watchResultDirectory";
        if (statusChanged.equals(name) || directoryChanged.equals(name)) {
            this.updateResultThread();
        }
    }

    private void postTestResult(final RunInfo runInfo, final int progressStep) {
        this.currentSuiteRunInfo.add(runInfo);
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.fProgressBar.step(progressStep);
                TestRunnerViewPart.this.fProgressBar.setTestName(runInfo.getTestName());
                for (TestRunTab tab : ALL_TABS) {
                    tab.updateTestResult(runInfo, true);
                }
            }
        });
    }

    private void showResultsInTree() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                for (TestRunTab tab : ALL_TABS) {
                    tab.updateTestResult(TestRunnerViewPart.this.currentSuiteRunInfo.getResults());
                }
            }
        });
    }

    public void onInitialization(GenericMessage genericMessage) {
        int suiteCount = genericMessage.getSuiteCount();
        int testCount = genericMessage.getTestCount();
        this.reset(suiteCount, testCount);
        this.stopUpdateJobs();
        this.m_updateUIJob = new UpdateUIJob("Update TestNG");
        this.m_isRunningJob = new IsRunningJob("TestNG run wrapper job");
        this.m_runLock = Job.getJobManager().newLock();
        this.m_runLock.acquire();
        this.getProgressService().schedule((Job)this.m_isRunningJob);
        this.m_updateUIJob.schedule(200L);
    }

    public void onFinish(SuiteMessage suiteMessage) {
        m_summaryTab.setExcludedMethodsModel(suiteMessage);
        this.postAsyncRunnable(new Runnable(){

            public void run() {
                TestRunnerViewPart.this.m_searchText.setToolTipText(TestRunnerViewPart.this.currentSuiteRunInfo.getNbResults() > 1000 ? ResourceUtil.getFormattedString("TestRunnerViewPart.typeCharacters.tooltip", 3) : "");
            }
        });
        this.fProgressBar.setTestName(null);
        if (this.currentSuiteRunInfo.isSuiteRunFinished()) {
            boolean hasErrors = this.currentSuiteRunInfo.hasErrors();
            this.fNextAction.setEnabled(hasErrors);
            this.fPrevAction.setEnabled(hasErrors);
            this.m_rerunFailedAction.setEnabled(hasErrors);
            this.postShowTestResultsView();
            this.stopTest();
            this.postSyncRunnable(new Runnable(){

                public void run() {
                    if (TestRunnerViewPart.this.isDisposed()) {
                        return;
                    }
                    TestRunnerViewPart.this.refreshCounters();
                    TestRunnerViewPart.this.m_stopButton.setEnabled(false);
                }
            });
        }
        this.showResultsInTree();
    }

    public void onStart(TestMessage tm) {
        RunInfo ri = new RunInfo(tm.getSuiteName(), tm.getTestName());
        ri.m_methodCount = tm.getTestMethodCount();
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.updateProgressBar();
                TestRunnerViewPart.this.m_stopButton.setEnabled(true);
            }
        });
    }

    private void updateProgressBar() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                int newMaxBar = TestRunnerViewPart.this.currentSuiteRunInfo.getNewMax();
                TestRunnerViewPart.this.fProgressBar.setMaximum(newMaxBar, TestRunnerViewPart.this.currentSuiteRunInfo.getMethodTotalCount());
            }
        });
    }

    public void onFinish(TestMessage tm) {
        this.updateProgressBar();
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.fProgressBar.stepTests();
                TestRunnerViewPart.this.m_stopButton.setEnabled(false);
            }
        });
    }

    private RunInfo createRunInfo(TestResultMessage trm, String stackTrace, int type) {
        String testName = trm.getName();
        if (testName == null) {
            testName = "Default test";
        }
        return new RunInfo(trm.getSuiteName(), testName, trm.getTestClass(), trm.getMethod(), trm.getTestDescription(), trm.getInstanceName(), trm.getParameters(), trm.getParameterTypes(), trm.getEndMillis() - trm.getStartMillis(), stackTrace, type, trm.getInvocationCount(), trm.getCurrentInvocationCount());
    }

    public void onTestSuccess(TestResultMessage trm) {
        this.postTestResult(this.createRunInfo(trm, null, 1), 0);
    }

    public void onTestFailure(TestResultMessage trm) {
        String desc = trm.getTestDescription();
        if (desc != null) {
            this.getTestDescriptions().add(desc);
        }
        this.postTestResult(this.createRunInfo(trm, trm.getStackTrace(), 2), 1);
    }

    public void onTestSkipped(TestResultMessage trm) {
        this.postTestResult(this.createRunInfo(trm, trm.getStackTrace(), 3), 1);
    }

    public void onTestFailedButWithinSuccessPercentage(TestResultMessage trm) {
        this.postTestResult(this.createRunInfo(trm, trm.getStackTrace(), 4), 1);
    }

    public Set<String> getTestDescriptions() {
        if (this.testDescriptions == null) {
            this.testDescriptions = new HashSet<String>();
        }
        return this.testDescriptions;
    }

    public void run() {
        ILaunch launch = this.getLastLaunch();
        if (launch != null && this.currentSuiteRunInfo.hasErrors()) {
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            try {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                Set<String> descriptions = this.getTestDescriptions();
                if (!descriptions.isEmpty()) {
                    StringBuffer buf = new StringBuffer();
                    Iterator<String> it = descriptions.iterator();
                    boolean first = true;
                    while (it.hasNext()) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(",");
                        }
                        buf.append(it.next());
                    }
                    config = LaunchUtil.addJvmArg(TestNGPlugin.getFailedTestsKey(), buf.toString(), wc);
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            LaunchUtil.launchFailedSuiteConfiguration(this.m_workingProject, launch.getLaunchMode());
        }
    }

    public void onTestStart(TestResultMessage trm) {
    }

    public void onStart(SuiteMessage suiteMessage) {
        m_summaryTab.setExcludedMethodsModel(suiteMessage);
    }

    private String getProjectName() {
        IJavaProject project = this.getLaunchedProject();
        return project != null ? project.getProject().getName() : null;
    }

    void reset(final SuiteRunInfo run) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.currentSuiteRunInfo = run;
                TestRunnerViewPart.this.refreshCounters();
                TestRunnerViewPart.this.clearStatus();
                for (TestRunTab tab : ALL_TABS) {
                    tab.updateTestResult(TestRunnerViewPart.this.currentSuiteRunInfo.getResults());
                }
            }
        });
    }

    class IsRunningJob
    extends Job {
        public IsRunningJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            TestRunnerViewPart.this.m_runLock.acquire();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_RUN;
        }
    }

    private class OpenReportAction
    extends Action {
        public OpenReportAction() {
            this.setText(ResourceUtil.getString("TestRunnerViewPart.openreport.label"));
            this.setToolTipText(ResourceUtil.getString("TestRunnerViewPart.openreport.tooltip"));
            this.setDisabledImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/report.gif"));
            this.setHoverImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/report.gif"));
            this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/report.gif"));
        }

        private void openEditor(IFile file) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            }
            catch (PartInitException e) {
                TestNGPlugin.log(e);
            }
        }

        public void run() {
            IJavaProject javaProject;
            Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
            IJavaProject iJavaProject = javaProject = TestRunnerViewPart.this.m_workingProject != null ? TestRunnerViewPart.this.m_workingProject : JDTUtil.getJavaProjectContext();
            if (javaProject == null) {
                return;
            }
            PreferenceStoreUtil storage = TestNGPlugin.getPluginPreferenceStore();
            Path filePath = new Path(String.valueOf(storage.getOutputDirectoryPath(javaProject).toOSString()) + "/index.html");
            boolean isAbsolute = storage.isOutputAbsolutePath(javaProject.getElementName(), false);
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            if (isAbsolute) {
                IFile file = javaProject.getProject().getFile("temp-testng-index.html");
                try {
                    file.createLink((IPath)filePath, 0, (IProgressMonitor)progressMonitor);
                    if (file == null) {
                        return;
                    }
                    try {
                        this.openEditor(file);
                    }
                    finally {
                        file.delete(true, (IProgressMonitor)progressMonitor);
                    }
                }
                catch (CoreException coreException) {}
            } else {
                IFile file = (IFile)workspace.newResource((IPath)filePath, 1);
                if (file == null) {
                    return;
                }
                try {
                    file.refreshLocal(0, (IProgressMonitor)progressMonitor);
                    this.openEditor(file);
                }
                catch (CoreException coreException) {}
            }
        }
    }

    private class RerunAction
    extends Action {
        public RerunAction() {
            this.setText(ResourceUtil.getString("TestRunnerViewPart.rerunaction.label"));
            this.setToolTipText(ResourceUtil.getString("TestRunnerViewPart.rerunaction.tooltip"));
            this.setDisabledImageDescriptor(TestNGPlugin.getImageDescriptor("dlcl16/relaunch.gif"));
            this.setHoverImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunch.gif"));
            this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunch.gif"));
        }

        public void run() {
            ILaunch launch = TestRunnerViewPart.this.getLastLaunch();
            if (launch != null) {
                DebugUITools.launch((ILaunchConfiguration)launch.getLaunchConfiguration(), (String)launch.getLaunchMode());
            }
        }
    }

    private class RerunFailedAction
    extends Action {
        public RerunFailedAction() {
            this.setText(ResourceUtil.getString("TestRunnerViewPart.rerunfailedsaction.label"));
            this.setToolTipText(ResourceUtil.getString("TestRunnerViewPart.rerunfailedsaction.tooltip"));
            this.setDisabledImageDescriptor(TestNGPlugin.getImageDescriptor("dlcl16/relaunchf.gif"));
            this.setHoverImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunchf.gif"));
            this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/relaunchf.gif"));
        }

        public void run() {
            ILaunch launch = TestRunnerViewPart.this.getLastLaunch();
            if (launch != null && TestRunnerViewPart.this.currentSuiteRunInfo.hasErrors()) {
                LaunchUtil.launchFailedSuiteConfiguration(TestRunnerViewPart.this.m_workingProject, launch.getLaunchMode(), launch.getLaunchConfiguration(), TestRunnerViewPart.this.getTestDescriptions());
            }
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int fActionOrientation;

        public ToggleOrientationAction(TestRunnerViewPart v, int orientation) {
            super("", 8);
            if (orientation == 1) {
                this.setText(ResourceUtil.getString("TestRunnerViewPart.toggle.horizontal.label"));
                this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/th_horizontal.gif"));
            } else if (orientation == 0) {
                this.setText(ResourceUtil.getString("TestRunnerViewPart.toggle.vertical.label"));
                this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/th_vertical.gif"));
            } else if (orientation == 2) {
                this.setText(ResourceUtil.getString("TestRunnerViewPart.toggle.automatic.label"));
                this.setImageDescriptor(TestNGPlugin.getImageDescriptor("elcl16/th_automatic.gif"));
            }
            this.fActionOrientation = orientation;
        }

        public int getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestRunnerViewPart.this.fOrientation = this.fActionOrientation;
                TestRunnerViewPart.this.computeOrientation();
            }
        }
    }

    class UpdateUIJob
    extends UIJob {
        private volatile boolean fRunning;

        public UpdateUIJob(String name) {
            super(name);
            this.fRunning = true;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TestRunnerViewPart.this.isDisposed()) {
                TestRunnerViewPart.this.refreshCounters();
            }
            this.schedule(200L);
            return Status.OK_STATUS;
        }

        public void stop() {
            this.fRunning = false;
        }

        public boolean shouldSchedule() {
            return this.fRunning;
        }
    }
}

