/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.refactoring;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.TextEdit;
import org.testng.eclipse.ui.conversion.AnnotationRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFolderChange
extends CompositeChange {
    public SourceFolderChange(String path, Collection<IResource> resources) {
        super(path);
        for (IResource resource : resources) {
            this.add(this.createChange(resource));
        }
        this.setEnabled(path.contains("test/"));
    }

    private Change createChange(IResource resource) {
        TextFileChange result = null;
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource((ICompilationUnit)JavaCore.create((IResource)resource));
        CompilationUnit astRoot = (CompilationUnit)parser.createAST(null);
        AST ast = astRoot.getAST();
        ASTRewrite rewriter = new AnnotationRewriter().createRewriter(astRoot, ast);
        try {
            TextEdit edit = rewriter.rewriteAST();
            result = new TextFileChange(resource.getName(), (IFile)resource);
            result.setEdit(edit);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return result;
    }
}

