/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch.components;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.testng.eclipse.util.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxTable
extends SelectionStatusDialog {
    protected CheckboxTableViewer m_viewer;
    private String[] m_elements;
    private List<Object> m_selection = Lists.newArrayList();

    public CheckBoxTable(Shell shell, Collection<String> elements, String titleId) {
        this(shell, elements.toArray(new String[elements.size()]), titleId);
    }

    public CheckBoxTable(Shell shell, String[] elements, String titleId) {
        super(shell);
        this.m_elements = elements;
        this.setSelectionResult(null);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.setBlockOnOpen(true);
        this.setTitle(ResourceUtil.getString(titleId));
    }

    protected void removeSelectionElements() {
        ArrayList toRemove = Lists.newArrayList();
        for (Object element : this.m_selection) {
            if (this.m_viewer.setChecked((Object)element.toString(), true)) continue;
            toRemove.add(element);
        }
        this.m_selection.removeAll(toRemove);
    }

    protected void cancelPressed() {
        this.setSelectionResult(null);
        super.cancelPressed();
    }

    protected CheckboxTableViewer createTableViewer(Composite parent) {
        this.m_viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.m_viewer.setContentProvider((IContentProvider)new GroupNamesContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new GroupNameLabelProvider());
        this.m_viewer.setInput((Object)this.m_elements);
        this.removeSelectionElements();
        return this.m_viewer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        CheckboxTableViewer tableViewer = this.createTableViewer(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(18);
        Table tableWidget = tableViewer.getTable();
        tableWidget.setLayoutData((Object)data);
        tableWidget.setFont(composite.getFont());
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean add = event.getChecked();
                if (add) {
                    CheckBoxTable.this.m_selection.add(element);
                } else {
                    CheckBoxTable.this.m_selection.remove(element);
                }
                CheckBoxTable.this.updateOKStatus();
            }
        });
        CheckBoxTable.applyDialogFont((Control)composite);
        return composite;
    }

    protected void updateOKStatus() {
        this.computeResult();
        if (this.getResult() != null) {
            this.updateStatus((IStatus)new StatusInfo());
        } else {
            this.updateStatus((IStatus)new StatusInfo(4, ""));
        }
    }

    public String[] getSelectedElements() {
        return this.m_selection.toArray(new String[this.m_selection.size()]);
    }

    protected void computeResult() {
        this.setSelectionResult(this.m_selection.toArray());
    }

    public void checkElements(String[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.m_selection.add(elements[i]);
            ++i;
        }
    }

    private static class GroupNameLabelProvider
    implements ILabelProvider {
        private GroupNameLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return (String)element;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    private static class GroupNamesContentProvider
    implements IStructuredContentProvider {
        private GroupNamesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof String[]) {
                return (String[])inputElement;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

